//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeFontTable.C,v 1.1 1996/11/17 09:23:36 ben Exp $

#include <XeFontTable.h>
#include <XeApp.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#define TABLESIZE	64

struct FontTableElem {
	FontTableElem	*_prev, *_next;
	XFontStruct*	_font;
	char*			_key;
};

XeFontTable::XeFontTable(void)
{
	_table = new FontTableElem*[TABLESIZE];
	for(int i=0; i < TABLESIZE; i++) {
		_table[i] = NULL;
	}
}

XeFontTable::~XeFontTable(void)
{
	FontTableElem **head;
    FontTableElem *temp;
    
    for(int i=0; i<TABLESIZE; i++) {
		head = &_table[i];
		while((temp = *head)) {
	    	*head = (*head)->_next;
	    	XFreeFont(gDisplay, temp->_font);
	    	free(temp->_key);
	    	delete temp;
		}
    }
    delete[] _table;
}

XFontStruct*
XeFontTable::getFont(const char* fontname)
{
	XFontStruct* theFont = NULL;
	char** fonts;
	int count;
	
	fonts = XListFonts(gDisplay, fontname, 1, &count);
	if(!count)
		goto end;
	
	if((theFont = exists(fonts[0]))) {
//printf("Restoring Font 0x%08x at index: %d name: %s\n", 
//	theFont->fid, hash(fonts[0]), fonts[0]);

		goto end;
	}
	
	theFont = XLoadQueryFont(gDisplay, fonts[0]);
	if(!theFont) // Unable to load this font.
		goto end;
		
	addFont(theFont, fonts[0]);
	
end:
	XFreeFontNames(fonts);
	return theFont;
}

int
XeFontTable::hash(const char* key)
{
	int len = strlen(key);
	int hash = 0;
	char* str = (char*)key;
	
	while(len--)
		hash = (hash << 1) ^ *str++;
	hash = abs(hash);
	return hash % TABLESIZE;
}

void
XeFontTable::addFont(XFontStruct* font, const char* key)
{
//printf("Adding Font 0x%08x at index: %d name: %s\n", font->fid, hash(key), key);

	FontTableElem **head = &_table[hash(key)];
    FontTableElem *elem = new FontTableElem;
    
    elem->_key = strdup(key);
    elem->_font = font;
    elem->_prev = NULL;
    
    if(*head) {
		(*head)->_prev = elem;
    }
    elem->_next = *head;
    *head = elem;
}

XFontStruct*
XeFontTable::exists(const char* key)
{
    FontTableElem *temp = _table[hash(key)];
    
    while(temp) {
    	if(!strcmp(key, temp->_key))
    		return temp->_font;
    	temp = temp->_next;
    }
    return NULL;
}

