//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeDpList.h,v 1.1 1996/11/17 09:22:58 ben Exp $

#ifndef _XeDpList_H_
#define _XeDpList_H_

#include <Xe.h>

class DpListNode {
private:
	DpListNode(void* d) : _data(d) { _next = NULL; 
		_prev = NULL; }
	
	DpListNode*		_next, *_prev;
	void*			_data;
	
	friend class XeDpList;
	friend class XeDpListIterator;
};
	
class XeDpList {
public:
	XeDpList(void);
	~XeDpList(void);
	
	void	add(void* data);
	//void	remove(void);
	void	remove(DpListNode* node);
	bool	remove(void* data);
	
	//int		find(void* data);
	
	int		getSize() { return _items; }
	void*	head(void) { return (_head) ? _head->_data : NULL; }
	void*	tail(void) { return (_tail) ? _tail->_data : NULL; }
	
private:
	DpListNode*	_head, *_tail;
	int			_items;
	
	friend class XeDpListIterator;
};

class XeDpListIterator {
public:
	XeDpListIterator(XeDpList* list) :
		_list(list) { _index = _list->_head; }
	
	bool	next(void);
	bool	prev(void);
	
	void*	item(void) { return (_index) ? _index->_data : NULL; }
	
	void	resetHead(void) { _index = _list->_head; }
	void	resetTail(void) { _index = _list->_tail; }
	
private:
	XeDpList*	_list;
	DpListNode*	_index;
	
};

#endif
