//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeDpList.C,v 1.1 1996/11/17 09:22:58 ben Exp $

#include <XeDpList.h>

XeDpList::XeDpList(void)
{
	_head = _tail = NULL;
	_items = 0;
}

XeDpList::~XeDpList(void)
{
	DpListNode* temp;
	
	while((temp = _head)) {
		_head = _head->_next;
		delete temp;
	}
}

void
XeDpList::add(void* data)
{
	DpListNode* temp = new DpListNode(data);
	
	if(_tail) {
		_tail->_next = temp;
		temp->_prev = _tail;
	}
	_tail = temp;
	
	if(!_head)
		_head = _tail;
	
	_items++;
}

void
XeDpList::remove(DpListNode* node)
{
	if(!node)
		return;
	
	if(node->_next) {
		node->_next->_prev = node->_prev;
	} else {
		_tail = node->_prev;
	}

	if(node->_prev) {
		node->_prev->_next = node->_next;
	} else {
		_head = node->_next;
	}
	delete node;
	
	_items--;
}

bool
XeDpList::remove(void* data)
{
	DpListNode* temp = _head;
	
	while(temp) {
		if(temp->_data == data) {
			remove(temp);
			return TRUE;
		}
		temp = temp->_next;
	}
	return FALSE;
}

bool
XeDpListIterator::next(void)
{
	if(!_index)
		return FALSE;
	
	_index = _index->_next;
	return TRUE;
}

bool
XeDpListIterator::prev(void)
{
	if(!_index)
		return TRUE;
		
	_index = _index->_prev;
	return TRUE;
}
