//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeDialog.h,v 1.6 1999/07/18 10:33:49 ben Exp $

#ifndef _XeDialog_H_
#define _XeDialog_H_

#include <XeWindow.h>
#include <XeObjectTable.h>

class XeDialog : public XeWindow {
public:
	XeDialog(XeWindow* parent, const char* name, const char* title,
		const char* className = "Dialog");
	virtual ~XeDialog(void);
	
	virtual int		doEvent(XEvent* theEvent);
	virtual void	closeEvent(void);
	    
    void	setParentWindow(XeWindow*);
    void	setXFocusWindow(bool) {} // do nothing
    
    XeWindow*	getParentWindow()
    					{ return _parentWindow; }
	
    virtual XeWindow::WType	windowType();
    
    XeObjectTable&	getTable(void)
    					{ return _objectTable; }
	
protected:
	XeObjectTable	_objectTable;
	XeWindow*		_parentWindow;
	
	bool	_isModal, _hasGrab;
	
	void	onModal(void);
	void	offModal(void);
	
	virtual void    doShow();
    virtual void    doHide();
};

#endif
