//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeDialog.C,v 1.7 1999/11/23 03:40:06 ben Exp $

#include <XeDialog.h>
#include <XeSpList.h>

XeDialog::XeDialog(XeWindow* parent, const char* name, 
	const char* title, const char* className) :
		XeWindow(name, title, className), _objectTable(32)
{
	_isModal = TRUE;
	_hasGrab = FALSE;
	_parentWindow = parent;
	
	XSetTransientForHint(gDisplay, _window, parent->getWindow());

	_objectTable.addObject(this, _window);
	
	gDialogList.add(this);
}

XeDialog::~XeDialog(void)
{
	if(_hasGrab)
		offModal();
	gDialogList.remove(this);
}

void
XeDialog::setParentWindow(XeWindow* w)
{
	_parentWindow = w;
	XSetTransientForHint(gDisplay, _window, w->getWindow());
}

XeWindow::WType
XeDialog::windowType(void)
{
	return XE_DIALOG;
}

int
XeDialog::doEvent(XEvent* theEvent)
{
	switch(theEvent->type) {
		case FocusIn:
		case FocusOut:
			// Override FocusIn/FocusOut behavoir (do nothing)
			break;
		default:
			XeWindow::doEvent(theEvent);
	}
	return 0;
}

void
XeDialog::closeEvent(void)
{
	hide();
}

void
XeDialog::doShow(void)
{
	onModal();	
}

void
XeDialog::doHide(void)
{
	if((XeDialog*)gDialogListUp.head() != this)
		return;
	
	offModal();
}

//
// onModal() should (if it works) grab the keyboard and
//	pointer so all events go to the dialog box. This is not
//	very X-Friendly but is a quick and easy way to get a
//	modal dialog box going.
//

void
XeDialog::onModal(void)
{
	if(_hasGrab)
		return;
	_hasGrab = TRUE;
	
	XeDialog* topDialog = (XeDialog*)gDialogListUp.head();
	
	// Update visual focus status of window/dialog that is
	// below this one.
	
	if(!topDialog) {
		// This dialog is the first layer over a window
		_parentWindow->takeFocus(FALSE);
	} else {
		topDialog->takeFocus(FALSE);
	}
	
	takeFocus(TRUE);
	
	gDialogListUp.add(this);
	
/*
	int status = XGrabPointer(gDisplay, _window, false,
		GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
	if(status != GrabSuccess) {
		fprintf(stderr, "%s: XeDialog::onModal - failed to grab pointer.\n,
			gProgname);
		_hasGrab = FALSE;
		hide();
	}
*/
}

void
XeDialog::offModal(void)
{
	if(!_hasGrab)
		return;
	_hasGrab = FALSE;
	
	gDialogListUp.remove();
	
	XeDialog* topDialog = (XeDialog*)gDialogListUp.head();
	
	// Update visual focus status of window/dialog that is
	// below this one.
	
	if(!topDialog) {
		// $$$ This isn't so simple
		// use a new static window object in XeWindow to set the focus
		
		//_parentWindow->takeFocus(TRUE);
		
		if (XeWindow::_xfocusWindow)
			XeWindow::_xfocusWindow->takeFocus(TRUE);
		
	} else {
		// $$$ topDialog may not actually have X focus...
		topDialog->takeFocus(TRUE);
	}
	
	//XUngrabPointer(gDisplay, CurrentTime);
}
