//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeContainer.h,v 1.2 1997/03/24 09:29:37 ben Exp $

#ifndef _XeContainer_H_
#define _XeContainer_H_

#include <XeObject.h>

class XeContainer : public XeObject {
public:
	enum FrameStyle {
		XE_ETCHED_OUT,
		XE_ETCHED_IN
	};
	
	XeContainer(XeObject* parent, const char* name, 
		const char* className = "Container");
	virtual ~XeContainer(void);
	
	virtual int	    doEvent(XEvent *theEvent);
        
    // Set Functions:
    void	setStyle(FrameStyle style) { _style = style; }
    void	setBorder(int width) { _borderWidth = width; }
    
    // Get Functions:
    int		border() { return _borderWidth; }
    
protected:
	GC			_shadowGC, _rshadowGC;
	int			_borderWidth;
	FrameStyle	_style;
	
	virtual void	doResize(uint width, uint height);
    virtual void    doMove(int x, int y);
    virtual void	doReconfigure(void);

	void doExpose(XExposeEvent *);
};

#endif
