//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeContainer.C,v 1.2 1997/03/24 09:29:37 ben Exp $

#include <XeContainer.h>
#include <XeApp.h>

#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

XeContainer::XeContainer(XeObject* parent, const char* name, const char* className) :
	XeObject(parent, name, className)
{
	_isContainer = TRUE;
	_borderWidth = 0;
	_style = XE_ETCHED_IN;
	
	XGCValues values;
	ulong valuemask;
	
	valuemask = GCForeground;
	values.foreground = lookupColour(this, "grey90");
	_rshadowGC = getGC(this, &values, valuemask);
	
	values.foreground = lookupColour(this, "grey40");
	_shadowGC = getGC(this, &values, valuemask);
	     
	XSelectInput(gDisplay, _window, ExposureMask);
}

XeContainer::~XeContainer(void)
{

}

int
XeContainer::doEvent(XEvent* theEvent)
{
	switch(theEvent->type) {
		case Expose:
	   		doExpose((XExposeEvent *)theEvent);
	    	break;
		default:
	    	XeObject::doEvent(theEvent);
    }
    return 0;
}

void
XeContainer::doResize(uint width, uint height)
{
	if (width == _width && height == _height)
		return;

	XResizeWindow(gDisplay, _window, width, height);
	
	// Virtual function call:
	resizeEvent(width, height);
	
	_width = width;
	_height = height;
	
	callCallbacks(XE_CB_RESIZE, NULL);
}

void
XeContainer::doMove(int x, int y)
{
	if (x == _x && y == _y)
		return;
	
	XMoveWindow(gDisplay, _window, x, y);
	_x = x;
	_y = y;
}

void
XeContainer::doReconfigure(void)
{
	XMoveResizeWindow(gDisplay, _window, _x, _y, _width, _height);
	
	// Virtual function call:
	resizeEvent(_width, _height);
	
	callCallbacks(XE_CB_RESIZE, NULL);
}

void
XeContainer::doExpose(XExposeEvent *)
{
	XRectangle r;
	
	r.x = 0; r.y = 0;
	r.width = _width;
	r.height = _height;
	if(_borderWidth) {
		switch(_style) {
			case XE_ETCHED_IN:
				drawBorder(r, _borderWidth, _shadowGC, _rshadowGC);
				break;
			case XE_ETCHED_OUT:
				drawBorder(r, _borderWidth, _rshadowGC, _shadowGC);
				break;
		}
	}
}
