//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeButton.h,v 1.1 1996/11/17 09:18:51 ben Exp $

#ifndef _XeButton_H_
#define _XeButton_H_

#include <XeLabel.h>

class XeButton : public XeLabel {
public:
    XeButton(XeObject *parent, const char* name, 
    	const char* className = "Button");
    virtual ~XeButton(void);
        
    virtual int	    doEvent(XEvent *theEvent);
    
	virtual int commandKey(KeySym key, uint modifiers);
	
	// Set Functions:
	void	setLabel(const char* label);
	
private:
    GC		_shadowGC, _rshadowGC, _hiliteGC;
    bool	_inButton;
    
    void doExpose(XExposeEvent *);
    void doButton(XButtonEvent *);
    void doMotion(XMotionEvent *);
    
    void hilite(bool state, bool fromExpose=FALSE, bool drawText=TRUE);
    void	setResources(void);
};

#endif
