//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeButton.C,v 1.2 1997/03/10 11:09:30 ben Exp $

#include <XeButton.h>

#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/Xresource.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

XeButton::XeButton(XeObject* parent, const char* name, const char* className) :
	XeLabel(parent, name, className)
{
	_borderWidth = 2;
    _inButton = TRUE;
    _autoSize = FALSE;
    
	XGCValues values;
	ulong valmask;
	
	valmask = GCForeground;
	values.foreground = lookupColour(this, "grey40");
	_shadowGC = getGC(this, &values, valmask);
	values.foreground = lookupColour(this, "grey90");
	_rshadowGC = getGC(this, &values, valmask);
	values.foreground = lookupColour(this, "grey55");
	_hiliteGC = getGC(this, &values, valmask);
    
    XSelectInput(gDisplay, _window, (ButtonPressMask | ButtonReleaseMask 
		    | ButtonMotionMask | ExposureMask));
	    
}

XeButton::~XeButton(void)
{
}

int
XeButton::doEvent(XEvent* theEvent)
{
    switch(theEvent->type) {
		case Expose:
	    	doExpose((XExposeEvent *)theEvent);
	    	break;
		case ButtonPress:
		case ButtonRelease:
	    	doButton((XButtonEvent *)theEvent);
	    	break;
		case MotionNotify:
	    	doMotion((XMotionEvent *)theEvent);
	    	break;
		default:
	    	XeObject::doEvent(theEvent);
    }
    return 0;
}

void
XeButton::setLabel(const char* label)
{
	XeLabel::setLabel(label);
	hilite(FALSE, TRUE, FALSE);
}

void
XeButton::doExpose(XExposeEvent *)
{
    // simply hilite in off state
    hilite(FALSE, TRUE);
}

void
XeButton::doButton(XButtonEvent *event)
{
    if(event->type == ButtonPress) {
		_inButton = TRUE;
		hilite(TRUE);
    } else if(event->type == ButtonRelease) {
		if(_inButton) {
	    	hilite(FALSE);
	    	
	    	// we do the flush so the button gets redrawn
	    	// properly if it initiates a long task.
	    	XFlush(gDisplay); 
	    
	    	// call callbacks!!!
	    	callCallbacks(XE_CB_ACTIVATE, NULL);
		}
    }
}

void
XeButton::doMotion(XMotionEvent* event)
{
    int x = event->x;
    int y = event->y;
    if((x <= 0 || y <= 0 || x >= int(_width) || y >= int(_height)) 
    		&& _inButton) {
		hilite(FALSE);
		_inButton = FALSE;
    } else if((x >= 0 && y >= 0 && x <= int(_width) && y <= int(_height)) 
    		&& !_inButton) {
		hilite(TRUE);
		_inButton = TRUE;
    }
}

void
XeButton::hilite(bool state, bool fromExpose, bool drawText)
{
    XRectangle r1, r2 = { 0, 0, _width, _height };
    
    r1.x = _borderWidth;
    r1.y = _borderWidth;
    r1.width = _width - _borderWidth;
    r1.height = _height - _borderWidth;
    
    if(state) {
    	XFillRectangle(gDisplay, _window, _hiliteGC, r1.x, r1.y, 
    		r1.width, r1.height);
		drawBorder(r2, _borderWidth, _shadowGC, _rshadowGC);
    } else {
    	if(!fromExpose)
    		XClearArea(gDisplay, _window, r1.x, r1.y, r1.width, r1.height, False);
		drawBorder(r2, _borderWidth, _rshadowGC, _shadowGC);
    }
    
    // text drawing function from XeLabel
    if(drawText)
    	XeLabel::drawText();
}

void
XeButton::setResources(void)
{

}

// This Stuff is a bit of a mess:

int
XeButton::commandKey(KeySym key, uint)
{
	//printf("XeButton::commandKey - 0x%04x 0x%08x\n", key, modifiers);
	// bit 'o a hack to get an acceptable command key
	// handler with auto repeat on..
	
	KeySym theKey;
	XKeyEvent* keyEvent;
    XEvent event;
    
    #if 0
    while(XCheckMaskEvent(gDisplay, mask, &event)) {
    	printf("Cleaning up Event: %s\n", event_names[event.type]);
		lastEvent = &event;
	}
	//if(lastEvent->type == KeyRelease)
	//	return 1;
	#endif
	
    hilite(TRUE);
	XAutoRepeatOff(gDisplay);
	XFlush(gDisplay);
	
	// clean up key press and release events from the
	// queue so stacked up auto key stuff doesn't cause
	// commandKey() to be invoked masses of times.
		
	while(1) {
		XNextEvent(gDisplay, &event);
		if(event.type == KeyRelease) {
			keyEvent = (XKeyEvent *)&event;
			theKey = XLookupKeysym(keyEvent, 0);
			if(key == theKey) {
				hilite(FALSE);
				XAutoRepeatOn(gDisplay);
				XFlush(gDisplay);
				callCallbacks(XE_CB_ACTIVATE, NULL);
				break;
			}
		}
	}
	return 0;
}

