//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeArray.h,v 1.1 1996/11/17 09:17:18 ben Exp $

#ifndef _XeArray_H_
#define _XeArray_H_

#include <Xe.h>

template <class T>
class XeArray {
public:
	XeArray(int extrabuf=256, int size = 0);
	~XeArray();
	
	ulong	getSize() { return _elements; }
	ulong	getBufsize() { return _bufsize; }
	
	void	replaceBuffer(T* newbuf, ulong len);
	
	void	deleteRange(ulong startIndex, ulong endIndex);
	void	replaceRange(ulong startIndex, ulong endIndex, 
				const T* array, int len);
	void	insert(ulong index, const T* array, int len);
	void	insert(ulong index, T item);
	
	T&		operator[](ulong index);
	
private:
	T*		_data;
	ulong	_bufsize;
	ulong	_elements;
	int		_extrabuf;
};

//#include <XeArray.C>

#endif
