//
// Copyright (c) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeApp.h,v 1.5 1999/07/29 15:06:14 ben Exp $

#ifndef _XeApp_H_
#define _XeApp_H_

#include <Xe.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>

#include <Kr/KrCB.h>
#include <Kr/KrTime.h>

#if 0
typedef void	(*XeFdCallback)(void*);
typedef bool	(*XeWorkproc)(void*);
typedef void	(*XeTimeout)(void*);
#endif

typedef int 	(*XErrorHandler)(Display*, XErrorEvent*);

#define XE_INPUT_READ	(1L)
#define XE_INPUT_WRITE	(1L << 1)
#define XE_INPUT_EXCEPT	(1L << 2)

class XeObject;
class XeWpNode;
class XeFdNode;
class XeTNode;

class XeApp {
public:
    XeApp(const char* className, int& argc, char** argv);
    ~XeApp(void);
    
    void    run(void);
    
#if 0
    //
    // workproc and input callback support.
    //
    ulong	addWorkproc(XeWorkproc func, void* clientData);
    ulong	addAppInput(XeFdCallback func, int fd, ulong eventmask, void* clientData);
    
    void	removeWorkproc(ulong wpid);
    void	removeAppInput(ulong inputid);
#endif

    void	setTimeout(const KrCB& cb, KrTime time);
    void	clearTimeout(void);
    
    
    // Temporarily here so XeText can use it.
    void	doUpdate(void);
    
    bool	setRunOnce(const KrCB& cb, int argc, char** argv);

    struct RunOnceCBData {
    	const char*	cwd;
    	int			argc;
    	char**		argv;
    };
    
private:	
	// number of seconds before app times out (quits)
	long		_timeout;	
	XeTNode*	_tout;
	
	KrCB		_runOnceCB;
	
	Atom		_windowIdRoot;	// XA_WINDOW
	Atom		_windowArg;		// XA_STRING
	Atom		_windowUid;		// XA_INTEGER
	Atom		_windowIPAddr;	// XA_INTEGER

    void	doEvent(XEvent* theEvent);

    void	mergeResourceDatabases(void);    

#if 0
	// Head pointers for callback lists
	XeWpNode*	_workprocHead;
	XeFdNode*	_inputHead;

    void	callWorkprocs(void);
    void	setInputCallbacks(fd_set* rset, fd_set* wset, fd_set* eset);
    void	callInputCallbacks(fd_set* rset, fd_set* wset, fd_set* eset);
#endif
};

//
// Timeout Class
//

class XeTNode {
public:
//	void*	getAuxData() { return _aux; }
	KrTime	getPeriod() { return _period; }
	KrTime	getTime() { return _when; }
	
private:
	XeTNode(const KrCB& cb, KrTime time)
		: _cb(cb), _period(time) {
			_when = KrTime::now();
		}
	
	void	call(void) {
			_when += _period;
			_cb(this);
		}
	
	KrCB		_cb;
	KrTime		_period;
	KrTime		_when;
	
	friend class XeApp;
};

// Globals:

extern XeApp*			gApp;

extern const char		*gProgname;
extern const char		*gClassname;
extern KrAtom			gCwd;
extern XrmQuark			gProgQuark;
extern XrmQuark			gClassQuark;

extern Display	*gDisplay;
extern Screen	*gScreenPtr;
extern int		gScreenNum;

extern int		gDepth;
extern int		gVisualClass;
extern Visual*	gVisual;

class XeSpList;

extern XeSpList	gDialogListUp;
extern XeSpList	gDialogList;

extern Atom		XA_WM_PROTOCOLS;

extern int		gGeometryFlags;
extern int		gX, gY;
extern uint		gWidth, gHeight;

//
// Functions:
//

int portaselect(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds,
    struct timeval *timeout);

bool getAppResource(const char* res, const char* clas, XrmValue* val);

#endif
