//
// Copyright (c) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: XeApp.C,v 1.8 1999/11/09 07:10:06 ben Exp $

#include <XeObject.h>
#include <XeApp.h>
#include <XeObjectTable.h>

#include <XeWindow.h>
#include <XeDialog.h>
#include <XeSpList.h>

#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <pwd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <limits.h>
#include <errno.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef _SGI_SOURCE
#include <alloca.h>
#include <bstring.h>
#endif

XeApp*		gApp;

const char*	    gProgname;
const char*	    gClassname;
KrAtom			gCwd;
int				gLocalIPAddr;

XrmQuark		gProgQuark;
XrmQuark		gClassQuark;

Display*    gDisplay;
Screen*	    gScreenPtr;
int	    	gScreenNum;

XrmDatabase	gResourceDatabase;

int			gDepth = 0;
int			gVisualClass = 0;
Visual*		gVisual = NULL;
XeSpList	gDialogListUp;
XeSpList	gDialogList;

Atom		XA_WM_PROTOCOLS;

int		gGeometryFlags;
int		gX, gY;
uint	gWidth, gHeight;

Window	gRunOnceWindow = None;

extern XeObjectTable	gObjectTable;
extern XeSpList			gUpdateList;

// Root window property name
#define XE_WINDOWID "XE_WINDOWID"

// Run once window properties:
#define XE_ARG		"XE_ARG"
#define XE_UID		"XE_UID"
#define XE_IPADDR	"XE_IPADDR"

// X command line options to parse:

XrmOptionDescRec gOptionsRec[] = {
	{ "-geometry", ".geometry", XrmoptionSepArg, NULL },
};

#if 0
class XeWpNode {
private:
	XeWpNode(XeWorkproc wp, void* clientData)
		: _wpFunc(wp), _clientData(clientData) {
		_next = NULL;	
	}
	~XeWpNode(void) {}
	
	XeWpNode*	_next;
	XeWorkproc	_wpFunc;
	void*		_clientData;
	
	friend class XeApp;
};

class XeFdNode {
private:
	XeFdNode(XeFdCallback fdfunc, int fd, ulong eventMask, void* clientData)
		: _fdFunc(fdfunc), _fd(fd), _eventMask(eventMask), _clientData(clientData) {
		_next = NULL;
	}
	~XeFdNode(void) {}
	
	XeFdNode*		_next;
	XeFdCallback	_fdFunc;
	int				_fd;
	ulong			_eventMask;
	void*			_clientData;
	
	friend class XeApp;
};
#endif

void	getGeometry(void);
void	getCwd();

XeApp::XeApp(const char* className, int& argc, char** argv)
{
	char *displayName = 0;
    char* tail = strrchr(argv[0], '/');
    
    // initializes gCwd
	getCwd();
	
	gApp = this;
    gClassname = className;
    gClassQuark = XrmPermStringToQuark(gClassname);
    gProgname = (const char*)((tail) ? tail + 1 : argv[0]);
    gProgQuark = XrmPermStringToQuark(gProgname);
    
    // $$$ put display into Xrm database?
	// Read display name from command line:
	//
	
	for (int i=0; i < argc; i++) {
		if (!strcmp(argv[i], "-display") && i != argc - 1) {
			displayName = argv[i + 1];
			argc -= 2;
			
			if (i < argc) // displayName isn't the last arg
				memmove(&argv[i], &argv[i + 2], sizeof(char*) * (argc - i));
		}
	}
		
    if((gDisplay = XOpenDisplay(displayName)) == NULL) {
		fprintf(stderr, "%s: XeApp::XeApp cannot connect to X server %s\n", 
	    	gProgname, XDisplayName(displayName));
		exit(0);
    }
    
    sockaddr saddr;

#if defined(__SVR4) || defined(_SGI_SOURCE)
	// Assume SGI is the only platform which requires a signed int
	// Solaris (and perhaps others) also falls into this category (__SVR4)
	
    int len = sizeof(saddr);
#else
    uint len = sizeof(saddr);
#endif

    gLocalIPAddr = 0;
    
    if (getsockname(ConnectionNumber(gDisplay), &saddr, &len) != -1)
    	if (saddr.sa_family == AF_INET)
    		gLocalIPAddr = ntohl(((sockaddr_in*)&saddr)->sin_addr.s_addr);
    
    gScreenNum = DefaultScreen(gDisplay);
    gScreenPtr = DefaultScreenOfDisplay(gDisplay);
    
    // Read in all standard resource files into resource database.
    //
    mergeResourceDatabases();
    
    // Read command line options into resource database
    //
    XrmParseCommand(&gResourceDatabase, gOptionsRec,
		sizeof(gOptionsRec) / sizeof(XrmOptionDescRec), 
		gProgname, &argc, argv);
	
    // Read App resources that rely on gDisplay
    //
    getGeometry();
    
    // For the moment lets use the default visual for all
    // XeObjects (later this can be specified on the command line)
	
	if(gDepth == 0) {
		XVisualInfo vinfo;
		XVisualInfo *visuals = NULL;
		int numVisuals;
    
		vinfo.visual = DefaultVisual(gDisplay, gScreenNum);
		visuals = XGetVisualInfo(gDisplay, VisualNoMask, &vinfo, &numVisuals);
		for(int i=0; i < numVisuals; i++) {
			if(visuals[i].visual == vinfo.visual) {
				gDepth = visuals[i].depth;
				gVisualClass = visuals[i].c_class;
				gVisual = vinfo.visual;
				break;
			}
		}
		XFree(visuals);
	}
	_tout = NULL;
    _timeout = 0;
#if 0
    _workprocHead = NULL;
    _inputHead = NULL;
#endif

	// Resolve some X atoms
	XA_WM_PROTOCOLS = XInternAtom(gDisplay, "WM_PROTOCOLS", False);

	_windowIdRoot = XInternAtom(gDisplay, XE_WINDOWID, False);
	_windowArg = XInternAtom(gDisplay, XE_ARG, False);
	_windowUid = XInternAtom(gDisplay, XE_UID, False);
	_windowIPAddr = XInternAtom(gDisplay, XE_IPADDR, False);
}

XeApp::~XeApp(void)
{
#if 0
    XeWpNode* wptemp;
    XeFdNode* fdtemp;
    
    while((wptemp = _workprocHead)) {
    	_workprocHead = _workprocHead->_next;
    	delete wptemp;
    }
    while((fdtemp = _inputHead)) {
    	_inputHead = _inputHead->_next;
    	delete fdtemp;
    }
#endif

    XCloseDisplay(gDisplay);
}

bool
XeApp::setRunOnce(const KrCB& cb, int argc, char** argv)
{
	// Prevent any race conditions from multiple processes
	// starting up simultaneously
	//
	XGrabServer(gDisplay);

	int result, fmt_return;
	ulong num_windows, bytes_after_return;
	uchar* data_return;
	Atom type_return;
	int uid = getuid();
	
	// Get list of run-once window ids from root window
	//
	result = XGetWindowProperty(gDisplay, RootWindow(gDisplay, gScreenNum),
			_windowIdRoot, 0, LONG_MAX, False, XA_WINDOW, &type_return,
			&fmt_return, &num_windows, &bytes_after_return, &data_return);
	
	Window* runOnceWindows = NULL;
	Window* actualWindows = NULL;
	
	if (result == Success && num_windows) {
		runOnceWindows = (Window*)alloca(32 * num_windows);
		actualWindows = (Window*)alloca(32 * (num_windows + 1));
		
		::memcpy(runOnceWindows, data_return, 32 * num_windows);
	}
	
	int num_actual_windows = 0;
	
	if (runOnceWindows) {
		
		Window match = None;
		Window root_return;
		Window parent;
		Window* children;
		uint nchildren;
		
		// Check which windows exist:
		//
		XQueryTree(gDisplay, RootWindow(gDisplay, gScreenNum), &root_return,
			&parent, &children, &nchildren);
		
		int i;
		for (i = 0; i < int(nchildren); i++) {
			for (uint j = 0; j < num_windows; j++) {
				if (children[i] == runOnceWindows[j]) {
					actualWindows[num_actual_windows++] = children[i];
					break;
				}
			}
			if (uint(num_actual_windows) == num_windows)
				break;
		}
		if (children)
			XFree(children);
		
		// Find a window with the same uid and local IP addr as this process:
		//
		for (i = 0; i < num_actual_windows; i++) {
			ulong length;
			int val;
			
			result = XGetWindowProperty(gDisplay, actualWindows[i],
						_windowUid, 0, 1, False, XA_INTEGER, &type_return,
						&fmt_return, &length, &bytes_after_return, &data_return);
			if (result == Success && length) {
				::memcpy(&val, data_return, sizeof(int));

				if (val != uid)
					continue;
			} else {
				continue;
			}
			
			result = XGetWindowProperty(gDisplay, actualWindows[i],
						_windowIPAddr, 0, 1, False, XA_INTEGER, &type_return,
						&fmt_return, &length, &bytes_after_return, &data_return);
			if (result == Success && length) {
				::memcpy(&val, data_return, sizeof(int));

				if (val != gLocalIPAddr)
					continue;
			} else {
				continue;
			}
			
			// we have a match:
			match = actualWindows[i];
			break;
		}
		
		// If an appropriate run once window is found, set its _windowArg
		// property with a list of arguments.
		//
		if (match != None) {
			gRunOnceWindow = match;
			
			// format property string with argc & argv
			//
			int arglen = gCwd.length() + 1;
			for (i=0; i < argc; i++)
				arglen += strlen(argv[i]) + 1;
			char* argbuf = (char*)alloca(arglen);
			char* arg = argbuf;
			
			strcpy(arg, gCwd.constCharP());
			arg += gCwd.length() + 1;
			
			for (i=0; i < argc; i++) {
				strcpy(arg, argv[i]);
				arg += strlen(argv[i]) + 1;
			}
			
			XChangeProperty(gDisplay, gRunOnceWindow, _windowArg, 
				XA_STRING, 8, PropModeReplace, (uchar*)argbuf, arglen);

			XUngrabServer(gDisplay);
			return FALSE;
		}
		// otherwise gRunOnceWindow is stale, create a new one
	}
	
	Window rootw = RootWindow(gDisplay, gScreenNum);

	gRunOnceWindow = XCreateWindow(gDisplay, rootw, 0, 0, 1, 1, 0, 
		0, InputOnly, gVisual, 0, NULL);
	
	XChangeProperty(gDisplay, gRunOnceWindow, _windowUid, 
				XA_INTEGER, 32, PropModeReplace, (uchar*)&uid, 1);
	XChangeProperty(gDisplay, gRunOnceWindow, _windowIPAddr,
				XA_INTEGER, 32, PropModeReplace, (uchar*)&gLocalIPAddr, 1);
	
	XSelectInput(gDisplay, 	gRunOnceWindow, PropertyChangeMask);
	
	if (!actualWindows)
		actualWindows = (Window*)alloca(32);
	actualWindows[num_actual_windows++] = gRunOnceWindow;
	
	XChangeProperty(gDisplay, rootw, _windowIdRoot,
		XA_WINDOW, 32, PropModeReplace, (uchar*)actualWindows, num_actual_windows);
	
	_runOnceCB = cb;
	
	XUngrabServer(gDisplay);
	return TRUE;
}

void
XeApp::run(void)
{
    XEvent  theEvent;
    int xfd = ConnectionNumber(gDisplay);
    fd_set  rset, wset, eset;
    int numfd;
    long mask = 0xffffffff;

	// clean up resource database:
	//XrmDestroyDatabase(gResourceDatabase);
	
	while(XCheckMaskEvent(gDisplay, mask, &theEvent))
			doEvent(&theEvent);
	
	doUpdate();
	//XFlush(gDisplay);
	
    while(1) {
		FD_ZERO(&rset);
		FD_ZERO(&wset);
		FD_ZERO(&eset);
		
		// Set X connection file descriptor.
		FD_SET(xfd, &rset);

#if 0
		//
		// Set stuff in fd_sets according to our input callbacks
		//
		setInputCallbacks(&rset, &wset, &eset);
#endif
	
		struct timeval* tvp = NULL;
//		struct timeval tv;
		
		if (_tout) {
			KrTime now = KrTime::now();
			
			if (_tout->_when <= now) {
				_tout->call();
				now = KrTime::now();
			}

#if 0
			if (!_workprocHead) {
				tv = _tout->_when - now;
				tvp = &tv;
			}
#endif
		}
#if 0
		if (_workprocHead) {
			tv = KrTime(0);
			tvp = &tv;
		}
#endif
		
		numfd = select(FD_SETSIZE, &rset, &wset, &eset, tvp);
		
#if 0
		if(!numfd) {
			if(!_workprocHead) {
				// the application timed out!
				//printf("%s: App Timeout! exiting...\n", gProgname);
				//exit(2);
			} else {
				// if any workprocs have been registered, call them, and if
				// any of them returns true, then deregister it.
				//callWorkprocs();
			}
		}
#endif

		if(FD_ISSET(xfd, &rset)) {
			while(XPending(gDisplay) > 0) {
	    		XNextEvent(gDisplay, &theEvent);
	    		doEvent(&theEvent);
	    	}
	    	
	    	//while(XCheckMaskEvent(gDisplay, mask, &theEvent))
			//	doEvent(&theEvent);
		}
		
		// Call graphics update virtual functions:
		doUpdate();
		XFlush(gDisplay);

#if 0
		//
		// Call Input callbacks.
		//
		//callInputCallbacks(&rset, &wset, &eset);
#endif	
    }
}

//
// doEvent - handle all the stuff revolving around processing
//	X events.
//

void
XeApp::doEvent(XEvent* theEvent)
{
	XeDialog* dialog;
	XeObject* ob;
	
	// Check for events that can apply to all windows, whether
	// they are mapped modal dialogs or not
	
	if(theEvent->type == SelectionClear ||
			theEvent->type == SelectionNotify ||
			theEvent->type == SelectionRequest) {
		XeSpListIterator iter(&gDialogList);
		XeDialog* item;
		
		ob = gObjectTable[theEvent->xany.window];
		while(!ob) {
			item = (XeDialog*)iter.item();
			iter.next();
			if(!item)
				return;
			ob = (item->getTable())[theEvent->xany.window];
		}
		ob->doEvent(theEvent);
		return;
	}
	
	if (theEvent->xany.window == gRunOnceWindow) {

		if (theEvent->type != PropertyNotify)
			return;
		
		if (((XPropertyEvent*)theEvent)->atom != _windowArg)
			return;
		
		int result, fmt_return;
		ulong length, bytes_after_return;
		uchar* data_return;
		Atom type_return;

		result = XGetWindowProperty(gDisplay, gRunOnceWindow,
			_windowArg, 0, LONG_MAX, False, XA_STRING, &type_return,
			&fmt_return, &length, &bytes_after_return, &data_return);
	
		RunOnceCBData cbdata;
		
		int argc = 0;
		char* p = (char*)data_return;

		cbdata.cwd = p;
		p += strlen(p) + 1;
		
		while (ulong(p - (char*)data_return) < length) {
			argc++;
			p += strlen(p) + 1;
		}
		cbdata.argc = argc;

		char** argv = (char**)alloca(argc * sizeof(char*));
		argc = 0;
		p = (char*)data_return + strlen((char*)data_return) + 1;
		while (ulong(p - (char*)data_return) < length) {
			argv[argc++] = p;
			p += strlen(p) + 1;
		}
		cbdata.argv = argv;
		
		_runOnceCB(&cbdata);
		return;
	}
	
	//
	// Handle dialogs:
	//
	if((dialog = (XeDialog*)gDialogListUp.head())) {
		XeSpListIterator iter(&gDialogListUp);
		XeDialog* temp;
		
		ob = gObjectTable[theEvent->xany.window];
		do {
			iter.next();
			if(ob && (theEvent->type == Expose 
					|| theEvent->type == GraphicsExpose
					|| theEvent->type == NoExpose
					|| theEvent->type == ConfigureNotify)) {
				ob->doEvent(theEvent);
				return;
			} else if(ob && (theEvent->type == KeyPress
					|| theEvent->type == KeyRelease)) {
				theEvent->xany.window = dialog->getWindow();
				break;		
			} else if(ob && (theEvent->type == FocusIn
					|| theEvent->type == FocusOut)) {
				
				ob->setXFocusWindow(theEvent->type == FocusIn);
				dialog->takeFocus(theEvent->type == FocusIn);
				return;
			}
			
			temp = (XeDialog*)iter.item();
			if(temp)
				ob = (temp->getTable())[theEvent->xany.window];
		} while (temp);
		
		ob = (dialog->getTable())[theEvent->xany.window];
	} else {
		ob = gObjectTable[theEvent->xany.window];
	}
	
	if(!ob)
		return;
	
	//
	// Handle global key events, checking to see if it's a command-key
	// event. And remapping Key events to the focus object.
	//
	
	if(theEvent->type == KeyPress || theEvent->type == KeyRelease) {
		XKeyEvent* keyEvent = (XKeyEvent*)theEvent;
		XeWindow* base = (XeWindow*)ob->_base;
		
		if(theEvent->type == KeyPress) {	
			KeySym key = XLookupKeysym(keyEvent, 0);
			
			if(!base->invokeCommand(key, keyEvent->state))
				return;
		}
		
		//
		// If the object's top-level window has a focus object set
		// then send the key event to that object rather than the
		// one it was destined for.
		//
		
		XeObject* focusOb = base->getFocusWindow();
		
		if(focusOb) {
			keyEvent->window = focusOb->getWindow();
			focusOb->doEvent(theEvent);
		} else {
			ob->doEvent(theEvent);
		}
	} else {
		ob->doEvent(theEvent);
	}
}

void
XeApp::doUpdate(void)
{
	if(!gUpdateList.getSize())
		return;
	
	XeSpListIterator iter(&gUpdateList);
	XeObject* temp;

	while((temp = (XeObject*)iter.item())) {
		temp->doUpdate();
		temp->_willUpdate = FALSE;
		iter.next();
		gUpdateList.remove();
	}
}

void
XeApp::setTimeout(const KrCB& cb, KrTime time)
{
	_tout = new XeTNode(cb, time);
}

void
XeApp::clearTimeout(void)
{
	if(_tout) {
		delete _tout;
		_tout = NULL;
	}
}

#if 0
//
// Workproc functions.
//

ulong
XeApp::addWorkproc(XeWorkproc func, void* clientData)
{
	XeWpNode* temp;
	
	temp = new XeWpNode(func, clientData);
	if(_workprocHead) {
		temp->_next = _workprocHead;
	}
	_workprocHead = temp;
	return (ulong)temp;
}

void
XeApp::removeWorkproc(ulong wpid)
{
	XeWpNode* temp = _workprocHead;
	XeWpNode* prev = NULL;
	
	while(temp) {
		if((XeWpNode*)wpid == temp) {
			if(!prev)
				_workprocHead = temp->_next;
			else
				prev->_next = temp->_next;
			delete temp;
			return;
		} else {
			prev = temp;
			temp = temp->_next;
		}
	}
}

void
XeApp::callWorkprocs(void)
{
	XeWpNode* temp = _workprocHead;
	XeWpNode* rem;
	
	while(temp) {
		if(temp->_wpFunc(temp->_clientData)) {
			rem = temp;
			temp = temp->_next;
			removeWorkproc((ulong)rem);
			continue;
		}
		temp = temp->_next;
	}
}

//
// Input callback functions.
//

ulong
XeApp::addAppInput(XeFdCallback func, int fd, ulong eventmask, void* clientData)
{
	XeFdNode* temp;
	
	temp = new XeFdNode(func, fd, eventmask, clientData);
	if(_inputHead) {
		temp->_next = _inputHead;
	}
	_inputHead = temp;
	return (ulong)temp;
}

void
XeApp::removeAppInput(ulong inputid)
{
	XeFdNode* temp = _inputHead;
	XeFdNode* prev = NULL;
	
	while(temp) {
		if((XeFdNode*)inputid == temp) {
			if(!prev)
				_inputHead = temp->_next;
			else
				prev->_next = temp->_next;
			delete temp;
			return;
		} else {
			prev = temp;
			temp = temp->_next;
		}
	}
}

void
XeApp::setInputCallbacks(fd_set* rset, fd_set* wset, fd_set* eset)
{
	XeFdNode* temp = _inputHead;
	
	while(temp) {
		if(temp->_eventMask & XE_INPUT_READ)
			FD_SET(temp->_fd, rset);
		if(temp->_eventMask & XE_INPUT_WRITE)
			FD_SET(temp->_fd, wset);
		if(temp->_eventMask & XE_INPUT_EXCEPT)
			FD_SET(temp->_fd, eset);
		temp = temp->_next;
	}
}

void
XeApp::callInputCallbacks(fd_set* rset, fd_set* wset, fd_set* eset)
{
	XeFdNode* temp = _inputHead;
		
	while(temp) {
		if(temp->_eventMask & XE_INPUT_READ)
			if(FD_ISSET(temp->_fd, rset))
				temp->_fdFunc(temp->_clientData);
		if(temp->_eventMask & XE_INPUT_WRITE)
			if(FD_ISSET(temp->_fd, wset))
				temp->_fdFunc(temp->_clientData);
		if(temp->_eventMask & XE_INPUT_EXCEPT)
			if(FD_ISSET(temp->_fd, eset))
				temp->_fdFunc(temp->_clientData);
		temp = temp->_next;
	}
}
#endif

void
XeApp::mergeResourceDatabases(void)
{
	// load up all resources into resource database

    XrmInitialize();
    
	XrmDatabase serverDB;
	char filename[1024];
	
	strcpy(filename, "/usr/lib/X11/app-defaults/");
	strcat(filename, gClassname);
	XrmCombineFileDatabase(filename, &gResourceDatabase, True);
	
	getHomeDir(filename);
	strcat(filename, "/");
	strcat(filename, gClassname);
	XrmCombineFileDatabase(filename, &gResourceDatabase, True);
	
	if(XResourceManagerString(gDisplay) != NULL) {
		serverDB = XrmGetStringDatabase(XResourceManagerString(gDisplay));
		XrmMergeDatabases(serverDB, &gResourceDatabase);
	}

	getHomeDir(filename);
	strcat(filename, "/.Xdefaults");
	XrmCombineFileDatabase(filename, &gResourceDatabase, True);
}

int
portaselect(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds,
	struct timeval *timeout)
{
	if (!timeout || (!timeout->tv_sec && !timeout->tv_usec))
		return select(nfds, readfds, writefds, exceptfds, timeout);

	KrTime ktimeout(timeout->tv_sec, timeout->tv_usec);
	KrTime before, after;
	int ret;

	before = KrTime::now();
	ret = select(nfds, readfds, writefds, exceptfds, timeout);
	after = KrTime::now();

	if (ret < 0)
		return ret;
	
	if (ret == 0) {
		timeout->tv_sec = timeout->tv_usec = 0;
		return 0;
	}
	
	KrTime duration = after - before;
	
	if (duration > ktimeout) {
		timeout->tv_sec = timeout->tv_usec = 0;
	
	} else {
		ktimeout -= duration;

		timeout->tv_sec = ktimeout.sec();
		timeout->tv_usec = ktimeout.usec();
	}
		
	return ret;
}

bool
getAppResource(const char* res, const char* clas, XrmValue* val)
{
	char rstring[1024];
	char cstring[1024];
	
	strcpy(rstring, gProgname);
	strcat(rstring, ".");
	strcat(rstring, res);
	
	strcpy(cstring, gClassname);
	strcat(cstring, ".");
	strcat(cstring, clas);
	
	char strtype[20];

	return XrmGetResource(gResourceDatabase, rstring, cstring, 
				(char**)&strtype, val);
}

void
getGeometry(void)
{
	XrmValue value;
	
	gGeometryFlags = 0;

	if (getAppResource("geometry", "geometry", &value)) {
#if 0
		char* str;
		str = (char*)alloca(value.size);
		strncpy(str, value.addr, value.size - 1);
		str[value.size - 1] = 0;
#endif
	
		gGeometryFlags = XParseGeometry(value.addr, &gX, &gY, &gWidth, &gHeight);
	}
}

void
getCwd()
{
	int len = 0;
	char* buf;
	
	while (1) {
		len += PATH_MAX;
		buf = (char*)alloca(len);
		if (::getcwd(buf, len))
			break;
		if (errno == ERANGE)
			continue;
		cerr << gProgname << ": couldn't get working directory: " <<
			::strerror(errno) << endl;
		::exit(1);
	}
	gCwd = buf;
//cout << "gCwd = " << gCwd << endl;
}
