//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: Xe.h,v 1.4 1999/07/18 10:26:50 ben Exp $

#ifndef _Xe_H_
#define _Xe_H_

#include <X11/X.h>

#include <sys/time.h>
#include <unistd.h>
#include <iostream.h>

#include <Kr/KrAtom.h>

#ifndef FALSE
#define FALSE		0
#endif

#ifndef TRUE
#define TRUE		1
#endif

#if 0
#ifdef NULL
#undef NULL
#endif

#ifndef NULL
#define NULL		0
#endif
#endif

#define XE_CB_RESIZE	(1L << 0)
#define XE_CB_XEVENT	(1L << 1)
#define XE_CB_ACTIVATE	(1L << 2)
#define XE_CB_VALUE_CHANGED	(1L << 3)

#define DIVPLUS(x, y) (((x)-1)/(y) + 1)

//
// Miscellaneous functions:
//

ulong	lookupColour(class XeObject* ob, char* colname);
void	getHomeDir(char* pathname);
void	parseKeyString(const char* str, int len, KeySym& key, uint& mods);

//
// Miscellaneous Classes:
//

class XeTimeFunc {
public:
	XeTimeFunc(const char* label = NULL);
	~XeTimeFunc();
	
private:
	struct timeval _tv;
	const char* _label;
	
	static long _totalTime;
};

#endif
