//
// Copyright (C) 1996 Ben Ross
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: Xe.C,v 1.4 1999/10/21 09:10:05 ben Exp $

#include <Xe.h>
#include <XeObject.h>

#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#ifdef _SGI_SOURCE
#include <alloca.h>
#endif

//
// Useful colour lookup function
//

ulong
lookupColour(XeObject* ob, char* colname)
{
    XColor xcol, screencol;
    
    if(!XAllocNamedColor(gDisplay, ob->_colourmap, colname, &screencol, &xcol)) {
		//fprintf(stderr, "%s: lookupColour in %s; colour name %s not available.\n", 
		//	gProgname, ob->_name, colname);
		
		return BlackPixel(gDisplay, gScreenNum);
    }
    return screencol.pixel;
}

//
// Home directory lookup function.
//

extern "C" {
extern char* cuserid(char*);
}

void
getHomeDir(char* pathname)
{
	char* homedir;
    
    homedir = getenv("HOME");
    if (homedir == 0) {
        struct passwd *pw;
        char *username;
        
        // $$$ cuserid _should_ be in unistd.h, but egcs
        // complains that it isn't declared
        username = (char*)cuserid(NULL);
        if (username == 0)
            username = getlogin();
        
        if (username)
            pw = getpwnam(username);
        else
            pw = getpwuid(getuid());

        homedir = pw->pw_dir;
    }
    strcpy(pathname, homedir);
}

//
// parses a string of length len and returns the appropriate
// KeySym and modifier keys specified in the string.
// Format is: <mod> <mod> .. <key> in no particular order eg:
// "Ctrl Alt Shift F1" is a valid key specification.
//

void
parseKeyString(const char* str, int len, KeySym& key, uint& mods)
{
	char* p1 = (char*)str;
	char* p2 = p1;
	int j = 1;
	
	key = NoSymbol;
	mods = 0;

	while (j <= len) {
		if (*p2 == 32 || j == len) {
			int tlen = p2 - p1;
			char* token;
			
			if (j == len) {
				tlen++;
				token = (char*)alloca(tlen + 1);
				strncpy(token, p1, tlen);
				token[tlen] = 0;
			} else {
				*p2 = 0;
				token = p1;
			}

			if (!strcmp(token, "Ctrl"))
				mods |= ControlMask;
			else if (!strcmp(token, "Shift"))
				mods |= ShiftMask;
			else if (!strcmp(token, "Alt"))
				mods |= Mod1Mask;
			else if (key == NoSymbol)
				key = XStringToKeysym(token);
					
			if (j != len)
				*p2 = 32;
			else
				j++;
			
			while (*p2 == 32 && j <= len) {
				p2++;
				j++;
			}
			p1 = p2;
			
		} else {
			p2++;
			j++;
		}
	}
}

long XeTimeFunc::_totalTime = 0;

XeTimeFunc::XeTimeFunc(const char* label)
{
	_label = label;
	gettimeofday(&_tv, NULL);
}

XeTimeFunc::~XeTimeFunc(void)
{
	struct timeval tv;
	gettimeofday(&tv, NULL);
	
	if (_label)
		printf("%s: ", _label);
	
	_totalTime += tv.tv_usec - _tv.tv_usec;
	
	printf("Time taken = %ld.%ld (%ld)\n", tv.tv_sec - _tv.tv_sec,
		tv.tv_usec - _tv.tv_usec, _totalTime);
}
