//
// Copyright (C) 1996 Brian Murray
//
// You may distribute under the terms of the GNU General Public
// License as specified in the COPYING file.
//

// $Id: TokenParser.h,v 1.1 1996/11/17 09:14:06 ben Exp $

#ifndef _TokenParser_h_
#define _TokenParser_h_

#include <stdio.h>

class TokenParser
{
public:
    TokenParser(const char* fileName, int maxLineLen, int maxArgs);
    ~TokenParser(void);
    
    enum ParserStatus {
	OK, 
	ERROR, 
	FATAL_ERROR, 
	FINISHED
    };
    
    ParserStatus readLine(void);
    void	rewind(void);

    int		getNumArgs(void) {return _numArgs;}
    const char*	getArg(int n)    {return _args[n];}
    int		getLineNo(void)  {return _lineNo;}
    
    void	printUserError(const char* message);
    void	printParserError(void);
    
private:
    int		_lineNo;
    int		_numArgs;
    char**	_args;
    int		_maxArgs;
    
    char*	_fileName;
    FILE*	_file;
    char*	_lineBuffer;
    int		_maxLineLen;
    int		_errno;
    
    ParserStatus parseLine(void);
};

#endif // _TokenParser_h_
