#ifndef _String_H_
#define _String_H_

// $Id: String.h,v 1.12 98/12/02 16:33:37 brian Exp $

#include <Kr/Kr.h>

class String {
public:
    String();
    String(const String&);    
    String(const char*);
    String(const void* data, int len);
    ~String();

    String& operator = (const String&);
    
    //
    // Data access
    //

    const char*	constCharP() const;
    char*	charP();

    int length() const;

    void truncate(int len);

    //
    // Comparison operators
    //

    friend        bool operator == (const String&, const String&);
    friend inline bool operator != (const String&, const String&);
    friend inline bool operator <  (const String&, const String&);
    friend inline bool operator <= (const String&, const String&);
    friend inline bool operator >  (const String&, const String&);
    friend inline bool operator >= (const String&, const String&);

    friend        bool operator == (const String&, const char*);
    friend inline bool operator != (const String&, const char*);

    friend int		strcmp(const String&, const String&);

    //
    // Addition (catenation) operators
    //
    
    friend String operator + (const String&, const String&);
    friend String operator + (const String&, const char*);
    friend String operator + (const String&, char);
    friend String operator + (const char*, const String&);
    
    String& operator += (const String&);
    
    //
    // Ostream operators
    //
    
    friend inline ostream& operator << (ostream&, const String&);
    
    // dump with unprintable characters escaped (C-style)
    void dumpPrintable(ostream&) const;
    
    // dump as 2-digit hex bytes separated with spaces
    void dumpHex(ostream&) const;
    
    //
    // Utility operators
    
    friend String int_to_str(int);
    
    static void		setDumpPrintableMaxLength(int len)
			    { _dumpPrintableMaxLength = len; }
    
private:
    struct Core {
	Core() { ref = 1; }
	~Core() { delete[] data; }

	int		ref;
	int		len;
	char*		data;
    };

    Core*		_core;
	
    void		connect(const String& str)
			    { if ((_core = str._core)) _core->ref++; }
    void		disconnect()
			    { if (_core && !--_core->ref) delete _core; }
    
    void		forkIfShared();
    
    static String	catenate(const char* adata, int alen,
			    const char* bdata, int blen);

    static const char	_emptyString;
    static int		_dumpPrintableMaxLength;
};

extern int  strcmp(const String&, const String&);

inline
String::String()
{
    _core = NULL;
}

inline
String::String(const String& str)
{
    connect(str);
}

inline
String::~String()
{
    disconnect();
}

inline int
String::length() const
{
    return (_core) ? _core->len : 0;
}

//
// Type conversion
//

inline const char*
String::constCharP() const
{
    return (_core) ? _core->data : &_emptyString;
}

//
// Inline comparison operators
//

inline bool
operator != (const String& a, const String& b)
{
    return !operator==(a, b);
}

inline bool
operator <  (const String& a, const String& b)
{
    return strcmp(a, b) < 0;
}

inline bool
operator <= (const String& a, const String& b)
{
    return strcmp(a, b) <= 0;
}

inline bool
operator >  (const String& a, const String& b)
{
    return strcmp(a, b) > 0;
}

inline bool
operator >= (const String& a, const String& b)
{
    return strcmp(a, b) >= 0;
}

inline bool
operator != (const String& a, const char* b)
{
    return !operator==(a, b);
}

//
// ostream operator
//

inline ostream&
operator << (ostream& ostr, const String& str)
{
    return ostr << str.constCharP();
}

#endif // _String_H_
