#ifndef _Kr_KrTime_H_
#define _Kr_KrTime_H_

// $Id: KrTime.h,v 1.3 97/08/01 16:42:20 brian Exp $

#include <Kr/Kr.h>
#include <sys/time.h>

class KrTime
{
public:
    KrTime(int sec = 0, int usec = 0);
    KrTime(double sec);
    KrTime(const KrTime&);
    ~KrTime() {}

    KrTime& operator = (const KrTime&);

    //
    // Data access
    //

    int sec();
    int usec();
    operator struct timeval ();
    operator double ();

    //
    // Comparison operators
    //
    
    friend bool operator == (const KrTime&, const KrTime&);
    friend bool operator != (const KrTime&, const KrTime&);
    friend bool operator <  (const KrTime&, const KrTime&);
    friend bool operator <= (const KrTime&, const KrTime&);
    friend bool operator >  (const KrTime&, const KrTime&);
    friend bool operator >= (const KrTime&, const KrTime&);

    //
    // Addition/subtraction operators
    //

    friend KrTime operator + (const KrTime&, const KrTime&);
    friend KrTime operator - (const KrTime&, const KrTime&);

    KrTime& operator += (const KrTime&);
    KrTime& operator -= (const KrTime&);

    //
    // Multiplication/division operators
    //

    friend KrTime operator * (const KrTime&, int);
    friend KrTime operator * (const KrTime&, double);
    friend KrTime operator / (const KrTime&, int);
    friend KrTime operator / (const KrTime&, double);

    //
    // Convenience functions
    //
    
    static KrTime now();

    friend ostream& operator << (ostream&, const KrTime&);
    
private:
    struct timeval _tv;  
};

//
// Inline methods
//

inline
KrTime::KrTime(int sec, int usec)
{
    _tv.tv_sec  = sec;
    _tv.tv_usec = usec;
}

inline
KrTime::KrTime(const KrTime& t)
{
    _tv.tv_sec  = t._tv.tv_sec;
    _tv.tv_usec = t._tv.tv_usec;
}

inline KrTime&
KrTime::operator = (const KrTime& t)
{
    _tv.tv_sec  = t._tv.tv_sec;
    _tv.tv_usec = t._tv.tv_usec;
    return *this;
}

inline int
KrTime::sec()
{
    return _tv.tv_sec;
}

inline int
KrTime::usec()
{
    return _tv.tv_usec;
}

inline
KrTime::operator struct timeval ()
{
    return _tv;
}

inline
KrTime::operator double ()
{
    return _tv.tv_sec + (double)_tv.tv_usec / 1000000.0;
}

#endif // _Kr_KrTime_H_
