#ifndef _KR_KrPool_h_
#define _KR_KrPool_h_

// $Id: KrPool.h,v 1.2 98/08/04 15:03:04 brian_l Exp $

#include <Kr/Kr.h>

class KrPool
{
public:
    struct Buf;
    
    static const uint BUFLEN = 0x100;
    static const uint DATALEN = (BUFLEN - sizeof(Buf*));

    struct Buf
    {
	Buf*	_next;
	uchar	_data[DATALEN];
    };

    static Buf*		alloc();
    static void		free(Buf*);
    static void		freeChain(Buf*);

private:
    static Buf*		_freeList;
    static uint		_allocSize;
    static uint		_numBufs;
    static int		_maxBufs;
};

#endif // _KR_KrPool_h_
