#ifndef _KR_KRLINK_H_
#define _KR_KRLINK_H_

// $Id: KrLink.h,v 1.5 97/08/08 16:07:04 brian Exp $

#include <Kr/Kr.h>

struct KrLink
{
    KrLink*		_next;
    KrLink*		_prev;
    
    KrLink*		next() { return _next; }
    KrLink*		prev() { return _prev; }
    
    inline void		init();

    // Remove from list

    inline void		remove();

    // Need not be initialized before calling these ...
    
    inline void		insertBefore(KrLink*);
    inline void		insertAfter(KrLink*);
    

    // Return true if (this) is in the same list as (elem).
    // (this) or (elem) may be the head of a list.

    bool		isConnected(KrLink* elem);
    
    // Return true if (this) is after (elem), relative to a
    // given (head). Assumes both (this) and (elem) are part
    // of the list headed by (head).

    bool		isAfter(KrLink* elem, KrLink* head);
    
    // Swap (this) with the next elem.
    
    void		swapWithNext();
};

inline void
KrLink::init()
{
    _next = _prev = this;
}

inline void
KrLink::remove()
{
    _next->_prev = _prev;
    _prev->_next = _next;
}

inline void
KrLink::insertBefore(KrLink* elem)
{
    _prev = elem->_prev;
    _next = elem;
    elem->_prev->_next = this;
    elem->_prev = this;
}

inline void
KrLink::insertAfter(KrLink* elem)
{
    _next = elem->_next;
    _prev = elem;
    elem->_next->_prev = this;
    elem->_next = this;
}

#endif // _KR_KRLINK_H_
