// $Id: KrLink.C,v 1.5 97/08/08 16:07:04 brian Exp $

#include <Kr/KrLink.h>
#include <stdlib.h>

bool
KrLink::isConnected(KrLink* elem)
{
    // Traverse two iterators, forward and backward from here,
    // until either one finds the test element.

    KrLink* forw = this;
    KrLink* back = this;
    
    for (;;) {
	forw = forw->_next;
	if (forw == elem)
	    return true;
	
	back = back->_prev;
	if (back == elem)
	    return true;

	if (forw == back || forw == this)
	    return false;
    }
}

bool
KrLink::isAfter(KrLink* elem, KrLink* head)
{
    // Traverse two iterators, forward and backward from here,
    // until either one finds the test element or the head.

    KrLink* forw = this;
    KrLink* back = this;
    
    for (;;) {
	forw = forw->_next;
	if (forw == elem)
	    return false;
	if (forw == head)
	    return true;
	
	back = back->_prev;
	if (back == elem)
	    return true;
	if (back == head)
	    return false;
	
	// This is a safety valve in case this is not connected
	// to either the test elem or the head, to stop an
	// otherwise infinite loop.
	
	if (forw == back || forw == this)
	    ::abort();
    }
}

void
KrLink::swapWithNext()
{
    KrLink* next = _next;
    KrLink* prev = _prev;
    
    // This breaks down if there are exactly 2 elements in the
    // ring, so better check ...

    if (next != prev) {
        KrLink* nextNext = next->_next;

	_prev = next;
	_next = nextNext;
	next->_next = this;

	nextNext->_prev = this;
	next->_prev = prev;
	prev->_next = next;
    }
}
