#ifndef _KR_KrCB_h_
#define _KR_KrCB_h_

// $Id: KrCB.h,v 1.20 98/01/15 15:12:17 ben Exp $

#include <Kr/Kr.h>

class KrFunc;

class KrCB
{
public:
    KrCB();
    KrCB(const KrCB&);
    KrCB(const KrFunc&);
    ~KrCB();

    KrCB& operator = (const KrCB&);
    KrCB& operator = (const KrFunc&);
    KrCB& operator += (const KrFunc&);
    void	clear();

    void	operator() (const void*) const;

private:
    KrFunc*	_func;
};

// ----------------------------------------------------------------------------

class KrFunc
{
public:
    KrFunc() {}
    virtual ~KrFunc() {}
    virtual void operator() (const void*) const = 0;
    virtual KrFunc* clone() const = 0;
};

inline
KrCB::KrCB()
{
    _func = NULL;
}

inline
KrCB::~KrCB()
{
    delete _func;
}

// ----------------------------------------------------------------------------

class KrPF : public KrFunc
{
public:
    typedef void (*PF)(void*, const void*);

    KrPF(PF, void* arg = NULL);

    virtual ~KrPF();
    virtual void operator() (const void* arg) const;
    virtual KrFunc* clone() const;

private:
    PF		_pf;
    void*	_c;
};

// ----------------------------------------------------------------------------

template <class C>
class KrPMF : public KrFunc
{
public:
    typedef void (C::*PMF)(const void*);

    KrPMF(PMF pmf, C* c) : _pmf(pmf), _c(c) {}

    virtual ~KrPMF();
    virtual void operator() (const void*) const;
    virtual KrFunc* clone() const;

private:
    PMF		_pmf;
    C*		_c;
};

//#ifdef __GNUC__
// For some reason the SGI compiler can't automatically find
// KrCB.h

#include <Kr/KrCB.CXX>
//#endif

#endif // _KR_KrCB_h_
