// $Id: KrCB.C,v 1.15 98/01/02 18:24:37 brian Exp $

#include <Kr/KrCB.h>

KrCB::KrCB(const KrCB& cb)
{
    _func = cb._func ? cb._func->clone() : (KrFunc*)NULL;
}

KrCB::KrCB(const KrFunc& func)
{
    _func = func.clone();
}

KrCB&
KrCB::operator = (const KrCB& cb)
{
    delete _func;
    _func = cb._func ? cb._func->clone() : (KrFunc*)NULL;
    return *this;
}

KrCB&
KrCB::operator = (const KrFunc& func)
{
    delete _func;
    _func = func.clone();
    return *this;
}

KrCB&
KrCB::operator += (const KrFunc& func)
{
    if (_func)
	krMsg("multiple callbacks not implemented", KR_FATAL);
    
    (*this) = func;
    return *this;
}

void
KrCB::clear()
{
    delete _func;
    _func = NULL;
}

void
KrCB::operator() (const void* arg) const
{
    if (_func)
	_func->operator() (arg);
}

// ----------------------------------------------------------------------------

KrPF::KrPF(PF pf, void* c) :
    _pf(pf),
    _c(c)
{
}

KrPF::~KrPF()
{
}

void
KrPF::operator() (const void* arg) const
{
    _pf(_c, arg);
}

KrFunc*
KrPF::clone() const
{
    return new KrPF(_pf, _c);
}
