#ifndef _KR_KRBUF_H_
#define _KR_KRBUF_H_

// $Id: KrBuf.h,v 1.12 98/12/10 19:20:43 ben Exp $

#include <Kr/Kr.h>
#include <Kr/KrPool.h>

// Dummy MBuf header to calculate (at compile time) effective header size,
// and thus the correct KRBUF_MLEN to make up the desired KRBUF_MSIZE.

#define _KRBUF_MLEN_DUMMY 256

struct _MBuf_dummy {
    _MBuf_dummy*	_next;
    uchar*		_data;
    uchar		_len;
    uchar		_dat[_KRBUF_MLEN_DUMMY];
};

#define KRBUF_MSIZE	(KrPool::BUFLEN)
#define KRBUF_MLEN	((signed)(KRBUF_MSIZE - \
			    (sizeof(_MBuf_dummy) - _KRBUF_MLEN_DUMMY)))

#define KRBUF_END	(-1)

class KrBuf
{
public:
    KrBuf();
    ~KrBuf();

// $$$ plus a bunch of KrBuf-sourced operations

    void*		get(void* data, int len, int pos,
			    bool alwaysCopy = true);
    void*		get(int len, int pos);
    void*		getPartial(int& len, int pos);

    // pos can be KRBUF_END

    inline void		insert(const void* data, int len, int pos);
//!    void*		insert(int len, int pos);
//!    void*		insertPartial(int& len, int pos);
    inline void		insertSet(uchar c, int len, int pos);

    inline void		append(const void* data, int len);    
//    void*		append(int len)
//			    { return insert(len, KRBUF_END); }
//    void*		appendPartial(int& len)
//			    { return insertPartial(len, KRBUF_END); }
    inline void		appendByte(uchar);
    inline void		appendSet(uchar c, int len);

    inline void		replace(const void* data, int len, int pos);

    inline void		clear();
    inline void		clear(int len, int pos);

    void		set(uchar c);
    inline void		set(int len, int pos, uchar c);

    void		remove();
    // len can be KRBUF_END
    void		remove(int len, int pos = 0);

    int			read(int fd, int len = 0);
    int			write(int fd, int len = 0, int pos = 0);
    
    inline int		length();

    enum CompactOp {
	TIGHT
    };

    // len can be KRBUF_END
    int			compare(const void* data, int len, int pos);
//!    void		compact(CompactOp op);

    // Debugging functions, only implemented if DEBUG is defined
    void		dump(bool printData);
    void		verify();

protected:
    struct MBuf {
	MBuf*		_next;
	uchar*		_data;
	uchar		_len;
	uchar		_dat[KRBUF_MLEN];
    };

    MBuf*		_mHead;
    MBuf*		_mTail;
    int			_size;
    
    static int		_numMBufs;

    // Private methods

    static MBuf*	mAlloc();
    inline static void	mFree(MBuf* m);
    inline static void	mFreem(MBuf* m);

    MBuf*		insertRaw(int len, int& pos);
    void		replaceAt(MBuf* m, const void* data, int len, int pos);
    void		setAt(MBuf* m, uchar c, int len, int pos);
};

inline void
KrBuf::insert(const void* data, int len, int pos)
{
    MBuf* m = insertRaw(len, pos);
    replaceAt(m, data, len, pos);
}

inline void
KrBuf::insertSet(uchar c, int len, int pos)
{
    MBuf* m = insertRaw(len, pos);
    setAt(m, c, len, pos);
}

inline void
KrBuf::append(const void* data, int len)
{
    insert(data, len, KRBUF_END);
}

inline void
KrBuf::appendByte(uchar c)
{
    int pos = KRBUF_END;
    MBuf* m = insertRaw(1, pos);
    *(m->_data + pos) = c;
}

inline void
KrBuf::appendSet(uchar c, int len)
{
    insertSet(c, len, KRBUF_END);
}

inline void
KrBuf::replace(const void* data, int len, int pos)
{
    replaceAt(_mHead, data, len, pos);
}

inline void
KrBuf::clear()
{
    set(0);
}

inline void
KrBuf::clear(int len, int pos)
{
    set(len, pos, 0);
}

inline void
KrBuf::set(int len, int pos, uchar c)
{
    setAt(_mHead, c, len, pos);
}

inline int
KrBuf::length()
{
    return _size;
}

inline void
KrBuf::mFree(MBuf* m)
{
    KrPool::free((KrPool::Buf*)m);
}

inline void
KrBuf::mFreem(MBuf* m)
{
    KrPool::freeChain((KrPool::Buf*)m);
}

#endif // _KR_KRBUF_H_
