#ifndef _KR_KRATOM_H_
#define _KR_KRATOM_H_

// $Id: KrAtom.h,v 1.24 99/04/05 15:32:19 ben Exp $

#include <Kr/Kr.h>
#include <Kr/KrLink.h>

class KtAtom;

class KrAtom
{
public:
    static const int	MAX_LENGTH = 65535;

    KrAtom();
    KrAtom(const char* name);
    KrAtom(const KrAtom& atom);
    ~KrAtom();

    const KrAtom& operator = (const KrAtom& atom);

    bool operator == (const KrAtom& atom) const;
    bool operator != (const KrAtom& atom) const;

    const char*		constCharP() const;
    bool		isNull() const;

    friend ostream& operator << (ostream&, const KrAtom&);

    static const KrAtom null;

    int			length() const;

    friend unsigned int	krHashFunc(const KrAtom& key);
    friend unsigned int	krHashFunc(const KtAtom& key);

private:
    struct Core : public KrLink
    {
	int		_ref;
	int		_len;
	const char*	_name;
	unsigned int	_hash;
    };

    Core*		_core;

    static inline void	connect(Core*);
    static inline void	disconnect(Core*);
    static void		deleteCore(Core*);
    
    // must be a power of 2
    static const int	HASH_SIZE = 256;
    
    static KrLink	_hashTable[HASH_SIZE];
    static bool 	_hashInitialized;

    static int compare(Core*, Core*);

    // for fast trusted access

    friend class KrAtomCache;
    friend class KtObName;
    friend int compare(const KtObName&, const KtObName&);
};

inline void
KrAtom::connect(Core* core)
{
    if (core)
	core->_ref++;
}

inline void
KrAtom::disconnect(Core* core)
{
    if (core && !--core->_ref)
	deleteCore(core);
}

inline
KrAtom::KrAtom()
{
    _core = NULL;
}

inline
KrAtom::KrAtom(const KrAtom& atom)
{
    connect(_core = atom._core);
}

inline
KrAtom::~KrAtom()
{
    disconnect(_core);
}

inline bool
KrAtom::operator == (const KrAtom& atom) const
{
    return _core == atom._core;
}

inline bool
KrAtom::operator != (const KrAtom& atom) const
{
    return _core != atom._core;
}

inline const char*
KrAtom::constCharP() const
{
    return _core ? _core->_name : (const char*)NULL;
}

inline bool
KrAtom::isNull() const
{
    return !_core;
}

inline int
KrAtom::length() const
{
    return _core ? _core->_len : 0;
}

#endif // _KR_KRATOM_H_
