// $Id: KrAtom.C,v 1.14 98/02/05 17:20:27 brian Exp $

#include <Kr/KrAtom.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

const KrAtom	KrAtom::null;

const int	KrAtom::MAX_LENGTH;
const int	KrAtom::HASH_SIZE;

KrLink		KrAtom::_hashTable[KrAtom::HASH_SIZE];
bool		KrAtom::_hashInitialized = false;

KrAtom::KrAtom(const char* name)
{
    if (!name || !*name) { // null or empty string
	_core = NULL;
	return;
    }

    if (!_hashInitialized) {
	_hashInitialized = true;
	for (int i=0; i < HASH_SIZE; i++)
	    _hashTable[i].init();
    }

    const char* cp = name;
    int hash = 0;
    int len = 0;
    while (*cp) {
	hash += *cp++;
	len++;
    }

    assert(len <= KrAtom::MAX_LENGTH);

    KrLink* hashEntry = &_hashTable[hash & (HASH_SIZE - 1)];

    Core* c = (Core*)hashEntry->next();
    while (c != hashEntry) {
	if (!::strcmp(name, c->_name)) {
	    _core = c;
	    c->_ref++;
	    return;
	}
	c = (Core*)c->next();
    }

    _core = new Core;
    _core->_name = ::strdup(name);
    _core->_len = len;
    _core->_ref = 1;
    _core->_hash = hash;
    _core->insertAfter(hashEntry);
}

const KrAtom&
KrAtom::operator = (const KrAtom& atom)
{
    if (_core != atom._core) {
	disconnect(_core);
	connect(_core = atom._core);
    }
    return *this;
}

void
KrAtom::deleteCore(Core* core)
{
    core->remove();
    ::free((void*)core->_name);
    delete core;
}

ostream&
operator << (ostream& ostr, const KrAtom& atom)
{
    KrAtom::Core* core = atom._core;
    return ostr << (core ? core->_name : "(null)");
}

unsigned int
krHashFunc(const KrAtom& key)
{
    KrAtom::Core* core = key._core;
    return core ? core->_hash : 0;
}

int
KrAtom::compare(Core* c1, Core* c2)
{
    if (c1) {
	if (c2)
	    return ::strcmp(c1->_name, c2->_name);
	else
	    return 1;
    } else {
	if (c2)
	    return -1;
	else
	    return 0;
    }
}
