#ifndef _KR_KR_H_
#define _KR_KR_H_

/* $Id: Kr.h,v 1.14 97/09/27 23:11:51 ben Exp $ */

/* saves putting these everywhere */
#include <stdio.h>
#include <iostream.h>

#ifndef NULL 
#define NULL (0)
#endif

typedef unsigned char	uchar;
typedef unsigned short	ushort;
typedef unsigned long	ulong;
typedef unsigned int	uint;

union int_or_ptr { int i; void* p; };

#ifdef NO_BOOL_DEFINED

/* One day all compilers will have this ... */
/* unsigned so bit fields of length 1 will be happy */
typedef unsigned int bool;

#ifndef false
#define false (0)
#endif
#ifndef true
#define true  (1)
#endif

#endif /* NO_BOOL_DEFINED */

enum KrMsgType {
    KR_WARNING,
    KR_ERROR,
    KR_FATAL
};

extern void krMsg(const char* msg, KrMsgType errorType);
extern const char* krFormat(const char* format, ...);
extern const char* krFormatError(const char* msg);

inline void krFatalError(const char* msg) { krMsg(msg, KR_FATAL); }

#endif /* _KR_KR_H_ */
