
// $Id: Kr.C,v 1.10 97/07/31 12:09:35 brian Exp $

#include <Kr/Kr.h>

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

void
krMsg(const char* msg, KrMsgType type)
{
    switch (type) {
	case KR_FATAL:
	    fprintf(stderr, "Kr FATAL ERROR: %s.\n", msg);
	    abort();
	
	case KR_ERROR:
	    fprintf(stderr, "Kr ERROR: %s.\n", msg);
	    break;
	
	case KR_WARNING:
	    fprintf(stderr, "Kr WARNING: %s.\n", msg);
	    break;
    }
}

const char*
krFormat(const char* format, ...)
{
    static char formatBuffer[1024];
    va_list args;
    
    va_start(args, format);
    vsprintf(formatBuffer, format, args);
    va_end(args);
    
    return (const char*)formatBuffer;
}

const char*
krFormatError(const char* msg)
{
    static char formatBuffer[1024];
    sprintf(formatBuffer, "%s: %s", msg, strerror(errno));
    return (const char*)formatBuffer;
}
