/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <math.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>

#include <X11/extensions/shape.h>

#include "struct.h"
#include "config.h"

#define	ABSDIFF(a,b)	((long)((a) - (b)) < 0 ? (b) - (a) : (a) - (b))


/*
 * Global variables
 */
extern	XtAppContext	app_context;

extern	Widget	toplevel,		/* Das Toplevel widget fuer die Cursor */
		dir_area;		/* Wird zum Loeschen der Selction gebraucht */

extern	Cursor	def_cursor;
extern	Cursor	file_cursor;
extern	Cursor	busy_cursor;

extern	GC		line_gc;
extern	GC		selc_gc;
extern	GC		back_gc;

extern	Dimension	folder_count;
extern	Folder_Glyph	*folders[];
extern	Folder_Glyph	*folder;
extern	Dir_Glyph	root;

extern	Dimension	selc_f;		/* Die derzeitigen Selections */
extern	Dir_Glyph	*selc_g;
extern	Time		selc_t;		/* Der Timer fuer Doppelclicks */
	Folder_Glyph	*selc_fo = NULL;/* Der Folder in dem selectiert wurde */

extern	Dir_Glyph	*last_g;
extern	Dimension	last_v;
extern	Dimension	last_y;
	Folder_Glyph	*last_fo = NULL;

extern	Boolean		GRAB;
	Boolean		REFRESH = FALSE;

extern	xfm_struct	defaults;
extern  Suffix_Glyph    *filetypes;

extern	Boolean		FILE_CHANGED;
extern	Boolean		DIR_CHANGED;

extern	int		label_height;
extern	int		vp_width;

extern	Dimension	typelength;

	Widget		ws_move_shell = NULL;	/* Es wird ein Window erzeugt, in dem zum verschieben */
						/* von Icons das Icon dargestellt wird */
	int		ws_move_offx;
	int		ws_move_offy;
extern	GC		selc_gc;
extern	Pixmap		File_Exec_PM;
extern	Pixmap		Shape_Exec_PM;
/*extern	int		workspace_changed;
*/


/*
 * Function Prototypes
 */

XtActionProc	startSingle    (Widget w, XButtonEvent *e,
				String *s, Cardinal *c);
XtActionProc	followSingle   (Widget w, XButtonEvent *e,
				String *s, Cardinal *c);
XtActionProc	endSingle      (Widget w, XButtonEvent *e,
				String *s, Cardinal *c);
XtActionProc	clearSingle    (Widget w, XEvent *e,
				String *s, Cardinal *c);
XtActionProc 	followDir      (Widget w, XMotionEvent *e, 
				String *s, Cardinal *c);
XtActionProc 	followFile     (Widget w, XMotionEvent *e, 
				String *s, Cardinal *c);
XtActionProc	refresh_icon   (Widget w, XExposeEvent *e, 
				String *s, Cardinal *c);

/* graph.c */
extern	void	drawDir	       (Widget window, Dir_Glyph *dir, 
				Boolean select, Boolean back);
extern	void	drawFile       (Folder_Glyph *folder, int entry,
				Boolean selected, Boolean back);

/* main.c */
extern	Dir_Glyph *getGlyph    (Dir_Glyph *root, Dimension x, Dimension y);

/* dir.c */
extern	String	getPath        (Dir_Glyph *dir);

/* fodler.c */
extern	void	newFolder      (Dir_Glyph *dir);

/* grab.c */
extern	Widget	grabWindow	(XButtonEvent *e);

/* action_copy.c */
extern	void	init_copy       (char *from, char *to);
extern	void	exec_copy       (char *from, char *to);

/* action_move.c */
extern	void	init_move       (char *from, char *to);
extern	void	exec_more       (char *from, char *to);


/*********************************************************
 * name:	startSingle
 * description:	Ueberpruefen ob unter dem Zeiger ein
 *		anwaehltbares Item ist und, falls
 *		das Item zum zweiten Mal angewaehlt wurde
 *		und zwischen dem ersten und zweiten
 *		Click nicht mehr als defaults.click_interval
 *		millisekunden lagen, dann zum Doppelclick
 *		handler uebergehen
Check whether a selectable Item is under the pointer and                  
if the Item were not selected for the second time and is 
between the first and second defaultsclick_interval  then
call the doubleclick handler.
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	startSingle    (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	int	i;

	/*
	 * Cursor busy
	 */
	XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
			busy_cursor);
	for (i = 0; i < folder_count; i++)
		XDefineCursor (XtDisplay(folders[i]->window),
				XtWindow(folders[i]->window),
				busy_cursor);
	XFlush(XtDisplay(toplevel));

	/*
	 * Bewerten
	 */
	if (w != dir_area && folder) {
		int	y;

		/*
		 * Eintrag aus dem Folder holen
		 */
		y = (e->y - 4)/DIR_Y_STEP;
		
		last_v = y;

		/*
		 * Wenn Eintrag vorher noch nicht angewaehlt, dann neunen anwaehlen
		 * 
		 */
		if (selc_f != last_v || selc_g || folder != selc_fo) {
			/*
			 * Neues File angewaehlt, alte Selection loeschen
			 * 
			 */
			clearSingle (NULL, NULL, NULL, NULL);

			/*
			 * Markieren
			 */
			if (last_v < folder->file_count) {
				selc_f = last_v;
				selc_fo = folder;
				drawFile (folder, selc_f, TRUE, TRUE);
			}
		}
		/*
		 * Wenn Eintrag schon angewaehlt war, dann auf Doppelclick untersuchen
		 * If entry already selected, then do not add to selection.
		 */
		else if (selc_f < 16000 && last_v == selc_f && selc_fo &&
			 ABSDIFF(e->time,selc_t) < defaults.click_interval) {
			/*
			 * Doppelclick -> Je nach Filetype Operation ausfuehren
			 * Allow doubleclick only on allowed file types.
			 */
			File_Glyph	*file = folder->file[selc_f];

			/*
			 * Pfeil fuer das Parentdir -> Eins im Directorybaum zurueck
			 * Arrow for the Parentdir - > unity in the directory tree back.
			 */
			if (file->prog_type == FILE_ROOT && folder->dir->parent) {
				if (!defaults.multi_window) {
					Arg	args[1];
					char	*s;

					folder->dir = folder->dir->parent;
					s = getPath(folder->dir);
					selc_f = 16000;
					fillFolder(folder);
					FILE_CHANGED = TRUE;
					refresh_files(folder->window,NULL,NULL,NULL);
					XtSetArg(args[0],XtNlabel,(*s == '\0' ? "/" : s));
					XtSetValues(folder->label,args,1);
				}
			}
			/*
			 * Directory angewaehlt, eins im Baum hoch
			 * Directory selected, one higher in the tree.
			 */
			else if (file->prog_type == FILE_DIR ||
				 file->prog_type == FILE_LDIR) {
				int	i = 0, j = -1;

				/*
				 * Directory Glyph aus dem folder->dir Glyph heraus suchen
				 * Get filename from the folder->dir list.
				 */
				if (!folder->dir->open && !folder->dir->dir_count) {
					fillDir(folder->dir);
					folder->dir->open = FALSE;
				}
				while (i < folder->dir->dir_count) {
					if (!(strcmp(folder->dir->dir[i]->name,file->name))) {
						j = i;
						i = folder->dir->dir_count;
					}
					i++;
				}
				/*
				 * Es gab ein solches Glyph, also Glyph fuellen und
				 * Folder neu darstellen
				 * Update the folder with the existing filename
				 */
				if (j > -1) {
					if (defaults.multi_window) {
						Dir_Glyph	*nd;

						nd = folder->dir->dir[j];
						if (!nd->open && nd->dir_count == 0) {
							fillDir(nd);
							nd->open = FALSE;
						}
						clearSingle (NULL,NULL,NULL,NULL);
						newFolder (nd);
					}
					else {
						Arg	args[1];
						char	*s;

						selc_f = 16000;
						folder->dir = folder->dir->dir[j];
						s = getPath(folder->dir);
						if (!folder->dir->open && folder->dir->dir_count == 0) {
							fillDir (folder->dir);
							folder->dir->open = FALSE;
						}
						fillFolder (folder);
						FILE_CHANGED = TRUE;
						refresh_files(folder->window,NULL,NULL,NULL);
						XtSetArg(args[0],XtNlabel,(*s == '\0' ? "/" : s));
						XtSetValues(folder->label,args,1);
					}
				}
			}
			/*
			 * Angewaehltes File hatte die x-Flags gesetzt
			 * Selected file had set the x-flags.
			 */
			else if (file->prog_type == FILE_EXEC) {
				char	buf[300];
				char	*s = getPath(folder->dir);

/*				sprintf(buf,"xterm -geometry 80x4 -e %s/%s &\0",s,file->name);
*/				sprintf(buf,"xterm -e %s/%s &\0",s,file->name);
				SYSTEM(buf);
				free(s);
			}
			/*
			 * Bei sonstigen Files in der Commandsliste nachsuchen
			 * Check for in the COMMAND list.
			 */
			else if (file->prog_type != FILE_PLAIN) {
				int	i = 0;

				while (filetypes[i].cmd && filetypes[i].type != file->prog_type)
					i++;

				if (filetypes[i].type == file->prog_type) {
					char	buf[200];
					char	*s = getPath(folder->dir);
					char	nbuf[200];

					sprintf(nbuf,"%s/%s",s,file->name);
					sprintf(buf,filetypes[i].cmd,nbuf);
					SYSTEM(buf);
					free(s);
					clearSingle(NULL,NULL,NULL,NULL);
				}
			}
		}
		/*
		 * Timer updaten
		 */
		selc_t = e->time;
	}
	else if (w == dir_area) {
		/*
		 * Glyph holen
		 * Get filename.
		 */
		last_g = getGlyph(&root, e->x,e->y);
		if (last_g)
			last_y = last_g->y + 8;
		else
			last_y = 16000;

		/*
		 * Nachsehen ob Eintrag schon angewaehlt war. Wenn nicht, dann
		 * neu anwaehlen
		 * Check whether entry was already selected.
		 * If not, then select again.
		 */
		if (last_g != selc_g || (selc_f < 16000 && selc_fo)) {
			/*
			 * Alte Selection loeschen
			 */
			clearSingle (NULL, NULL, NULL, NULL);

			/*
			 * Markieren
			 */
			if (last_g) {
				selc_g = last_g;
				drawDir (dir_area, selc_g, TRUE, TRUE);
			}
		}
		/*
		 * Eintrag war schon angewaehlt, Pruefen ob Doppelclick
		 * Entry was already selected, checking for Doublelclick.
		 */
		else if (selc_g && last_g == selc_g &&
			 ABSDIFF(e->time,selc_t) < defaults.click_interval) {	/* Innerhalb der Doppelklickid */

			/*
			 * Nachpruefen ob Directory lesbar ist
			 * Test whether directory is readable.
			 */
			if (selc_g->flags & DIR_READABLE) {
				if (defaults.multi_window) {
					newFolder(selc_g);
				}
				else {
					Arg	args[1];
					char	*s = getPath(selc_g);

					selc_f = 16000;
					FILE_CHANGED = TRUE;
					folders[0]->dir = selc_g;
					fillFolder(folders[0]);
					refresh_files(folders[0]->window,NULL,NULL,NULL);
					XtSetArg(args[0],XtNlabel,(*s == '\0' ? "/" : s));
					XtSetValues(folders[0]->label,args,1);
				}
				selc_g->open = FALSE;
			}
		}
		/*
		 * Timer updaten
		 */
		selc_t = e->time;
	}
	GRAB = FALSE;
	/*
	 * Cursor ruecksetzen
	 */
	XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
			def_cursor);
	for (i = 0; i < folder_count; i++)
		XDefineCursor (XtDisplay(folders[i]->window),
				XtWindow(folders[i]->window),
				def_cursor);
	XFlush(XtDisplay(toplevel));
}

/*********************************************************
 * name:	followSingle
 * description:	bei gedrueckter Maustaste das Ziel der Graboperation
 *		markieren
mark the target of the grab operation with a pressed mouse button.
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	followSingle   (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	/*
	 * Feststellen, in welchem Bereich der Pointer sich befindet
	 * Determine, in which area the pointers is.
	 */
	if (w == dir_area && (selc_g || (selc_fo && selc_f < 16000)))
		followDir (w, (XMotionEvent *) e, s, c);
	else if (folder && w == folder->window &&
		 (selc_g || (selc_fo && selc_f < 16000)))
		followFile (w, (XMotionEvent *) e, s, c);

	/*
	 * Auf Grabmode schalten - Nur im Dir-Feld und Folder
	 * Switch to grab mode only in the tree or folder.
	 */
	if (!GRAB && (selc_g || (selc_fo && selc_f < 16000))) {
		int	i;

		XUngrabPointer(XtDisplay(toplevel),CurrentTime);
		/* Grabben begann nicht ueber einem Icon */
		/* Grab does not begin over an Icon. */
		XGrabPointer (XtDisplay(toplevel),XtWindow(toplevel), True,
				ButtonReleaseMask | Button1MotionMask,
				GrabModeAsync, GrabModeAsync, None, file_cursor,
				CurrentTime);
		GRAB = TRUE;
		REFRESH = TRUE;
	}
}

/*********************************************************
 * name:	endSingle
 * description:	Die Maustaste wurde losgelassen. Danach
 *		falls eine Graboperation stattgefunden
 *		hat das Ziel bestimmen und die
 *		entsprechende Operation ausfuehren
The mouse button was released  Afterwards, if a grab operation took 
place, determine the target and the appropriate operation to execute.
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	endSingle      (Widget w, XButtonEvent *e,
				String *s, Cardinal *c)
{
	Arg	args[2],largs[2];
	int	i;

	/*
	 * Cursor busy
	 */
	XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
			busy_cursor);
	for (i = 0; i < folder_count; i++)
		XDefineCursor (XtDisplay(folders[i]->window),
				XtWindow(folders[i]->window),
				busy_cursor);
	XFlush(XtDisplay(toplevel));

	/*
	 * Der Endpunkt der Graboperation lag im Dir-Feld
	 * The terminator point of the grab operation was situated in the field. 
	 */
	if (w == dir_area) {
		Dir_Glyph	*dir;

		/*
		 * Zunaechst einmal muss anhand der Koordinaten das entsprechde
		 * Dir_Glyph heraus gesucht werden
		 * Initially, the current Dir Name must be looked up on the basis of the coordinates.
		 */
		dir = last_g;

		if (dir) {
			/*
			 * Nachsehen ob gerade eine Move-Grab operation ausgefuehrt wird
			 * Check whether it is an even move grab operation to execute.
			 */
			if (GRAB) {
				int	i;

				if (selc_g && dir != selc_g) {
					/*
					 * Verschieben des Directories in das gerade selectierte
					 * Shift the Directories into the even selection
					 */
					struct	stat	buf;
					uid_t		uid = getuid();
					char		*got1 = getPath(selc_g);
					char		*got2 = getPath(dir);

					stat(got1,&buf);
					if (buf.st_uid != uid)
						init_copy (got1, got2);
					else
						init_move (got1, got2);
					free (got1);
					free (got2);
				}
				else if (selc_fo && selc_fo->dir != dir) {
					char	sbuf[255];
					char	*got1;
					char	*got2;

					/*
					 * Verschieben des Icons vom folder->window in die Dir-area
					 * Shift the Icons of folder window into the target AREA.
					 */
					got1 = getPath(selc_fo->dir);
					got2 = getPath(dir);
					if (strcmp(got1,"/"))
						sprintf(sbuf,"%s/%s",got1,
							selc_fo->file[selc_f]->name);
					else
						sprintf(sbuf,"/%s",
							selc_fo->file[selc_f]->name);
					{
						struct	stat	buf;
						uid_t		uid = getuid();

						stat(sbuf,&buf);
						if (buf.st_uid != uid) {
							if (defaults.drag_copy)
								init_copy (sbuf, got2);
							else
								exec_copy (sbuf, got2);
						}
						else {
							if (defaults.drag_move)
								init_move (sbuf, got2);
							else
								exec_move (sbuf, got2);
						}
					}
					free(got1);
					free(got2);
				}
				GRAB = FALSE;
				/*
				 * Unhighlight target
				 */
				XDrawRectangle(XtDisplay(dir_area),XtWindow(dir_area),
					       back_gc, last_g->x - 4, last_g->y - 2,
					       32 + XTextWidth (defaults.icon_font,
						last_g->name,strlen(last_g->name)), 20);
			}
			else if (!GRAB) {
				/*
				 * Nachpruefen ob Directory geoeffnet ist
				 * Test whether directory is opened.
				 */
				if (selc_g->open) {
					if (selc_g->dir_count > 0)
						DIR_CHANGED = TRUE;
					selc_g->open = FALSE;
					refresh_dirs(NULL,NULL,NULL,NULL);
				}
				else {
					if (selc_g->flags & DIR_READABLE) {
						fillDir(selc_g);
						if (selc_g->dir_count > 0)
							DIR_CHANGED = TRUE;
						refresh_dirs(NULL,NULL,NULL,NULL);
					}
				}
			}
			last_g = NULL;
			last_y = 16000;
		}
	}
	/*
	 * Der Endpunkt der Grabaktion lag im File-Feld
	 * The endpoint of the grab process was situated in the file field.
	 */
	else if (folder && w == folder->window) {
		/*
		 * Testen ob zum Schluss noch ein Argument aktiviert war
		 * Tests for any more arguments.
		 */
		if (GRAB) {
			int	i;

			if (selc_fo && selc_f < 16000 && last_v != selc_f) {
				char	sbuf[200];
				char	dbuf[200];
				char	*got1;
				char	*got2;

				got1 = getPath(selc_fo->dir);
				got2 = getPath(folder->dir);

				if (strcmp(got1,"/"))
					sprintf(dbuf,"%s/%s",got1,selc_fo->file[selc_f]->name);
				else
					sprintf(dbuf,"/%s",folder->file[selc_f]->name);

				if (last_v < 16000) {
					if (strcmp(got2,"/"))
						sprintf(sbuf,"%s/%s",got2,folder->file[last_v]->name);
					else
						sprintf(sbuf,"/%s",folder->file[last_v]->name);
				}
				else
					sprintf(sbuf,"%s",got2);

				if (last_v < 16000 || folder != selc_fo) {
					if (last_v < 16000 && 
					    folder->file[last_v]->prog_type == FILE_EXEC)
						init_exec (sbuf,dbuf);
					else {
						struct	stat	buf;
						uid_t		uid = getuid();

						stat(dbuf,&buf);
						if (buf.st_uid != uid) {
							if (defaults.drag_copy)
								init_copy (dbuf, sbuf);
							else
								exec_copy (dbuf, sbuf);
						}
						else {
							if (defaults.drag_move)
								init_move (dbuf, sbuf);
							else
								exec_move (dbuf, sbuf);
						}
					}
				}

				free(got1);
				free(got2);
			}
			else if (selc_g) {
				char	sbuf[200];
				char	*got1 = getPath(folder->dir);
				char	*got2 = getPath(selc_g);

				if (last_v < 16000) {
					if (strcmp(got1,"/"))
						sprintf(sbuf,"%s/%s",got1,folder->file[last_v]->name);
					else
						sprintf(sbuf,"/%s",folder->file[last_v]->name);
				}
				else
					sprintf(sbuf,"%s",got1);


				if (last_v < 16000 && folder->file[last_v]->prog_type == FILE_EXEC)
					init_exec (got2,sbuf);
				else if (last_v < 16000) {
					struct	stat	buf;
					uid_t		uid = getuid();

					stat(got2,&buf);
					if (buf.st_uid != uid) {
						if (defaults.drag_copy)
							init_copy (got2, sbuf);
						else
							exec_copy (got2, sbuf);
					}
					else {
						if (defaults.drag_move)
							init_move (got2, sbuf);
						else
							exec_move (got2, sbuf);
					}
				}
				free (got1);
				free (got2);
			}
			GRAB = FALSE;
			/*
			 * unhighlight des Grabtargets
			 */
			if (last_fo)
				XDrawRectangle(XtDisplay(last_fo->window),
					       XtWindow(last_fo->window),
					       back_gc, 16, 
					       last_v*DIR_Y_STEP + 4,
					       last_fo->max_length + 50 + typelength, 20);
		}
		last_v = 16000;
	}
	/*
	 * Cursor ruecksetzen
	 * Cursors reset.
	 */
	XUngrabPointer (XtDisplay(toplevel),CurrentTime);
	XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
			def_cursor);
	for (i = 0; i < folder_count; i++)
		XDefineCursor (XtDisplay(folders[i]->window),
				XtWindow(folders[i]->window),
				def_cursor);
	XFlush(XtDisplay(toplevel));
}

/*********************************************************
 * name:	clearSingle
 * description:	SingleSelection loeschen
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/

XtActionProc	clearSingle    (Widget w, XEvent *e,
				String *s, Cardinal *c)
{
	/*
	 * Zunaechst nachsehen ob noch ein Single-Select besteht.
	 * Wenn ja, dann loeschen.
	 */
	if (selc_g) {
		drawDir (dir_area, selc_g, FALSE, TRUE);
		selc_g = NULL;
		selc_f = 16000;
		selc_fo = NULL;
	}
	else if (selc_fo && selc_f < 16000) {
		drawFile (selc_fo, selc_f, FALSE, TRUE);
		selc_f = 16000;
		selc_fo = NULL;
		selc_g = NULL;
	}
}


/*********************************************************
 * name:	followFile
 * description:	Der Mauszeiger wird im gedrueckten Zustand im Folder bewegt
 The mouse pointer is moved in the pressed status in the folder.
 * input:	Widget		w	- Das Fenster
 *		XMotionEvent	*e	- Der Event
 *		String		*s	- unused
 *		Cardinal	*c	- unused
 * output:	none
 * author:	Ove Kalkan
 * date:	15.6.93
 *********************************************************/
XtActionProc 	followFile (Widget w, XMotionEvent *e, String *s, Cardinal *c)
{
	int		y;

	y = (e->y - 4)/DIR_Y_STEP;
	if (folder && y != last_v) {
		if (last_v < 16000 && last_fo) {
			XDrawRectangle(XtDisplay(last_fo->window),
				       XtWindow(last_fo->window),
				       back_gc, 16, last_v*DIR_Y_STEP + 4,
				       last_fo->max_length + 50 + typelength, 20);
			last_v = 16000;
			last_fo = NULL;
		}
		if (y < folder->file_count && y >= 0) {
			File_Glyph	*file;
			uid_t 		uid = getuid();
			gid_t		gid = getgid();

			file = folder->file[y];
			if ((uid == file->uid && S_IWUSR&file->mode) ||
	      		     (gid == file->gid && S_IWGRP&file->mode) ||
			     S_IWOTH&file->mode) {
				last_v = y;
				last_fo = folder;
				if (GRAB && (last_v != selc_f || folder != selc_fo))
					XDrawRectangle(XtDisplay(folder->window),XtWindow(folder->window),
						       selc_gc, 16, last_v*DIR_Y_STEP + 4,
						       folder->max_length + 50 + typelength, 20);
			}
		}
	}
}



/*********************************************************
 * name:	followDir
 * description:	Der Mauszeiger wird im gedrueckten Zustand im DirWindow bewegt
 * input:	Widget		w	- Das Fenster
 *		XMotionEvent	*e	- Der Event
 *		String		*s	- unused
 *		Cardinal	*c	- unused
 * output:	none
 * author:	Ove Kalkan
 * date:	15.6.93
 *********************************************************/
XtActionProc 	followDir (Widget w, XMotionEvent *e, String *s, Cardinal *c)
{
	Dir_Glyph	*dir;
	int		y;

	/*
	 * Nachsehen ob eventuell wieder in einem neuen Feld
	 */
	y = (e->y - last_y < 0) ? (last_y - e->y) : (e->y - last_y);
	if (y > DIR_Y_STEP/2) {
		if (last_g) {
			XDrawRectangle(XtDisplay(dir_area),XtWindow(dir_area),
				       back_gc, last_g->x - 4, last_g->y - 2,
				       32 + XTextWidth (defaults.icon_font,
					last_g->name,strlen(last_g->name)), 20);
			last_y = 16000;
			last_g = NULL;
		}
		dir = getGlyph(&root,e->x,e->y);
		if (dir) {
			if (dir->flags & DIR_WRITEABLE) {
				last_g = dir;
				if (GRAB && selc_g != last_g && (selc_fo == NULL || selc_f == 16000 || selc_fo->dir != dir))
					XDrawRectangle(XtDisplay(dir_area),XtWindow(dir_area),
						       selc_gc, last_g->x - 4, last_g->y - 2,
						       32 + XTextWidth (defaults.icon_font,
							last_g->name,strlen(last_g->name)), 20);
				last_y = dir->y + 8;
			}
		}
	}
}


/*********************************************************
 * name:	refresh_icon
 * description:	neuzeichnen des Inhalts des gerade verschobenen Icons
 * input:	Das uebliche fuer XtActionProcs
 * output:	none
 * author:	Ove Kalkan
 * date:	10.8.1993
 *********************************************************/

XtActionProc	refresh_icon   (Widget w, XExposeEvent *e, 
				String *s, Cardinal *c)
{
	XCopyArea(XtDisplay(w),File_Exec_PM,XtWindow(w),selc_gc,
				0,0,16,16,0,0);
}

