/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <X11/X.h>
#include <X11/cursorfont.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>

#include "struct.h"
#include "config.h"



/*
 * Globale Variablen
 */

extern	Folder_Glyph	*folders[];
extern	Dimension	folder_count;

extern	Folder_Glyph	*selc_fo;
extern	Folder_Glyph	*multi_fo;
extern	Folder_Glyph	*folder;
extern	Dimension	selc_f;
extern	Dimension	multi_vs, multi_ve;

extern	Widget		toplevel;
extern	Cursor		def_cursor;

extern	xfm_struct	defaults;
extern	Boolean		FILE_CHANGED;
extern	Boolean		MULTI;
extern	Folder_Glyph	*multi_fo;
extern	Dimension	multi_vs;
extern	Dimension	multi_ve;


/*
 * Function Prototypes
 */
void	newFolder	 (Dir_Glyph *dir);
void	makeFolderWindow (Widget parent, Folder_Glyph *folder,Dimension id);
void	refreshFolderByPathname (char *path);

void	hideFolder (Widget w, XtPointer client, XtPointer call);

void	updateFolder    (Folder_Glyph *folder);

extern	String	getPath (Dir_Glyph *dir);
extern	void	makeIconBar (Widget parent, Widget left, Boolean HIDE);

static	XtTranslations	folder_trans = NULL;


/*********************************************************
 * name:	newFolder
 * description:	Bei MultiWindow ein neues Folderfenster
 *		erzeugen
 * input:	Dir_Glyph *dir	- Das zugehoerige Dir
 * output:	erweitert die Folderstruktur
 * author:	Ove Kalkan
 * date:	16.6.93
 *********************************************************/
void	newFolder (Dir_Glyph *dir)
{
	Folder_Glyph	*nf;
	Widget		shell;
	Dimension	i = 0;

	if (folder_count + 1 == MAX_FOLDERS) {
		WARNING("Cannot open another folder. Close one before trying again.");
		return;
	}

	/*
	 * Nachsehen ob nicht bereits ein Folder mit den Directory
	 * besteht
	 */
	while (i < folder_count && strcmp(getPath(folders[i]->dir),getPath(dir)))
		i++;

	if (i == folder_count) {
		/*
		 * Folders erweitern
		 */
		if (!(nf = (Folder_Glyph *) malloc (sizeof(Folder_Glyph))))
			FATAL_ERROR ("newwFolder: Cannot allocate new Folder\n");

		/*
		 * neuen folder fuellen
		 */
		shell = XtCreatePopupShell ("folder_window", topLevelShellWidgetClass,
					    toplevel, NULL,0);
		makeFolderWindow(shell,nf,folder_count);

		nf->dir = dir;
		nf->file_count = 0;
		nf->file = NULL;
		nf->filter = NULL;
	}
	else {
		nf = folders[i];
		XRaiseWindow (XtDisplay(nf->shell),XtWindow(nf->shell));
		FILE_CHANGED = TRUE;
	}

	fillFolder (nf);

	if (i == folder_count) {
		char	*s = getPath(nf->dir);
		Arg	args[2];
		int	sizex,sizey;

		XtManageChild(nf->window);
		XtManageChild(nf->shell);

		XStoreName(XtDisplay(nf->shell),XtWindow(nf->shell),
				 (*s == '\0' ? "/" : s));

		XSetIconName(XtDisplay(nf->shell),XtWindow(nf->shell),
				 (*s == '\0' ? "/" : s));
		folders[folder_count++] = nf;

		sizey = DIR_Y_STEP*(4+nf->file_count) > 748 ? 748 :
						DIR_Y_STEP*(6+nf->file_count);
		sizex = nf->max_length + 60 < 300 ? 300 :
						nf->max_length + 60;
		XtSetArg(args[0],XtNheight,sizey);
		XtSetArg(args[1],XtNwidth,sizex);
		XtSetValues(nf->shell,args,1);
	}

	XDefineCursor (XtDisplay(nf->window), XtWindow(nf->window), def_cursor);

	refresh_files (nf->window,NULL,NULL,NULL);
}





/*********************************************************
 * name:	makeFolderWindow
 * description:	erzeugt ein Fenster mit einem Folder
 * input:	Widget	parent	- Shellfenster oder pane,
 *				  in dem der Folerder erzeugt
 *				  werden soll
 *		Folder_Glyph	*folder	- Der Folder fuer
 *					  das Fenster
 * output:	Fuellt die angegebene Folder-struktur
 * author:	Ove Kalkan
 * date:	16.6.93
 *********************************************************/
void	makeFolderWindow (Widget parent, Folder_Glyph *folder,Dimension id)
{
	Widget	dummy;
	Arg	args[12];

	folder->shell = parent;
	/*
	 * Den Bereich fuer das Folder-Fenster
	 */
	XtSetArg(args[0],XtNdefaultDistance,0);
	dummy = XtCreateManagedWidget("folder_pane", formWidgetClass,
				      parent, args,1);

	XtSetArg(args[0],XtNleft, XawChainLeft);
	XtSetArg(args[1],XtNright, XawChainRight);
	XtSetArg(args[2],XtNtop, XawChainTop);
	XtSetArg(args[3],XtNbottom, XawChainTop);
	XtSetArg(args[4],XtNborderWidth, 0);
	XtSetArg(args[5],XtNwidth, 300);

	if (!defaults.multi_window) {
		/*
		 * darauf den File_label erzeugen
		 */
		folder->label = XtCreateManagedWidget("file_label", 
						      labelWidgetClass,
						      dummy, args,6);
	}
	else {
		Widget	f,b;

		/*
		 * Eine Form fuer den Hide-Button erzeugen
		 */
		f = XtCreateManagedWidget ("folder_form", formWidgetClass,
					   dummy, args, 6);
		folder->label = f;

		/*
		 * Den Hide-Button erzeugen
		 */
		makeIconBar(f,NULL,TRUE);
	}
	/*
	 * Auf dieses field_pane jetzt den Viewport setzen, der das
	 * Simple-Widget fuer den Directory-Tree enthalten soll
	 */	
	XtSetArg(args[3],XtNbottom, XawChainBottom);
	XtSetArg(args[4],XtNwidth, 368);
	XtSetArg(args[5],XtNheight,288);
	XtSetArg(args[6],XtNallowHoriz, TRUE);
	XtSetArg(args[7],XtNallowVert, TRUE);
	XtSetArg(args[8],XtNforceBars, TRUE);
	XtSetArg(args[9],XtNuseBottom, TRUE);
	XtSetArg(args[10],XtNuseRight, TRUE);
	XtSetArg(args[11],XtNfromVert, folder->label);
	folder->vp = XtCreateManagedWidget("viewport", viewportWidgetClass,
					   dummy, args,12);

	/*
	 * Auf das Viewport kommt jetzt das Simple-Widget fuer den
	 * Directory Tree
	 */
	folder->window = XtCreateWidget("file_simple", simpleWidgetClass,
					folder->vp, args, 2);
	if (!folder_trans) {
		folder_trans = XtParseTranslationTable(
					"<Leave>: leave-window()\n\
					<Enter>: enter-window()\n\
				        <Expose>: refresh-files() refresh-multi()\n\
					<Btn3Down>: start-popup()\n\
					<Btn1Down>: clear-multi() start-single()\n\
					<Btn1Motion>: follow-single()\n\
					<Btn1Up>: end-single()\n\
					<Btn2Down>: clear-single() start-multi() \n\
					<Btn2Motion>: follow-multi() \n\
					<Btn2Up>: end-multi()");
	}
	XtOverrideTranslations(folder->window, folder_trans);

	/*
	 * Count field
	 */
	XtSetArg(args[2],XtNtop, XawChainBottom);
	XtSetArg(args[4],XtNwidth, 300);
	XtSetArg(args[6],XtNfromVert, folder->vp);
	XtSetArg(args[5],XtNborderWidth, 0);
	XtSetArg(args[7],XtNjustify, XtJustifyLeft);
	folder->info = XtCreateManagedWidget("folder_info",labelWidgetClass,dummy,
						args, 8);

}


/*********************************************************
 * name:	hideFolder
 * description:	loeschen eine Folders vom Bildschirm
 * input:	in client befindet sich ein Zeiger
 *		auf den Folder
 * author:	Ove Kalkan
 * date:	17.6.93
 *********************************************************/
void	hideFolder (Widget w, XtPointer client, XtPointer call)
{
	Folder_Glyph	*fo = (Folder_Glyph *) client;
	Dimension	i = 0;

	/*
	 * Erst einmal das Fenster loeschen
	 */
	XtDestroyWidget (fo->shell);

	/*
	 * Id in der Folderliste finden und ander Folder aufruecken lassen
	 */
	while (folders[i] != fo)
		i++;

	while (i < folder_count - 1) {
		folders[i] = folders[i+1];
		i++;
	}

	folder_count--;

	/*
	 * die Folder-Struktur loeschen
	 */
	while (fo->file_count--) {
		free (fo->file[fo->file_count]->name);
		free (fo->file[fo->file_count]);
	}

	if (fo == selc_fo) {
		selc_fo = NULL;
		selc_f = 16000;
	}
	if (fo == multi_fo) {
		multi_fo = NULL;
		multi_vs = 16000;
		multi_ve = 16000;
	}
	if (fo == folder)
		folder = NULL;

	free(fo);
}


/*
 * name:	refreshFolderByPathname
 * description:	Sucht nach einem Folder in dem das in path angegebene
 *		Directoy dargestellt ist und erneuert diesen.
 * input:	char *path	- Pfad des Directories, das erneuert werden soll.
 * output:	none
 * author:	Ove Kalkan
 * date:	27.6.1993
 */
void	refreshFolderByPathname (char *path)
{
	int	i = 0;
	Boolean	NOTENDE = TRUE;
	char	*path2;
	char	*a;

	if (!(path2 = (char *) malloc (strlen(path)+1)))
		FATAL_ERROR ("refreshFolderByPathname: Memoryalloc failed");
	strncpy(path2,path,strlen(path));
	path2[strlen(path)] = '\0';
	a = strrchr(path2,'/');
	if (a)
		*a = '\0';

	/*
	 * Nachsehen, ob es einen Folder fuer das Directory gibt
	 */
	while (i < folder_count) {
		char	*got;

		got = getPath(folders[i]->dir);
		if (strcmp(got,path) && strcmp(got,path2))
			i++;
		else {
			if (folders[i] == selc_fo) {
				selc_fo = NULL;
				selc_f = 16000;
			}
			else if (folders[i] == multi_fo) {
				multi_fo = NULL;
				multi_vs = 16000;
				multi_ve = 16000;
				MULTI = NULL;
			}
			updateFolder(folders[i]);
			i++;
		}
		free(got);
	}
}



/*********************************************************
 * name:	updateFolder
 * description:	Directory eines Folders neu laden und darstellen
 * input:	Folder_Glyph *folder - Folder der geupdated
 *		werden soll.
 * output:	none
 * author:	Ove Kalkan
 * date:	29.6.93
 *********************************************************/
void	updateFolder    (Folder_Glyph *folder)
{
	fillFolder(folder);
	FILE_CHANGED = TRUE;
	refresh_files(folder->window,NULL,NULL,NULL);
}

