/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <stdlib.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "struct.h"
#include "config.h"

/*
 * Global variables
 */
extern	Widget	dialog;			/* Das Dialogwidget */
extern	Widget	text_1, text_2;		/* Zum Verschieben braucht man 2 Text,
					   sonst nur einen */
#ifdef	HAS_QUOTA
extern	Widget	quota_label;		/* Fuer die Quotas einen Label */
#endif
extern	Pixmap	Icon_Delete_PM;
extern	Pixmap	icon_pixmap;

extern	Boolean		FILE_CHANGED;
extern	Boolean		DIR_CHANGED;
extern	Folder_Glyph	*selc_fo;
extern	Dimension	selc_f;
extern	Dir_Glyph	*selc_g;
extern	Boolean		MULTI;

extern	Folder_Glyph	*multi_fo;
extern	Dimension	multi_vs, multi_ve;

/*
 * Function Prototypes
 */
void	init_delete     (char *file);
void	exec_delete     (char *file);
void	exec_delete_cb  (void);

extern	Widget		makeDialog     (Dimension text,
					char *label1, char *label2,
					char *text1, char *text2,
					char *title, Boolean cancel, Boolean OVERRIDE);
extern	XtActionProc	refresh_files  (Widget w, XExposeEvent *e,
					String *s, Cardinal *c);
extern	void		updateFolder   (Folder_Glyph *folder);
extern	void		hide_dialog    (void);
extern	void		WARNING	       (char *text);
extern	void		setSize	       (void);

extern	void		refreshFolderByPathname (char *path);

#ifdef	HAS_QUOTA
extern	void		showQuota      (Widget w);
#endif



/*********************************************************
 * name:	init_delete
 * description:	erzeugt ein Fenster mit 1 text zum Loeschen
 * input:	char *file
 * output:	none
 * date:	10.5.93
 *********************************************************/
void	init_delete (char *file)
{
	Widget	but;

	/*
	 * Das Dialogfenster erzeugen
	 */
	icon_pixmap = Icon_Delete_PM;
	but = makeDialog(1,"File :","",file,NULL,"Remove File",TRUE,FALSE);

	XtAddCallback(but,XtNcallback,(XtCallbackProc) exec_delete_cb,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);

	/*
	 * Max und Minsize setzen
	 */
	setSize();
}


/*********************************************************
 * name:	exec_delete
 * description:	Operation File-Loeschen ausfuehren
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
void	exec_delete_cb (void)
{
	char	*from;
	Arg	args[1];
	char	buf[1024];

	/*
	 * Die Texte der beiden Textfelder holen
	 */
	XtSetArg(args[0],XtNstring,&from);
	XtGetValues(text_1,args,1);

	/*
	 * Ueberpruefen ob in beiden ein Text steht, sonst
	 * Warnung ausgeben
	 */
	if (!strlen(from)) {
		WARNING ("Insuffisant Argument.\nOperation aborted.");
		return;
	}

	/*
	 * Befehl generieren und ausfuehren
	 */
	if (!MULTI)
		exec_delete(from);
	else {
		char	*bot,*top;

		bot = from;
		top = strchr(bot,'\n');
		while (top) {
			*top++ = '\0';
			sprintf(buf,"%s %s\0",RM_CMD,bot);
			system(buf);

			bot = top;
			top = strchr(bot,'\n');
		}
		/*
		 * Dialogfenster loeschen
		 */
		if (dialog)
			XtDestroyWidget(dialog);
		dialog = NULL;

		/*
		 * Hier muss ein Update der veranderten Felder kommen
		 * Bisher unvollstaendig
		 */
		bot = from;
		multi_fo = NULL;
		multi_vs = 16000;
		multi_ve = 16000;
		refreshFolderByPathname(bot);
#ifdef	HAS_QUOTA
		showQuota(quota_label);
#endif
		MULTI = FALSE;
	}
}



/*********************************************************
 * name:	exec_delete
 * description:	Operation File-Loeschen ausfuehren
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
void	exec_delete (char *from)
{
	char	buf[1024];


	/*
	 * Befehl generieren und ausfuehren
	 */
	sprintf(buf,"%s %s",RM_CMD,from);

	system(buf);
	{
		/*
		 * Dialogfenster loeschen
		 */
		if (dialog)
			XtDestroyWidget(dialog);
		dialog = NULL;

		/*
		 * Hier muss ein Update der veranderten Felder kommen
		 * Bisher unvollstaendig
		 */
		refreshFolderByPathname(from);
#ifdef	HAS_QUOTA
		showQuota(quota_label);
#endif
	}
}




