/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>

#include "struct.h"
#include "config.h"

/*
 * Global variables
 */
extern	Widget	toplevel;
extern	Widget	dialog;			/* Das Dialogwidget */
extern	Pixmap	Icon_Help_PM;

extern	Pixmap	icon_pixmap;

static char	*notice =
"Xfilemanager Version 0.4.0\n"
"--------------------------\n"
"\n"
"This program was written in 1993 by Ove Kalkan, who\n"
"claims all copyrights. Copying or distributing are permited\n"
"without the authors agree.\n\nA more detailed help-system will\n"
"be included soon.";

void		initAbout(void);
extern	void	hide_dialog (void);
extern	void	setSize (void);

/*********************************************************
 * name:	initAbout
 * description:	Mappen des Info-Windows mit der Copyright notiz
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	2.7.93
 *********************************************************/
void	initAbout(void)
{
	Widget	form, icon, title, text, but;
	Arg	args[10];

	/*
	 * Dialog loeschen falls noch vorhanden
	 */
	if (dialog)
		XtDestroyWidget(dialog);

	/*
	 * Neues Shellwidget erzeugen
	 */
	dialog = XtVaCreatePopupShell ("dialog_shell", 
					topLevelShellWidgetClass,
					toplevel, 
					XtNallowShellResize, TRUE,
					NULL);
	/*
	 * Darauf eine form erzeugen
	 */
	form = XtCreateManagedWidget ("dialog_form", formWidgetClass, dialog,
					args, 0);

	/*
	 * Den Simple fuer das Icon erstellen
	 */
	icon_pixmap = Icon_Help_PM;
	XtSetArg(args[0],XtNtop, XtChainTop);
	XtSetArg(args[1],XtNbottom, XtChainTop);
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[3],XtNleft, XtChainLeft);
	XtSetArg (args[6],XtNwidth, 32);
	XtSetArg (args[5],XtNheight, 32);
	XtSetArg (args[4],XtNborderWidth, 0);
	icon = XtCreateManagedWidget ("dialog_icon", simpleWidgetClass, form,
					args, 7);
	XtOverrideTranslations(icon,XtParseTranslationTable("<Expose>: refresh-dialog-icon()"));

	/*
	 * den Label darauf erzeugen, der sagt, das es sich hierbei um
	 * eine Verschiebe-Aktion handelt
	 */
	XtSetArg(args[5],XtNlabel, "Xfilemanager - About");
	XtSetArg(args[6],XtNfromHoriz, icon);
	title = XtCreateManagedWidget ("about_title", labelWidgetClass, form,
					args, 7);

	/*
	 * Darauf jetzt ein Textwidget setzen
	 */
	XtSetArg(args[0],XtNtop, XtChainTop);
	XtSetArg(args[1],XtNbottom, XtChainBottom);
	XtSetArg(args[2],XtNright, XtChainRight);
	XtSetArg(args[3],XtNleft, XtChainLeft);
	XtSetArg(args[4],XtNwidth, 500);
	XtSetArg(args[5],XtNheight, 400);
	XtSetArg(args[6],XtNfromVert, icon);
	XtSetArg(args[7],XtNscrollVertical, XawtextScrollAlways);
	XtSetArg(args[8],XtNdisplayCaret, FALSE);
	XtSetArg(args[9],XtNstring, notice);
	text = XtCreateManagedWidget("about_text",asciiTextWidgetClass,form,
				     args,10);

	/*
	 * Den Hide Button
	 */
	XtSetArg(args[2],XtNright, XtChainLeft);
	XtSetArg(args[4],XtNlabel, "  Hide  ");
	XtSetArg(args[5],XtNfromVert, text);
	but = XtCreateManagedWidget ("dialog_cancel", commandWidgetClass, form,
					args, 6);
	XtAddCallback(but,XtNcallback, (XtCallbackProc) hide_dialog, NULL);

	XtManageChild(dialog);
	setSize();
}
