.\" man(1) page for heliwm.
.\" Copyright (C) 2000 Hidetoshi Ohtomo.  All rights reserved.
.TH heliwm 1 "Version 1.2"
.SH NAME
heliwm \- highly essential, light and itsy-bitsy window manager for X11
.SH SYNOPSIS
heliwm [ \-d \fIdisplay\fP ] [ \-f \fIfilename\fP ] [ \-v ]
.SH DESCRIPTION
.I heliwm
is a light window manager for X Window System.  Its design goal is minimum
consumption of memory and CPU time, so it provides nothing more than basic
window operations such as window moving, resizing, iconifying, raising and
lowering.  Window maximizing is optional.  No menus, gorgeous look, virtual
screens, etc.
.I heliwm
is for people who don't want to spend much of their computer resources for a
window manager.  Most deficiencies you will find are due to the resource saving
strategy.

It depends on a keyboard for window manipulation, especially for moving and
resizing, which cannot be done without using one.  The idea, that window
manipulation can be done without using a mouse, is inherited from Robert
Nation's \fIfvwm\fP(1) version 1.x.  Thank you, Robert. :-)
.SH OPTIONS
.TP 4
\-d \fIdisplay\fP
Specify X server to use.
.TP 4
\-f \fIfilename\fP
Specify non-default configuration file to use.
.TP 4
\-v
Print version number along with compilation options (see below).
.SH COMPILE TIME OPTIONS
There are four compile time options.
.IP FRAME
If
.I heliwm
is compiled without this option, it is called
.I alpha particle
version.  It doesn't decorate client windows to save even more resources.
.IP NLS
Native Language System support.  Set environmental variable
.I LANG
to name of your locale (e.g.,
.I ja_JP
for Japanese), to use characters other than ASCII for window and icon titles.
Ensure that
.I f
option in your configuration file has a comma-separated list of required fonts.
If you don't know which fonts are required, run
.I heliwm
with
.I fixed
specified for the
.I f
option and it will report missing character sets, if any.  Use
\fIxlsfonts\fP(1) to look for fonts for each character set.
.IP SHAPE
X non-rectangular window shape extension support.  Clients such as
\fIoclock\fP(1) and \fIxeyes\fP(1) are written using the extension, but can be
run without it.  Some non-rectangular windows generate many X events upon
exposure, and can be a burden to CPU, so compile
.I heliwm
without this option, if you would.
.IP MAXIMIZE
Optional automatic window maximizing feature.  Window maximizing can be done
manually with resizing, so if you don't want to spend extra resources, compile
.I heliwm
without this option.
.SH CONFIGURATION
System default configuration file is read at startup, when you don't have your
own as
.I ~/.heliwmrc
or specify one by
.I \-f
option.
If none of them is available, default values are used.

Configuration file format is quite strict, and all invalid lines are silently
ignored.  First of all, a line must start with an option key, which is an
alphabet letter.  Some of them require a sub-key, which must be the second
character of the line.  Each word is separated by exactly one character, which
may be a space or a tab.  Take a look at the default configuration file for an
example.

Here is a list of available customization options:
.IP "c\fIS color_name\fP"
Specify color to use.
.I S
here is one of following sub-keys: f, b, o, i, a.  They correspond to
foreground, background, border (outmost frame), innermost frame and band,
respectively.

Foreground color is used for window title text, and band color is used for a
move/resize band.  You may need to choose a color for the latter, which is in
contrast with most part of your screen, or you may find it hard to see.

Background, border and innermost frame colors are used to draw a frame around a
window.  If you want a pseudo 3D look, specify darker color for border and
innermost frames than background, for example.  Alpha particle version doesn't
recognize innermost frame color, since it doesn't have a chance to draw the
portion.
.IP "w\fIS\fP \fIwidth\fP"
Specify frame width in integer.
.I S
is either
.I b
for border or
.I m
for frame.  Alpha particle version doesn't recognize these options.
.IP "f \fIfont_name\fP"
Specify font to use for window and icon titles.  They are written in
`foreground' color.
.IP "k\fIS modifier key\fP"
Specify window manipulation key.
.I S
here is one of operation sub-keys: \fIm\fP, \fIr\fP, \fIi\fP, \fIn\fP, \fIp\fP,
\fIa\fP, \fIl\fP, \fId\fP, \fIt\fP, \fIx\fP.  See section OPERATIONS for
details.
.I Modifier
is the sum of one or more integers representing modifier keys.  See section
MODIFIERS for details.
.I Key
is one of the key names in /usr/include/X11/keysymdef.h, with the prefix XK_
removed.
.IP "b\fIS modifier button\fP"
Specify window manipulation button.
.I S
and
.I modifier
are the same as those for key option.
.I Button
is mouse button number: 1 through 5.
.IP "o \fIother_option\fP"
Specify other options.  There are five of them, and a number is assigned to
each.  Pick up options you want and add their numbers, or specify 0 if you want
none of them.
.RS
.IP 1 4
Set focus to a window when it is raised.
.IP 2 4
Set focus to a window when the pointer is circulated and points it.
.IP 4 4
Set focus to a window when a window is mapped.
.IP 8 4
Raise a window when the pointer is circulated and points it.
.IP 16 4
Warp pointer to upper-left corner of a window, when it is focused.
.PP
"Circulated" here means when `next' (\fIn\fP sub-key) or `previous' (\fIp\fP
sub-key) window operations are executed.
.SH OPERATIONS
Following operation sub-keys are available:
.IP \fIm\fP 3
Trigger move operation.
.IP \fIr\fP 3
Trigger resize operation.
.IP \fIi\fP 3
Iconify/deiconify a window.
.IP \fIn\fP 3
Move pointer to next window.
.IP \fIp\fP 3
Move pointer to previous window.
.IP \fIa\fP 3
Raise a window.
.IP \fIl\fP 3
Lower a window.
.IP \fId\fP 3
Delete a window, if it defines WM_DELETE_WINDOW protocol.  If it doesn't, it
cannot be deleted by \fIheliwm\fP.
.IP \fIt\fP 3
Terminate \fIheliwm\fP.
.IP \fIx\fP 3
Maximize/unmaximize a window.  This is available only when MAXIMIZE compile
time option is selected.
.PP
Move and resize operations are triggered by pressing a key or a mouse button,
as described above.  The cursor changes, a band appears to show current
position and size of the window, and an indicator window appears at the center
of the screen.  Use arrow keys (up, down, left and right), \fIvi\fP(1) style
(k, j, h and l) or \fIemacs\fP(1) style (p, n, b and f) cursor movement keys to
move or resize a window.  Holding down a shift key makes the change smaller,
while a control key makes it even smaller.  Modifier 1 key, if available, makes
it larger.  Press Enter key or a button to complete the operation.

When a window is iconified for the first time, the band shows up for placement
of icon.  Use the keys to move it to anywhere you want.

.I n
operation moves the pointer to upper-left corner of next window in a list of
windows which
.I heliwm
manages.
.I p
operation moves the pointer to previous one.

Maximizing a window makes it as large as possible within the size of the
screen.  When a client has a maximum size set,
.I heliwm
admires it, so it is impossible to make the window larger than the size.
.SH MODIFIERS
Following modifiers are available:
.IP 0 3
Require no modifier to be pressed.
.IP 1 3
Require a shift key to be pressed.
.IP 2 3
Require a control key to be pressed.
.IP 4 3
Require a modifier 1 key to be pressed.
.IP 8 3
Require a modifier 2 key to be pressed.
.PP
For example, if you want a modifier 1 key and a shift key to be pressed while
pressing a key, specify 5 as \fImodifier\fP.  Run \fIxmodmap\fP(1) to see what
keys are assigned to modifier 1 and 2.
.SH MEMORY AND CPU TIME SAVING TIPS
Compile
.I heliwm
without
.I FRAME
option to make it alpha particle version.

Avoid wrapping windows as much as possible.  Every time obscured part is
exposed, it has to be drawn, consuming extra CPU time.

Use \fIrxvt\fP(1) instead of \fIxterm\fP(1) when possible.

Use \fIX\fP(1) only when necessary. :-)
.SH AUTHOR
Hidetoshi Ohtomo <hok@lab.rim.or.jp>
.SH DISTRIBUTION SITE
http://www.cc.rim.or.jp/~hok/heliwm/
.SH FILES
.TP
/usr/lib/X11/heliwm/heliwmrc
System default run control file.
.TP
~/.heliwmrc
User run control file.
.SH DESIGN
Following strategies were taken in order to make the program small and/or
lessen CPU load:

No automatic icon placement.  When a window is first iconified, user must
determine where to place the icon.

Moving and resizing operations can't be done with mouse.  Tracking pointer
movement is quite heavy task for CPU.
.SH BUGS
This window manager was named lithiwm at first, but it was soon renamed.

It may be hard to distinguish bugs from deficiencies due to design.

If you find a bug or a way to make the program lighter, I would like to be
informed about it.  Please contact me by sending an email to the address above.
.SH LICENSE
Copyright (C) 2000, 2001 Hidetoshi Ohtomo.  All rights reserved.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.

The license can be found at
.nf
http://www.gnu.org/copyleft/gpl.html.
.SH SEE ALSO
X(1), fvwm(1), rxvt(1), xlsfonts(1), xmodmap(1),
.I Linux Ecology HOWTO
by Werner Heuser and Wade W. Hampton, and \fIPeriodic Table of the Elements\fP.
