/* heliwm.h
 * Copyright (C) 2000, 2001 Hidetoshi Ohtomo.  All rights reserved. */

/* Used in move_or_resize() & find_window(). */
#define UNDEFINED	0
#define CHILD		1
#define ICON		2

/* Operation codes.  Used in `op' member of keys[], & also as `operation'
 * argument of move_or_resize() & update_indicator(). */
#define OP_MOVE		0
#define OP_RESIZE	1
#define OP_ICONIFY	2
#define OP_NEXT		3
#define OP_PREV		4
#define OP_RAISE	5
#define OP_LOWER	6
#define OP_DELETE	7
#define OP_TERMINATE	8

#ifdef MAXIMIZE
#define OP_MAXIMIZE	9
/* Note: the order of OP_SUB_KEYS must be the same as that of operation codes,
 * because they are used as indexes for it. */
#define OP_SUB_KEYS	"mrinpaldtx"
#define NUM_OP_SUB_KEYS	10
#else
#define OP_SUB_KEYS	"mrinpaldt"
#define NUM_OP_SUB_KEYS	9
#endif


/* Flags: used in `flags' member of struct heliwm_window. */
#define MAX_SIZE_DEFINED	(1<<0)
#define ICON_POS_DEFINED	(1<<1)
#define CREATED_PIXMAP		(1<<2)
#define CREATED_ICON		(1<<3)
#define NEED_TO_DRAW_ICON	(1<<4)
#define MAPPED			(1<<5)
#define ICONIFIED		(1<<6)
#define IGNORE_UNMAP		(1<<7)
#define INPUT			(1<<8)
#define SHAPED			(1<<9)
#define TAKE_FOCUS_IS_SET	(1<<10)
#define DELETE_WINDOW_IS_SET	(1<<11)
#ifdef MAXIMIZE
#define MAXIMIZED		(1<<12)
#endif

/* Option flags. */
#define FOCUS_WHEN_RAISED		(1<<0)
#define FOCUS_WHEN_CIRCULATED		(1<<1)
#define FOCUS_WHEN_MAPPED		(1<<2)
#define RAISE_WHEN_CIRCULATED		(1<<3)
#define WARP_POINTER_WHEN_FOCUSED	(1<<4)

struct heliwm_window {
	struct heliwm_window *next, *prev;
	Window child, icon;
#ifdef FRAME
	Window frame;
#endif
	Colormap cmap;
	Pixmap icon_pm;
	short x, y;		/* Position of frame or child. */
	short icon_x, icon_y;	/* Position of icon. */
#ifdef FRAME
	int w, h;		/* Width & height of frame. */
#endif
	int child_w, child_h;	/* Those of child. */
	int icon_w, icon_h;	/* Those of icon. */
	int child_bw;		/* Border width of child. */
	int icon_bw;		/* That of icon. */
	int base_w, base_h;	/* Base width & height. */
	int inc_w, inc_h;	/* "Arithmetic progression of sizes". */
	int max_w, max_h;	/* Maximum width & height. */
#ifdef MAXIMIZE
	int ow, oh;		/* Width & height of child before maximizing. */
	short ox, oy;		/* Position before maximizing. */
#endif
#ifdef FRAME
	char *name;		/* Window name. */
#endif
	char *icon_name;	/* Icon name. */
	unsigned short flags;	/* Flags. */
};

/* Key operation structure. */
struct keyop {
	unsigned int state;	/* Modifier keys. */
	unsigned int keycode;	/* Keycode. */
	int op;			/* Operation code - see above. */
};

/* Mouse button operation structure. */
struct buttonop {
	unsigned int state;	/* Modifier keys. */
	unsigned int button;	/* Button number. */
	int op;			/* Operation code - see above. */
};
