/* This file is part of a Windows32 DLL Interface to:
   GNU gettext - internationalization aids
   Copyright (C) 1996, 1998 Free Software Foundation, Inc.

   This file was written by Franco Bez <franco.bez@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* A very simple sample Program
   just pops up a MessageBox */

# include <windows.h>

// include the gettext headers 
#include <libintl.h>

// small makro for faster typing
#define _(String) gettext(String)

int main(){
    int i;
    // Tell gettext to use current working directory as locale dir for sample
    // if you don't tell "C:\\gnu\\share\\locale" is taken as a default
    bindtextdomain("sample",".\\");

    // Tell gettext to use the sample textdomain
    textdomain("sample"); 

    // just use _( ) to mark the strings to get translated

    for (i=0;i<5;++i){
 // Go through all the SAMPLE Languages
	switch(i){
     // Due to a BUG / Feature of WINDOWS we need to set the 
        case 0:
        // LANGUAGE variable through gettext_putenv ( _putenv won't work with gnu_gettext.DLL)
	    gettext_putenv("LANGUAGE=en");
 // English
	    break;
	case 1:
	    gettext_putenv("LANGUAGE=de");
 // German
	    break;
	case 2:
	    gettext_putenv("LANGUAGE=fr");
 // French
	    break;
	case 3:
	    gettext_putenv("LANGUAGE=it");
 // Italian
	    break;
	case 4:
	    gettext_putenv("LANGUAGE=pt");
 // Portugese
	    break;
	}


	// Now here's a sample for a translated Message
	MessageBox(NULL,_("Hello World") , _("This is english ( default )"), MB_OK);
    }

    return 0;
}
