
;
;   Registry Examples
;   Eric Asbell (RobotBob 2006)
;   easbell@quanta-it.com
;   www.quanta-it.com

; If your like me, the registry API first use in a
; new language can be a real pain (some params are pointers other values)
; So here is my effort to prevent this pain for you.

; In effort to make this example plain, I have omitted error handling.
; But of course you should checked the return values of these apis. 

[push | push #1 | #+1]
[pop | pop #1 | #+1]
[call | push #L>2 | call #1]

[hRegKey: D$ 0]
[disp: D$ 0]

; Make this something like: Software\Your Company\Your App
[SubKey: B$ "Software\Eric Asbell\RegistryExamples" 0]

; I define these here, however RosAsm has a feature for *on the fly* data such
; as: {"TestBytes" , 0} See B_U_ASM->RosAsm_Manual->Assembler->Macros->ParaMacros
[KeyBytes: B$ "TestBytes" 0
 KeyString: B$ "TestString" 0
 KeyDword: B$ "TestDword" 0]

; SetValue wants a DWORD value, however QueryValue 
; wants a Pointer (mem address) to a DWORD value 
; The same is true for the Length of the data buffer.
[KeyBytesType: &REG_BINARY
 KeyStringType: &REG_SZ
 KeyDwordType: &REG_DWORD]

; Oh am I cheating here :) this is Ascii for 'OUR BYTES'
; So I can show them in a MessageBox. 
[BytesToSet: B$ 04F 055 052 020 042 059 054 045 053 BytesToSet.Size: len]
[StringToSet: B$ "The quick brown fox jumps over the lazy dogs back" 0 StringtoSet.Size: len]
[DwordToSet: D$ 01234_1AFF DwordToSet.Size: len]

[ReadBytes: B$ 0 #20 ReadBytes.Len: len]
[ReadDword: D$ 0 ReadDword.len: len]
[ReadString: B$ 0 #50 ReadString.Len: len]

Main:
    ; ~~~~~~~~~~~~~~~~~~~Create The Registry key!~~~~~~~~~~~~~~~
    call 'ADVAPI32.RegCreateKeyExA' &HKEY_CURRENT_USER,
                                    SubKey,
                                    0,
                                    0,
                                    &REG_OPTION_NON_VOLATILE,
                                    &KEY_ALL_ACCESS,
                                    0,
                                    hRegKey,
                                    disp
                                    
    ;This is my only error test, if it fails we just leave. 
    ; Same as IF eax = ERROR_SUCCESS THEN GOTO L1                               
    cmp eax &ERROR_SUCCESS | jne L1>>
    ; this works too but obviously unreadable
    ;or eax eax | jnz L1>> 
    
    ; ~~~~~~~~~~~~~~~~~~~SET THEM!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    MsgBox SubKey {"Setting Registry Keys..." 0}
    
    ; Set the registry value "TestBytes"
    call 'ADVAPI32.RegSetValueExA' D$hRegKey,
                                   KeyBytes,
                                   0,
                                   &REG_BINARY,
                                   BytesToSet,
                                   D$BytesToSet.Size

    ; Set the registry value "TestString"
    call 'ADVAPI32.RegSetValueExA' D$hRegKey,
                                   KeyString,
                                   0,
                                   &REG_SZ,
                                   StringToSet,
                                   D$StringtoSet.Size

    ; Set the registry value "TestDword"
    call 'ADVAPI32.RegSetValueExA' D$hRegKey,
                                   KeyDword,
                                   0,
                                   &REG_DWORD,
                                   DwordToSet,
                                   D$DwordToSet.Size

    ;~~~~~~~~~~~~~~~~~~~~~READ THEM~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    call 'ADVAPI32.RegQueryValueExA' D$hRegKey,
                                     KeyBytes,
                                     0,
                                     KeyBytesType,
                                     ReadBytes,
                                     ReadBytes.len
 
    MsgBox ReadBytes {"Reading Bytes..." 0}
                                     
    call 'ADVAPI32.RegQueryValueExA' D$hRegKey,
                                     KeyString,
                                     0,
                                     KeyStringType,
                                     ReadString,
                                     ReadString.len
                                     
    MsgBox ReadString {"Reading String Keys..." 0}
                                     
    call 'ADVAPI32.RegQueryValueExA' D$hRegKey,
                                     KeyDword,
                                     0,
                                     KeyDwordType,
                                     ReadDword,
                                     ReadDword.len

    HexPrint D$ReadDword
    
    ;~~~~~~~~~Now Delete the Keys you just made!~~~~~~~~~~~~~~~~~~~~~~~~~
    MsgBox {"GoodBye..." 0} {"Deleting Registry Key..." 0}
    
    ; Normally you wouldn't delete them, until your program no longer needs 
    ; them. Or if your app is to be unistalled. Remember don't litter the
    ; registry, and allow the user some way of cleaning your keys.
    call 'ADVAPI32.RegDeleteKeyA' &HKEY_CURRENT_USER SubKey 
    
    ;~~~~~~~~~And make sure you close the Key you opened~~~~~~~~~~~~~~~~~
    call 'ADVAPI32.RegCloseKey' D$hRegKey    
    
L1: ; If RegCreate fails go here
    call 'KERNEL32.ExitProcess' 0
    
    ; End OF Our Example
____________________________________________________________________________________________

; Our Routines to display our read registry data.
; Normally you would use your read value to set some value in your application.

; My little macro to clean up things visually so the focus is on our example APIs
; It has a VB look :)
[MsgBox | call 'USER32.MessageBoxA' 0 #1 #2 0]

; From Ren (Betov)
; little message routine for values tests (dWords only) to be called with:
; > Hexprint D$esi, for example:

[HexprintString: B$ '        h' 0
 MessageTitle:      'DwordValue' 0]

HexPrn:
     mov ebx eax
     mov edi HexPrintString
     add edi 7
     std
       mov ecx 8
L1:    mov al bl
       and al 0F
       cmp al 0A | jb L2>
       add al 7
L2:    add al '0'
       stosb
       shr ebx 4
       loop L1<
     cld
     push &MB_OK+&MB_SYSTEMMODAL
     push MessageTitle
     push HexPrintString
     push 0
     call 'USER32.MessageBoxA'
ret

[HexPrint
 pushad
    push #1
    pop eax
    call hexprn
 popad]
