; Subclass control example
; RobotBob (Eric Asbell)
; easbell@quanta-it.com
; 2005

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Level:        Intermediate
; Requires:     a base knowledge of Win32 api.

; I make an assumption that you know the basics of creating an
; win32 application, fundmental assembly and how to use win32 api
; documentation.
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

; What is *Subclass* ?

; A subclass is a window or set of windows with the same
; class whose messages are intercepted and processed by
; another window procedure (or procedures) before being
; passed to the window procedure of the class.

; Or better in simple english, We hijack the damn thing :)

; This example is simple. We change the control's window procedure
; to point to our own. Then we handle a few messages. I like it this
; way. I hate examples that seem to spend less time teaching and more
; time trying to impress the beginner.

; So its left to you to experiment, any sort of unique control
; can be created. Now to take charge visually as well, you
; must also make the button *ownerdrawn* ... I have another example to
; explain this.

; If you find a an error or have a question feel free to email me.
_____________________________________________________________________________________________
_____________________________________________________________________________________________

; General purpose macros:
[push | push #1 | #+1]  [pop | pop #1 | #+1]  [mov | mov #1 #2 | #+2]
[inc | inc #1 | #+1]    [dec | dec #1 | #+1]
[On | cmp #1 #3 | jn#2 M1> | #4>L | M1:]
[call | push #L>2 | call #1]
[move | push #2 | pop #1 | #+2]      ; (for mem to mem moves, for exemple)

[If | cmp #1 #3 | jn#2 I1>]
[Else_if | jmp I9> | I1: | cmp #1 #3 | jn#2 I1>]
[Else | Jmp I9> | I1:]
[End_if | I1: | I9:]

[.If | cmp #1 #3 | jn#2 J1>>]
[.Else_if | jmp J9>> | J1: | cmp #1 #3 | jn#2 j1>>]
[.Else | Jmp j9>> | j1:]
[.End_if | j1: | j9:]

[..If | cmp #1 #3 | jn#2 K1>>]
[..Else_if | jmp K9>> | K1: | cmp #1 #3 | jn#2 K1>>]
[..Else | Jmp K9>> | K1:]
[..End_if | K1: | K9:]

[...If | cmp #1 #3 | jn#2 Z1>>]
[...Else_if | jmp Z9>> | Z1: | cmp #1 #3 | jn#2 Z1>>]
[...Else | Jmp Z9>> | Z1:]
[...End_if | Z1: | Z9:]

[While | W0: | cmp #1 #3 | jn#2 W9>]
[End_While | jmp W0< | W9:]

[.While | X0: | cmp #1 #3 | jn#2 X9>>]
[.End_While | jmp X0<< | X9:]

[..While | Y0: | cmp #1 #3 | jn#2 Y9>>]
[..End_While | jmp Y0<< | Y9:]

[Do | D0:]
[Loop_Until | cmp #1 #3 | jn#2 D0<]
[Do_Loop | jmp D0<<]

[.Do | E0:]
[.Loop_Until | cmp #1 #3 | jn#2 E0<<]

[Exchange | push #1 | push #2 | pop #1 | pop #2 | #+2]

[Agree | cmp #1 #3 | j#2 A9> | #+3]
[Reject | cmp #1 #3 | j#2 A8> | #+3 | jmp A9> | A8: | ret | A9:]

_________________________________________________________________________________________
_________________________________________________________________________________________
; Proc Macros and Equates. Internal storages are:
;
; &1 <<< Size of Argument(s) (for ending Ret n, in EndP). Set by Argument(s)
; &2 <<< Size of Local (for Stack Management). Set by Local
; &3 <<< What to pop before ret. Set by Uses.

[Proc | &1=0 | &2=0 | &3= | #1 | push ebp | mov ebp esp]
[ExitP | jmp P9>>]
[Arguments | {#1 Arg#x} | #+1 | &1=SizeOf#x]
[Argument  | {#1 Arg#x} | #+1 | &1=SizeOf#x]
[Local | {#1 Local#x} | #+1 | sub esp SizeOf#x | &2=SizeOf#x]
[StrucPtrs | {#3 ebp+#2+#F} | #+2]
[Structure | {#1 ebp-&2-4} | sub esp #2+4 | mov D$#1 esp | StrucPtrs 0-&2-#2-4 #L>3]
[Uses | push #1>L | &3=pop #L>1]
[EndP | P9: | &3 | mov esp ebp | pop ebp | ret &1]

; For pointing to transmitted parameters (upper "Arg#x" fall here):
[Arg1 ebp+8    Arg2 ebp+12    Arg3 ebp+16    Arg4 ebp+20   Arg5 ebp+24
 Arg6 ebp+28   Arg7 ebp+32    Arg8 ebp+36    Arg9 ebp+40   Arg10 ebp+44]

; For pointing Local Stack declared data (upper "Local#x" fall here):
[Local1 ebp-4     Local2 ebp-8     Local3 ebp-12    Local4 ebp-16    Local5 ebp-20
 Local6 ebp-24    Local7 ebp-28    Local8 ebp-32    Local9 ebp-36    Local10 ebp-40]

; To help preventing from stack sizes' mistakes (upper "SizeOf#x" fall here):
[SizeOf1 4     SizeOf2 8     SizeOf3 12    SizeOf4 16    SizeOf5 20
 SizeOf6 24    SizeOf7 28    SizeOf8 32    SizeOf9 36    SizeOf10 40]

____________________________________________________________________________________________
____________________________________________________________________________________________
; Equates for HLL comparisons (with 'If' and friends):

[= e   < b    > a    <s l    >s g    =< be    <= be    => ae    >= ae    <> ne]
_____________________________________________________________________________________________
_____________________________________________________________________________________________

; My macros for my debug window, man I am dependant on it :)
;[OutPutDec | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutDec' #1 &0]
;[OutPutSignedDec | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutSignedDec' #1 &0]
;[OutPutHex | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutHex' #1 &0]
;[OutPutFloat | fld #1 | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutFloat' #1 &0 #2 #3]
;[OutPutString | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutString' #1 &0]
;[OutPutError | call 'KERNEL32.GetLastError' | call 'QDEBUG.OutPutError' eax ]
;[OutPutStringLiteral | &4=#1 | { &0: B$ &4 0 } | call 'QDEBUG.OutPutStringSimple' &0 ]
;[OutPutLog | call 'QDEBUG.OutPutLogFile' #1]

_________________________________________________________________
[Argh: 'Aaarrrghhh!!!!....', 0    Whaoo: 'Whaaaaoooo!!!!....', 0]

[MessageBox | {&0: #2 0} | call 'USER32.MessageBoxA' &NULL &0 #1 &MB_SYSTEMMODAL__&MB_OK]

; ... to be called, for example, by:
;
; > MessageBox Whaoo 'Oh! No, please!!! not that again!...'

___________________________________________________________________________________________

; For "GetMessage":
[FirstMessage: 0 #7]

; Window Class Structure:
[WindowClass:
 style: 3
 lpfnWndProc: MainWindowProc
 cbClsExtra: 0
 cbWndExtra: 0
 hInstance: 0
 hIcon: 0
 hCursor: 0
 hbrBackground: 1
 lpszMenuName: 0
 lpszClassName: WindowClassName]

[WindowHandle: 0   MenuHandle: 0]
[WindowClassName: B$ 'SC EXAMPLE' 0    WindowCaption: 'Subclass Example' 0]
[WindowX: 50  WindowY: 50  WindowW: 200  WindowH: 120]

; Our Data! woohoo! it takes vey little to make me happy :)

; This holds (or will) the previous address of the button procedure.
[OldButtonProc: D$ ?]

[SubclassButton_handle: D$ ?]
[LOWORD|mov eax #1|and eax 0FFFF]
[HIWORD|mov eax #1|shr eax 16]

___________________________________________________________________________________________

Main:
    call 'Kernel32.GetModuleHandleA' 0 | mov D$hInstance eax
    call 'User32.LoadIconA' D$hInstance, 1 | mov D$hIcon eax
    call 'User32.LoadCursorA' 0, &IDC_ARROW | mov D$hCursor eax
    call 'User32.RegisterClassA' WindowClass

    call 'User32.CreateWindowExA' &WS_EX_CLIENTEDGE, WindowClassName, WindowCaption,
                                 &WS_OVERLAPPEDWINDOW__&WS_VISIBLE,
                                 D$WindowX, D$WindowY, D$WindowW, D$WindowH, 0,
                                 &NULL, D$hInstance, 0
    mov D$WindowHandle eax

    call 'User32.CreateWindowExA',
        0,
        {"BUTTON",0},
        {"Subclass Example",0},
        &WS_CHILD+&WS_CLIPSIBLINGS+&WS_VISIBLE,
        16,16,150,40,
        D$WindowHandle,
        2,
        D$hInstance,
        0
    mov D$SubclassButton_handle eax

    ; Here is where we redirect the WindowProc that normal handles
    ; a windows messages and send it to our own. The API call return a
    ; handle to the previous Procedure, we shall save it in order to restore
    ; it before the app terminates. (NOTE: I see examples everywhere on the
    ; net that call GetWindowLong first, this isn't needed and its apparent
    ; the programmer hasn't read the documentation.)
    call 'USER32.SetWindowLongA' D$SubclassButton_handle &GWL_WNDPROC ButtonProc
    mov D$OldButtonProc eax

    call 'GDI32.CreateFontIndirectA' @SubclassButton_LOGFONTSTRUCT | mov D$@SubclassButtonFont_handle eax
    call 'User32.SendMessageA' D$SubclassButton_handle  &WM_SETFONT eax &TRUE
    [@SubclassButtonFont_handle: ?]
    [@SubclassButton_LOGFONTSTRUCT:  0-11  0  0  0  0  0  536870912 'MS Sans Serif' 0 0 0 0 0 0 ]

    call 'User32.ShowWindow' D$WindowHandle, &SW_SHOW
    call 'User32.UpdateWindow' D$WindowHandle

    jmp L1>

    While eax <> 0
        call 'User32.TranslateMessage' FirstMessage
        call 'User32.DispatchMessageA' FirstMessage
L1:     call 'USER32.GetMessageA' FirstMessage 0 0 0
    End_While

    call 'Kernel32.ExitProcess' &NULL

___________________________________________________________________________________________

Proc MainWindowProc:
    Arguments @Addressee @Message @wParam @lParam

    pushad

      .If D@Message = &WM_CREATE

      .Else_If D@Message = &WM_CLOSE

        ; Now before we leave, we must set the old procedure back.
        If D$SubclassButton_handle <> &NULL
            call 'USER32.SetWindowLongA' D$SubclassButton_handle,
                                         &GWL_WNDPROC,
                                         D$OldButtonProc
        End_If

      call 'USER32.DestroyWindow' D@Addressee

      .Else_If D@Message = &WM_DESTROY
           call 'User32.PostQuitMessage' 0

      .Else
          popad
          call 'User32.DefWindowProcA' D@Addressee, D@Message, D@wParam, D@lParam
          ExitP

      .End_If

      popad | mov eax &FALSE

EndP
____________________________________________________________________________________________

; Here is our new button procedure.
; The button is basically a child window and now
; we can receive any message a parent window would receive.

Proc ButtonProc:
    Arguments @hWnd @Message @wParam @lParam

    pushad

    .If D@Message = &WM_MOUSEMOVE

    .Else_If D@Message = &WM_LBUTTONDOWN

    .Else_If D@Message = &WM_LBUTTONUP
        MessageBox Whaoo "You left clicked me!"

    .Else_If D@Message = &WM_RBUTTONDOWN

    .Else_If D@Message = &WM_RBUTTONUP
        ; If you want to make the button move like a
        ; left click, see my owner draw example.
        MessageBox Whaoo "You right clicked me!"

    .End_If

    popad

    call 'USER32.CallWindowProcA' D$OldButtonProc, D@hWnd, D@Message, D@wParam, D@lParam

EndP


