
; Owner Draw Button Example
; RobotBob (Eric Asbell)
; easbell@quanta-it.com
; 2005

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Level:        Intermediate
; Requires:     a base knowledge of Win32 api.

; I make an assumption that you know the basics of creating an
; win32 application, fundmental assembly and how to use win32 api
; documentation.

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

; Here is a simple example of how to produce your
; own ownerdrawn control in RosAsm. If you find an error
; or have any questions email me and I will revise it.
_____________________________________________________________________________________________
_____________________________________________________________________________________________

; General purpose macros:
[push | push #1 | #+1]  [pop | pop #1 | #+1]  [mov | mov #1 #2 | #+2]
[inc | inc #1 | #+1]    [dec | dec #1 | #+1]

[Align_on | add #2 #1-1 | and #2 0-#1]

[On | cmp #1 #3 | jn#2 M1> | #4>L | M1:]
[call | push #L>2 | call #1]
[move | push #2 | pop #1 | #+2]      ; (for mem to mem moves, for exemple)

[If | cmp #1 #3 | jn#2 I1>]
[Else_if | jmp I9> | I1: | cmp #1 #3 | jn#2 I1>]
[Else | Jmp I9> | I1:]
[End_if | I1: | I9:]

[.If | cmp #1 #3 | jn#2 J1>>]
[.Else_if | jmp J9>> | J1: | cmp #1 #3 | jn#2 j1>>]
[.Else | Jmp j9>> | j1:]
[.End_if | j1: | j9:]

[..If | cmp #1 #3 | jn#2 K1>>]
[..Else_if | jmp K9>> | K1: | cmp #1 #3 | jn#2 K1>>]
[..Else | Jmp K9>> | K1:]
[..End_if | K1: | K9:]

[...If | cmp #1 #3 | jn#2 Z1>>]
[...Else_if | jmp Z9>> | Z1: | cmp #1 #3 | jn#2 Z1>>]
[...Else | Jmp Z9>> | Z1:]
[...End_if | Z1: | Z9:]

[While | W0: | cmp #1 #3 | jn#2 W9>]
[End_While | jmp W0< | W9:]

[.While | X0: | cmp #1 #3 | jn#2 X9>>]
[.End_While | jmp X0<< | X9:]

[..While | Y0: | cmp #1 #3 | jn#2 Y9>>]
[..End_While | jmp Y0<< | Y9:]

[Do | D0:]
[Loop_Until | cmp #1 #3 | jn#2 D0<]
[Do_Loop | jmp D0<<]

[.Do | E0:]
[.Loop_Until | cmp #1 #3 | jn#2 E0<<]

[Exchange | push #1 | push #2 | pop #1 | pop #2 | #+2]
[Agree | cmp #1 #3 | j#2 A9> | #+3]
[Reject | cmp #1 #3 | j#2 A8> | #+3 | jmp A9> | A8: | ret | A9:]

_________________________________________________________________________________________
_________________________________________________________________________________________
; Proc Macros and Equates. Internal storages are:
;
; &1 <<< Size of Argument(s) (for ending Ret n, in EndP). Set by Argument(s)
; &2 <<< Size of Local (for Stack Management). Set by Local
; &3 <<< What to pop before ret. Set by Uses.

[Proc | &1=0 | &2=0 | &3= | #1 | push ebp | mov ebp esp]
[Proc2 | &1=0 | &2=0 | &3= | #1 |  mov ebp esp | push ebp ]
[ExitP | jmp P9>>]

[Arguments | {#1 Arg#x} | #+1 | &1=SizeOf#x]
[Argument  | {#1 Arg#x} | #+1 | &1=SizeOf#x]

[Local | {#1 Local#x} | #+1 | sub esp SizeOf#x | &2=SizeOf#x]
[StrucPtrs | {#3 ebp+#2+#F} | #+2]
[Structure | {#1 ebp-&2-4} | sub esp #2+4 | mov D$#1 esp | StrucPtrs 0-&2-#2-4 #L>3]
[Uses | push #1>L | &3=pop #L>1]
[EndP | P9: | &3 | mov esp ebp | pop ebp | ret &1]

; For pointing to transmitted parameters (upper "Arg#x" fall here):
[Arg1 ebp+8    Arg2 ebp+12    Arg3 ebp+16    Arg4 ebp+20   Arg5 ebp+24
 Arg6 ebp+28   Arg7 ebp+32    Arg8 ebp+36    Arg9 ebp+40   Arg10 ebp+44]

; For pointing Local Stack declared data (upper "Local#x" fall here):
[Local1 ebp-4     Local2 ebp-8     Local3 ebp-12    Local4 ebp-16    Local5 ebp-20
 Local6 ebp-24    Local7 ebp-28    Local8 ebp-32    Local9 ebp-36    Local10 ebp-40]

; To help preventing from stack sizes' mistakes (upper "SizeOf#x" fall here):
[SizeOf1 4     SizeOf2 8     SizeOf3 12    SizeOf4 16    SizeOf5 20
 SizeOf6 24    SizeOf7 28    SizeOf8 32    SizeOf9 36    SizeOf10 40]

____________________________________________________________________________________________
____________________________________________________________________________________________
; Equates for HLL comparisons (with 'If' and friends):

[= e   < b    > a    <s l    >s g    =< be    <= be    => ae    >= ae    <> ne]
_____________________________________________________________________________________________
_____________________________________________________________________________________________

;These macros are mine, for use with my Debug output window.

;;

[OutPutDec | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutDec' #1 &0]
[OutPutSignedDec | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutSignedDec' #1 &0]
[OutPutHex | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutHex' #1 &0]
[OutPutFloat | fld #1 | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutFloat' #1 &0 #2 #3]
[OutPutString | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutString' #1 &0]
[OutPutError | call 'KERNEL32.GetLastError' | call 'QDEBUG.OutPutError' eax ]
[OutPutStringLiteral | &4=#1 | { &0: B$ &4 0 } | call 'QDEBUG.OutPutStringSimple' &0 ]
[OutPutLog | call 'QDEBUG.OutPutLogFile' #1]
;;

_________________________________________________________________
[Argh: 'Aaarrrghhh!!!!....', 0    Whaoo: 'Whaaaaoooo!!!!....', 0]
[MessageBox | {&0: #2 0} | call 'USER32.MessageBoxA' &NULL &0 #1 &MB_SYSTEMMODAL__&MB_OK]
; ... to be called, for example, by:
;
; > MessageBox Whaoo 'Oh! No, please!!! not that again!...'
___________________________________________________________________________________________
; Data:

; For "GetMessage":
[FirstMessage: 0 #7]

; Window Class Structure:
[WindowClass:
 style: 3
 lpfnWndProc: MainWindowProc
 cbClsExtra: 0
 cbWndExtra: 0
 hInstance: 0
 hIcon: 0
 hCursor: 0
 hbrBackground: 1
 lpszMenuName: 0
 lpszClassName: WindowClassName]

[WindowHandle: 0   MenuHandle: 0]
[WindowClassName: B$ 'OWButton' 0    WindowCaption: 'OwnerDraw Button Example' 0]
[WindowX: 50  WindowY: 50  WindowW: 250  WindowH: 120]

____________________________________________________________________________________________

; Here is the Data and Macros for our example.

; A macro to generate COLOREFs from a set of RGB numbers
; example: RGB 255 0 0
[RGB|mov al #3|shl eax 8|add al #2|shl eax 8|add al #1|and eax 0FFFFFF]

; handle of the brush used to pain the button with FillRect
[Brush: D$ ?]

; Our Displacement table. Since the WM_DRAWITEM returns in the
; lParam a DRAWITEMSTRUCT. We will need a (easy on the eyes) way
; to access the elements in this table.
; Since we have only one DRAWITEMSTRUCT in this table, only
; this: base+displacement is needed. Refer to the B_U_ASM.EXE->Addressing
; for more information.

[CtlTypeDis 0
 CtlIDDis 4
 itemIDDis 8
 itemActionDis 12
 itemStateDis 16
 hwndItemDis 20
 hdcDis 24
 rcItem.leftDis 28
 rcItem.topDis 32
 rcItem.rightDis 36
 rcItem.bottomDis 40
 itemDataDis 44]

; This equate is to allow us an easy reference to the button
; inside the WM_COMMAND messages
[OurButton 200]

; This is the text we are going to draw onto the OwnerDraw button.
[BTEXT: B$ "Click Me!" 0]
___________________________________________________________________________________________

; Here is our program entry point: Main
Main:
    call 'Kernel32.GetModuleHandleA' 0 | mov D$hInstance eax

    ; This is our standard load icon for any application. Later
    ; we shall use this handle to display this icon on our button.
    call 'User32.LoadIconA' D$hInstance, 1 | mov D$hIcon eax
    call 'User32.LoadCursorA' 0, &IDC_ARROW | mov D$hCursor eax
    call 'User32.RegisterClassA' WindowClass

    call 'User32.CreateWindowExA' &WS_EX_CLIENTEDGE,
                                 WindowClassName, WindowCaption,
                                 &WS_OVERLAPPEDWINDOW__&WS_VISIBLE,
                                 D$WindowX, D$WindowY, D$WindowW, D$WindowH, 0,
                                 &NULL, D$hInstance, 0
    mov D$WindowHandle eax

    ; After we create ths main window, now we create our owner drawn
    ; button. Seperating them is not required, but I have created a procedure
    ; here for clarity.
    call CreateOurButton

    call 'User32.ShowWindow' D$WindowHandle, &SW_SHOW
    call 'User32.UpdateWindow' D$WindowHandle

    jmp L1>

    While eax <> 0
        call 'User32.TranslateMessage' FirstMessage
        call 'User32.DispatchMessageA' FirstMessage
L1:     call 'USER32.GetMessageA' FirstMessage 0 0 0
    End_While

    call 'Kernel32.ExitProcess' &NULL

___________________________________________________________________________________________

; A standard MainWindow callback procedure, with a test
; for our important message: &WM_DRAWITEM
Proc MainWindowProc:
    Arguments @Addressee @Message @wParam @lParam

    pushad

      .If D@Message = &WM_CLOSE
           call 'USER32.DestroyWindow' D@Addressee

      .Else_If D@Message = &WM_CREATE

      .Else_If D@Message = &WM_COMMAND

           ; OurButton is an equate for the value 200
           ; 200 is the ID number we assigned it when we created
           ; the ownerdraw button.

           If D@wParam = OurButton
                ; The button has been clicked.
                MessageBox Whaoo "Clicked"
           End_If

      .Else_If D@Message = &WM_DRAWITEM

            ;wParam Holds the control identifier
            ;lParam Holds a pointer to a DRAWITEMSTRUCT

            ; Now we could handle all of our drawing right here,
            ; but for the sake of readability and clarity, I am
            ; call a procedure for this.

            ; Is it our button ? hmmm
            If D@wParam = OurButton
                ; Yes! draw it :)
                call DrawTheButton D@wParam D@lParam

            End_If

            ;If an application processes this message, it should return TRUE.
            mov eax &TRUE

      .Else_If D@Message = &WM_DESTROY
           call 'User32.PostQuitMessage' 0

      .Else
          popad
          call 'User32.DefWindowProcA' D@Addressee, D@Message, D@wParam, D@lParam
          ExitP

      .End_If

      popad
      mov eax &FALSE

EndP
______________________________________________________________________________________

; Here is our code to create the button, made with Scarmatil's
; wonderful Window wizard, thanks a million Scarmatil!
CreateOurButton:

call 'User32.CreateWindowExA',
        0,
        {"BUTTON",0},
        {"OwnerDraw Button",0},
        &WS_CHILD+&WS_VISIBLE+&BS_OWNERDRAW, ; We must set this bit '&BS_OWNERDRAW'
        15,15,175,48,                        ; for us to gain control over drawing
        D$WindowHandle,                      ; the control.
        200,
        D$hInstance,
        0
    mov D$@OurButton_handle eax
    [@OurButton_handle: ?]
    call 'GDI32.CreateFontIndirectA' @OurButton_LOGFONTSTRUCT | mov D$@OurButtonFont_handle eax
    call 'User32.SendMessageA' D$@OurButton_handle  &WM_SETFONT eax &TRUE
    [@OurButtonFont_handle: ?]
    [@OurButton_LOGFONTSTRUCT:  0-16  0  0  0  0  0  536870912 'MS Sans Serif' 0 0 0 0 0 0 ]

ret
____________________________________________________________________________________________

Proc DrawTheButton:
    ; Handy macros for readability
    Arguments @CTL_ID @DIS_PTR ; Although I do not use CTL_ID in this example
    Uses ebx,esi

    ; This (RC) local will hold a the address of the RC struct passed
    ; via the wParam. Later we need to pass the structure to API.
    ; (FillBrush) will hold the brush for the FillRect API.
    Local @RC @FillBrush

    ; Move the base address of the passed struct into ebx for later access.
    mov ebx D@DIS_PTR

    ; Ok now we load into esi the address of the ownerdrawn control's RECT
    ; structure and back into our local.
    lea esi D$ebx+rcItem.leftDis ; D$base+displacement
    mov D@RC esi

    ; Our RGB macro to generate a COLOREF and the results in EAX
    ; A COLOREF is a hexi number arranged like: 0x00bbggrr (b=blue g=green r=red)
    RGB 0 175 0
    ; We will use this Brush for the following FillRect
    call 'GDI32.CreateSolidBrush' eax
    mov D@FillBrush eax

    ; We now paint the entire contents of the button the color
    ; we selected in our RGB marco.
    call 'USER32.FillRect' D$ebx+hdcDis D@RC D@FillBrush

    ; we first set the default state of our button to *Raised*
    call 'USER32.DrawEdge' D$ebx+hdcDis D@RC,
                               &BDR_RAISEDINNER+&BDR_RAISEDOUTER &BF_RECT

    ; OK lets us draw the button based on what *state* it may be in.
    ; So we send a message to the button.
    call 'USER32.SendMessageA' D$ebx+hwndItemDis &BM_GETSTATE 0 0

    .If eax = 108           ; It was pushed.
            call 'USER32.DrawEdge' D$ebx+hdcDis D@RC,
                               &BDR_SUNKENINNER+&BDR_SUNKENOUTER &BF_RECT

        .Else_If eax = 104  ; It was released.
            call 'USER32.DrawEdge' D$ebx+hdcDis D@RC,
                               &BDR_RAISEDINNER+&BDR_RAISEDOUTER &BF_RECT

        .Else_if eax = 120  ;it now has focus.
            call 'USER32.DrawFocusRect' D$ebx+hdcDis D@RC

    .End_If

    ; Draw an icon on the control just to show we can :)
    ; Essentially you can place it anywhere you wish. ( of any size )
    call 'USER32.DrawIconEx' D$ebx+hdcDis 15 15 D$hIcon 20 20 &NULL &NULL &DI_NORMAL

    ; This sets the area around the text to tranparent.
    ; If not, it will return to the system set *buttonface* color.
    ; Comment this out and see for yourself.
    call 'GDI32.SetBkMode' D$ebx+hdcDis &TRANSPARENT

    ; Once again RGB for ColoREF to select the desired text color.
    RGB 255 255 255 ; White
    call 'GDI32.SetTextColor' D$ebx+hdcDis eax

    ; DrawText needs the length of the text. You are not required to
    ; null terminate it. You could just hard code a number if you wish.
    call 'KERNEL32.lstrlenA' BTEXT

    ; Now Draw it :)
    call 'USER32.DrawTextA' D$ebx+hdcDis BTEXT eax D@RC &DT_CENTER+&DT_VCENTER+&DT_SINGLELINE

    ; Clean up. Delete the brush we created for the FillRect.
    call 'GDI32.DeleteObject' D@FillBrush

EndP

