TITLE Zip

[ListboxClass: 'Listbox', 0]
[SelectAFile: 'Select a file', 0]
[ZIPFilename: B$ ? #&MAX_PATH]
LoadZIP:

    arguments @pFilename
    call 'Kernel32.GlobalFree' D$pFile | mov D$pFile &NULL

    ; Load DLL
    call LoadUnzipDLL

    if. D$pUnzipToMemory != &NULL

        ; Save zip name
        mov B$ZIPFilename 0
        call AddString ZipFilename, D@pFilename

        ; Open unzip dialog
        call 'User32.DialogBoxParamA' D$hInstance, IDD_UNZIP, D$hMainWindow, UnzipDialogProc, &NULL

    else

        ; You need unzip32.dll
        call 'User32.MessageBoxA' D$hMainWindow,
                                  {'To load zip files, download unzip32.dll from www.techemporium.info and place it in the same directory as TechNES.exe.', 0},
                                  {'The file unzip32.dll has not been found.', 0},
                                  &MB_OK+&MB_ICONINFORMATION
    endif

    ; Unload DLL
    call UnloadUnzipDLL
    return

UnzipFile:

    arguments @pFilename

    ; Load DLL
    call LoadUnzipDLL
    on D$pUnzipToMemory = &NULL, Q0>>

    ; Put '\' in front of all special characters
    [@Filename: B$ ? #&MAX_PATH]
    mov esi D@pFilename, edi @Filename
L0: lodsb
    on al = '[', S0>
    on al = ']', S0>
    on al = '*', S0>
    on al = '?', S0>
    on al = '!', S0>
    on al = '^', S0>
    on al = '-', S0>
    on al = '\', S0>
    on al = 0, S1>
    stosb | jmp L0<
S0: mov B$edi '\' | inc edi
    stosb | jmp L0<
S1: stosb

    ; Unzip file
    call D$pUnzipToMemory ZipFilename, @Filename, UserFunctions, UnzipBuffer
    if. eax != 0

        ; Filetitle
        mov B$Filetitle 0
        call AddString Filetitle, D@pFilename
        mov edi Filetitle, ecx 0-1, al 0
        repne scasb
        sub edi 5 | call ZeroMemory edi, 4
        ; Load data
      . D$pFile = 'Kernel32.GlobalAlloc' &GPTR, D$UnzipBuffer@Length
        call CopyMemory D$UnzipBuffer@pData, D$pFile, D$UnzipBuffer@Length
        copy D$UnzipBuffer@Length D$Filesize
        call LoadNES

    endif
    call UnloadUnzipDLL
Q0: return
____________________________________________________________________________________________
; Unzip dialog
____________________________________________________________________________________________

[hUnzipDialog: ?]
[nZippedFiles: ?]

ServiceCallback:

    arguments @pFilename, @FileSize
    pushad

        ; Fill listbox
        call 'User32.SendDlgItemMessageA' D$hUnzipDialog, IDC_LISTBOX+0, &LB_ADDSTRING, 0, D@pFilename
        inc D$nZippedFiles
        if D$nZippedFiles = 10, call ClearAudio

    popad
    mov eax 0
    return

UnzipDialogProc:

    arguments @hDialog, @Message, @wParam, @lParam
    pushad

        ; Message?
        if. D@Message = &WM_INITDIALOG | call @Init    | else
        if. D@Message = &WM_COMMAND    | call @Command | else
        if. D@Message = &WM_CLOSE      | call @Close   | else
        mov eax &FALSE | endif

        mov D$esp+01C eax

    popad
    return

@Init:

    copy D@hDialog D$hUnzipDialog

    ; Check zip file
    [@Extension: '*.nes', 0]
    mov D$nZippedFiles 0
    call D$pUnzipToMemory ZipFilename, @Extension, UserFunctions, UnzipBuffer

    call 'User32.GetDlgItem' D@hDialog, IDC_LISTBOX+0 | call HorizontalScrollbar eax

    ; No files --> kill dialog
    if. D$nZippedFiles = 0
        call @Close
    else
    ; Single file --> load it
    if. D$nZippedFiles = 1
        mov eax 0
        call @LoadFile
    else
    ; Multiple files --> show dialog
    if. D$nZippedFiles > 1
        call 'User32.ShowWindow' D@hDialog, &TRUE
    endif
    mov eax &TRUE
    ret

@Command:

    ; Double-click?
    if. W@wParam+2 = &LBN_DBLCLK
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETCURSEL, 0, 0
        call @LoadFile
    endif
    mov eax &TRUE
    ret

@Close:

    ; Kill dialog
    call 'User32.EndDialog' D@hDialog, 1
    mov eax &TRUE
    ret

____________________________________________________________________________________________

@LoadFile:

    call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETTEXT, eax, Filename
    call @Close
    call UnzipFile Filename
    ret

HorizontalScrollbar:

    [@hDC:      ?
     @hFontOld: ?
     @hFontNew: ?
     @nCount:   ?
     @nLength:  ?
     @Size:     ? ?
     @Text:     ? #&MAX_PATH]

    arguments @hWindow
    mov D@nLength 0
    pushad

        ; Retrieve data
      . D@hDC = 'User32.GetDC' D@hWindow
      . D@hFontNew = 'User32.SendMessageA' D@hWindow, &WM_GETFONT, &NULL, &NULL
      . D@hFontOld = 'GDI32.SelectObject'  D@hDC, D@hFontNew

        ; Find longest string
      . D@nCount = 'User32.SendMessageA' D@hWindow, &LB_GETCOUNT, 0, 0
    L0: if. D@nCount > 0
            dec D@nCount
            call 'User32.SendMessageA' D@hWindow, &LB_GETTEXTLEN, D@nCount, &NULL | inc eax
            push eax
                call 'User32.SendMessageA' D@hWindow, &LB_GETTEXT, D@nCount, @Text
            pop eax
            call 'GDI32.GetTextExtentPoint32A' D@hDC, @Text, eax, @Size
            mov eax D@Size
            if eax > D@nLength, mov D@nLength eax
            jmp L0<
        endif

        ; Restore data, set new width
    S0: call 'GDI32.SelectObject' D@hDC, D@hFontOld
        call 'User32.ReleaseDC' D@hWindow, D@hDC
        call 'User32.SendMessageA' D@hWindow, &LB_SETHORIZONTALEXTENT, D@nLength, 0

    popad
    return

____________________________________________________________________________________________
; Load unload DLL
____________________________________________________________________________________________

[UnzipDLL: 'Unzip32', 0]
[UnzipToMemory: 'Wiz_UnzipToMemory', 0]
[hUnzipDLL: ?]
[pUnzipToMemory: ?]
LoadUnzipDLL:

  . D$hUnzipDLL = 'Kernel32.LoadLibraryA' UnzipDLL
  . D$pUnzipToMemory = 'Kernel32.GetProcAddress' eax, UnzipToMemory
    ret

UnloadUnzipDLL:

    call 'Kernel32.FreeLibrary' D$hUnzipDLL
    mov D$pUnzipToMemory &NULL
    ret

____________________________________________________________________________________________
; Unzip32.dll stuff
____________________________________________________________________________________________

PrintRoutine:

    mov eax D$esp+04, ebx D$esp+08
    int 3 | mov eax 0 | ret 8
PasswordRoutine: int 3 | mov eax 0 | ret 8
ReplaceRoutine:  int 3 | mov eax 0 | ret 4
SendMessage:     int 3 | mov eax 0 | ret (13 shl 2)
SoundRoutine:    ret

[UnzipBuffer:
 @Length:  ?
 @pData:   ?]

[UserFunctions:
 PrintRoutine
 SoundRoutine
 ReplaceRoutine
 PasswordRoutine
 SendMessage
 ServiceCallback

 TOtalSizeComp: 0
 TotalSize: 0
 NumMembers: 0
 cchComment: 0]

____________________________________________________________________________________________
