TITLE WindowProc
____________________________________________________________________________________________
; Winproc
____________________________________________________________________________________________

[MessageTable:

 ; User interaction
 &WM_NCLBUTTONDBLCLK,   WmNCLButtonDblClick
 &WM_NCMBUTTONDBLCLK,   Silence
 &WM_NCRBUTTONDBLCLK,   Silence
 &WM_NCLBUTTONDOWN,     Silence
 &WM_NCMBUTTONDOWN,     Silence
 &WM_NCRBUTTONDOWN,     Silence

 &WM_ENTERSIZEMOVE,     Silence
 &WM_ENTERMENULOOP,     Silence
 &WM_COMMAND,           WmCommand
 &WM_DROPFILES,         WmDropFiles
 &WM_LBUTTONDOWN,       WmLButtonDown
 &WM_LBUTTONUP,         WmLButtonUp
 &WM_RBUTTONDOWN,       WmRButtonDown
 &WM_MOUSEMOVE,         WmMouseMove
 &WM_KEYDOWN,           WmKeyDown

 ; Drawing
 &WM_PAINT,             WmPaint
 &WM_ERASEBKGND,        WmEraseBackground
 &WM_DISPLAYCHANGE      WmDisplayChange

 ; Borders
 &WM_SIZING,            WmSizing
 &WM_SIZE,              WmSize
 &WM_MOVE,              WmMove
 &WM_MOVING,            WmMoving

 ; System notifications
 &WM_CREATE             WmCreate
 &WM_TIMER              WmTimer
 &WM_ACTIVATE,          WmActivate
 &WM_ACTIVATEAPP,       WmActivateApp
 &WM_SYSCOMMAND,        WmSysCommand
 &WM_DESTROY,           WmDestroy

 @EndMessage: 0         Default]

MainWindowProc:

    arguments hWindow, Message, wParam, lParam
    pushad

        ; Use the jump table
        copy D$Message D$MessageTable@EndMessage
        mov esi MessageTable
    L0: lodsd | add esi 4 | on eax != D$Message, L0<
        call D$esi-4

        mov D$esp+28 eax

    popad
    return
____________________________________________________________________________________________

; DefWindowProc
Default: call 'User32.DefWindowProcA' D$hWindow, D$Message, D$wParam, D$lParam | ret
____________________________________________________________________________________________

WmCreate:

    ; Create timer
    call 'User32.SetTimer' D$hWindow, IDT_MAIN, 250, &NULL

    mov D$Window@Existing &TRUE
    mov eax &TRUE
    ret

; Got/lost focus
WmActivateApp:

    ; Application lost focus? Fullscreen --> Minimize
    if W$wParam = &FALSE,
        if D$DisplayMode = DM_FULLSCREEN,
            call 'User32.CloseWindow' D$hWindow
    mov eax 0
    ret

WmActivate:

    ; Memorize window active/inactive
    call ClearAudio
    cmp W$wParam &WA_INACTIVE | setne B$Window@Active
    mov eax 0
    ret

WmTimer:

    [@Icon: 0]
    xor B@Icon 1 | mov ebx D@Icon
    call 'User32.SetClassLongA' D$hWindow, &GCL_HICON, D$hIcon+ebx*4
    ret

WmSysCommand:

    on D$wParam != &SC_SCREENSAVE, Default
    mov eax 0-1
    ret

WmDestroy:

    call UnloadNES

    ; Destroy
    call 'User32.KillTimer' D$hWindow, IDT_MAIN
    call 'User32.DestroyMenu' D$hMenu | winErrorCheck 'Could not destroy menu.'
    mov D$Window@Existing &FALSE

    ; Shut down DirectX
    call InputShutdown
    call AudioShutdown
    call VideoShutdown

    call 'User32.PostQuitMessage' 0
    mov eax 0
    ret

____________________________________________________________________________________________

; Clear sound buffer
Silence: call ClearAudio | call Default |  ret

; Menu
WmCommand:

    if. W$wParam+2 != 0

        mov eax 1

    else

        ; MRU list?
        if.. D$wParam > IDM_RECENT

            call MenuRecentItem

        else..

            ; Find the routine that handles this menu item
            mov eax D$wParam | sub eax IDM_MENU+1
            move eax MenuItemTable+eax*4
            if eax < EndOfMenuItemTable, call D$eax

        endif..
        mov eax 0

    endif
    ret

; Keyboard
WmKeyDown:
;;
    [Debug: 32 0 0 0 0]
    if D$wParam = &VK_F1,  xor B$Emulate@SoundSquare1  &TRUE
    if D$wParam = &VK_F2,  xor B$Emulate@SoundSquare2  &TRUE
    if D$wParam = &VK_F3,  xor B$Emulate@SoundTriangle &TRUE
    if D$wParam = &VK_F4,  xor B$Emulate@SoundNoise    &TRUE
    if D$wParam = &VK_F5,  xor B$Emulate@SoundDMC      &TRUE
    if D$wParam = &VK_6,   xor B$Emulate@SpriteZero    &TRUE
    if D$wParam = &VK_7,   xor B$Emulate@Background    &TRUE
    if D$wParam = &VK_8,   xor B$Emulate@Sprites       &TRUE
    if. D$wParam = &VK_9 | inc D$Debug+00 | outdec D$Debug+00 | endif
    if. D$wParam = &VK_0 | dec D$Debug+00 | outdec D$Debug+00 | endif
    if. D$wParam = &VK_O | inc D$Debug+04 | outdec D$Debug+04 | endif
    if. D$wParam = &VK_P | dec D$Debug+04 | outdec D$Debug+04 | endif
;;
    mov eax 0
    ret

; Mouse messages
WmDropFiles:

    call 'Shell32.DragQueryFile' D$wParam, 0, FullFilename, &MAX_PATH
    call LoadRemoteFile FullFilename
    mov eax 0
    ret

WmMouseMove:

    call ZapperCoordinates D$lParam
    mov eax 0
    ret

WmLButtonDown:

    mov B$Zapper@Triggered &TRUE
    call ZapperCoordinates D$lParam
    mov eax 0
    ret

WmLButtonUp:

    mov B$Zapper@Triggered &FALSE
    call ZapperCoordinates D$lParam
    mov eax 0
    ret

WmRButtonDown:

    call ToggleMenu
    mov eax 0
    ret

WmNCLButtonDblClick:

    if D$Displaymode = DM_FULLSCREEN, call SetWindowed
    jmp Silence
____________________________________________________________________________________________

; Paint messages
WmEraseBackground:

    on D$Window@Active = &FALSE, Default
    on D$DisplayMode = DM_FULLSCREEN, Default
    mov eax &TRUE
    ret

WmPaint:

    call Default
    call UpdateVideo
    mov eax 0
    ret

WmDisplayChange:

    call VideoShutDown
    call VideoInit
    ret

____________________________________________________________________________________________

; Window borders changed?

; Horrible code, but it works.
; Ratio is specified by D$ScreenWidth and D$ScreenHeight
WmSizing:

    [@Rect: ? #4]
    call ZeroMemory @Rect, 010
    call 'User32.AdjustWindowRectEx' @Rect, WINDOW_STYLE, &FALSE, WINDOW_STYLE_EX
    mov ebx D$lParam

    ; Border --> client area
    mov ecx 0
L0: mov eax D$ebx+ecx*4
    sub eax D$@Rect+ecx*4
    mov D$ebx+ecx*4 eax
    inc ecx | on ecx < 4, L0<

    mov eax D$ebx+8 | sub eax D$ebx
    if. eax < D$ScreenWidth
        call 'User32.GetWindowRect' D$hWindow, ebx
        mov eax &TRUE
        ret
    endif

    mov eax D$ebx+12 | sub eax D$ebx+4
    if. eax < D$ScreenHeight
        call 'User32.GetWindowRect' D$hWindow, ebx
        mov eax &TRUE
        ret
    endif

    ; Adjust which edge?
    on D$wParam = &WMSZ_LEFT,  L0>
    on D$wParam = &WMSZ_RIGHT, L0>
    on D$wParam = &WMSZ_BOTTOMLEFT, L1>
    on D$wParam = &WMSZ_TOPLEFT,    L1>

    ; Adjust right
    mov eax D$ebx+12
    sub eax D$ebx+4
    mov ecx D$ScreenWidth | mul ecx

    mov ecx D$ScreenHeight | div ecx
    add eax D$ebx
    mov D$ebx+8 eax
    jmp L2>

    ; Adjust bottom
L0: mov eax D$ebx+8
    sub eax D$ebx
    mov ecx D$ScreenHeight | mul ecx

    mov ecx D$ScreenWidth | div ecx
    add eax D$ebx+4
    mov D$ebx+12 eax
    jmp L2>

    ; Adjust left
L1: mov eax D$ebx+12
    sub eax D$ebx+4
    mov ecx D$ScreenWidth | mul ecx

    mov ecx D$ScreenHeight | div ecx
    mov edx D$ebx+8 | sub edx eax
    mov D$ebx edx

    ; Client area --> border
L2: mov ecx 4
L0: mov eax D$ebx+ecx*4-4
    add eax D$@Rect+ecx*4-4
    mov D$ebx+ecx*4-4 eax
    dec ecx | jnz L0<

    ; Return
    mov eax &TRUE
    ret

WmSize:

    ; Resized -> Save rect
    if D$wParam = &SIZE_RESTORED,
        if D$DisplayMode = DM_WINDOWED,
            call 'User32.GetWindowRect' D$hWindow WindowRect

    ; Maximized -> Fullscreen
    if D$wParam = &SIZE_MAXIMIZED, call SetFullscreen

    ; Minimized -> Set flag
    cmp D$wParam &SIZE_MINIMIZED | sete B$Window@Minimized

    ; Window style
    call 'User32.SetWindowLongA' D$hWindow, &GWL_STYLE, WINDOW_STYLE
    if D$Window@Minimized = &FALSE,
        if D$DisplayMode = DM_FULLSCREEN,
            call 'User32.SetWindowLongA' D$hWindow, &GWL_STYLE, FULLSCREEN_STYLE

    ; No display mode yet?
    if D$DisplayMode = &NULL, call SetWindowed
    call UpdateClientRect
    mov eax 0
    ret

WmMoving:

    call CopyMemory D$lParam, WindowRect, 010
    mov eax &TRUE
    ret

WmMove:

    ; Minimized --> negative coordinates
    ifFlag D$lParam 08000,
        ifNotFlag D$lParam 04000, ret
    call UpdateClientRect

    mov eax &TRUE
    ret

____________________________________________________________________________________________
; Cursor
____________________________________________________________________________________________

UpdateCursor:

    ; Visible?
    call HideCursor
    call 'User32.GetMenu' D$hMainWindow
    if eax != &NULL, call ShowCursor
    if D$DisplayMode != DM_FULLSCREEN, call ShowCursor

    ; Standard arrow
    call 'User32.LoadCursorA' &NULL, &IDC_ARROW
    call 'User32.SetClassLongA' D$hMainWindow, &GCL_HCURSOR, eax

    ; Zapper?
    if B$Port1 != CONTROLLER_ZAPPER,
        if B$Port2 != CONTROLLER_ZAPPER,
            ret
    call ShowCursor
    call 'User32.LoadCursorA' D$hInstance, 1
    call 'User32.SetClassLongA' D$hMainWindow, &GCL_HCURSOR, eax
    ret

[CursorHidden: ?]
HideCursor: if B$CursorHidden = &FALSE, call 'User32.ShowCursor' &FALSE | mov b$CursorHidden &TRUE  | ret
ShowCursor: if B$CursorHidden = &TRUE,  call 'User32.ShowCursor' &TRUE  | mov b$CursorHidden &FALSE | ret

____________________________________________________________________________________________
; OpenFilename data
____________________________________________________________________________________________

[FullFilename:  B$ ? #&MAX_PATH]
[FilterStrings: B$ 'NES ROMs', 0                  '*.nes;*.zip', 0
                   'All supported file types', 0, '*.nes;*.zip;*.pal;*.cfg;*.sst;*.sav;*.ips', 0, 0]
[OpenFilename:
 @lStructSize:         D$ len
 @hwndOwner:           D$ 0
 @hInstance:           D$ 0
 @lpstrFilter:         D$ FilterStrings
 @lpstrCustomFilter:   D$ 0
 @nMaxCustFilter:      D$ 0
 @nFilterIndex:        D$ 0
 @lpstrFile:           D$ FullFilename
 @nMaxFile:            D$ &MAX_PATH
 @lpstrFileTitle:      D$ 0
 @nMaxFileTitle:       D$ 0
 @lpstrInitialDir:     D$ 0
 @lpstrTitle:          D$ 0
 @Flags:               D$ &OFN_FILEMUSTEXIST+&OFN_EXPLORER
 @nFileOffset:         W$ 0
 @nFileExtension:      W$ 0
 @lpstrDefExt:         D$ 0
 @lCustData:           D$ 0
 @lpfnHook:            D$ 0
 @lpTemplateName:      D$ 0]
____________________________________________________________________________________________
