TITLE WinMain

Main:
____________________________________________________________________________________________
; Load resources
___________________________________________________________________________________________

    ; Load
  . D$hInstance = 'Kernel32.GetModuleHandleA' &NULL  S     | winErrorCheck 'Could not get module handle.'
  . D$hMenu     = 'User32.LoadMenuA' D$hInstance, IDM_MENU | winErrorCheck 'Could not load menu.'

    ; Load icons
    mov ecx NUM_ICONS
L0: push ecx
        call 'User32.LoadIconA' D$hInstance, ecx  | winErrorCheck 'Could not load icon.'
    pop ecx
    dec ecx
    mov D$hIcon+ecx*4 eax
    jnz L0<

    ; Load RC data
  . D$pDatabase  = LoadResource IDR_DATABASE
  . D$pConfig    = LoadResource IDR_CONFIG
  . D$pPalette   = LoadResource IDR_PALETTE
  . D$pLicense   = LoadResource IDR_LICENSE
  . D$pChangelog = LoadResource IDR_CHANGELOG
  . D$pManual    = LoadResource IDR_MANUAL

    ; Set database
    mov eax D$pDatabase
    mov edx D$eax | mov D$nROMs edx | add eax 4
    mov D$pCRC32 eax     | move eax eax+edx*4
    mov D$pPROMCRC32 eax | move eax eax+edx*4
    mov D$pData eax      | move eax eax+edx*8
    mov D$pNames eax

____________________________________________________________________________________________
; Create window
____________________________________________________________________________________________

    ; Register class
  . D$WindowClassEx@hbrBackground = 'GDI32.GetStockObject' &BLACK_BRUSH | winErrorcheck 'Could not get background brush.'
    copy D$hInstance D$WindowClassEx@hInstance
    copy D$hIcon     D$WindowClassEx@hIcon
    call 'User32.RegisterClassExA' WindowClassEx | winErrorCheck 'Could not register class.'

    ; Adjust window coordinates
    call 'User32.AdjustWindowRectEx' WindowRect, WINDOW_STYLE, &FALSE, WINDOW_STYLE_EX
    mov eax D$WindowRect+8  | sub eax D$WindowRect
    mov edx D$WindowRect+12 | sub edx D$WindowRect+4
    add D$WindowRect+00 040
    add D$WindowRect+04 040
    add D$WindowRect+08 040
    add D$WindowRect+0C 040

    ; Create window
  . D$hMainWindow = 'User32.CreateWindowExA' WINDOW_STYLE_EX,
                                             ClassName,
                                             Classname,
                                             WINDOW_STYLE,
                                             &CW_USEDEFAULT, &CW_USEDEFAULT,
                                             eax, edx,
                                             &NULL,
                                             &NULL,
                                             D$hInstance,
                                             &NULL
    winErrorCheck 'Could not create window.'
    call ShowMenu
____________________________________________________________________________________________
; Init other
____________________________________________________________________________________________

    ; DirectX
    call VideoInit
    call AudioInit
    call InputInit

    ; Nessie files
    call ParseCommandLine
    call LoadConfiguration
    if B$Argument != 0, call LoadRemoteFile Argument
____________________________________________________________________________________________
; Main loop
____________________________________________________________________________________________

    [Paused: ?]
L0: on B$Window@Active = &FALSE,   S1>
    on B$Window@Minimized = &TRUE, S1>
    on B$Paused = &TRUE,           S0>
    on D$Power != POWER_ON,        S0>
    on D$pImage = &NULL,           S0>

    call RunOneFrame
S0: call GetDeviceStates
    call TranslateInput
    call HandleInput
    jmp S2>

S1: call 'User32.WaitMessage'

____________________________________________________________________________________________
; Check message queue
____________________________________________________________________________________________

    ; Check for message
    [@Message: ? #7]
S2: call 'User32.PeekMessageA' @Message, 0, 0, 0, &PM_REMOVE
    on eax = 0, L0<<

    ; Handle message
    call 'User32.TranslateMessage' @Message
    call 'User32.DispatchMessageA' @Message
    mov eax &FALSE
    on D@Message+04 != &WM_QUIT, L0<<

____________________________________________________________________________________________
; Shutdown
____________________________________________________________________________________________

    call UnloadUnzipDLL
    call 'User32.UnregisterClassA' ClassName, D$hInstance | winErrorCheck 'Could not unregister class.'
    call 'Kernel32.ExitProcess' 0

____________________________________________________________________________________________
; Windows data
____________________________________________________________________________________________

[hInstance: ?]

; Window class
[ClassName: B$ 'TechNES', 0]
[WindowClassEx:
 @cbSize:        len
 @style:         &CS_HREDRAW+&CS_VREDRAW
 @lpfnWndProc:   MainWindowProc
 @cbClsExtra:    0
 @cbWndExtra:    0
 @hInstance:     0
 @hIcon:         0
 @hCursor:       0
 @hbrBackground: 0
 @lpszMenuName:  0
 @lpszClassName: ClassName
 @hIconSm:       0]

; Window
[hMainWindow: ?]
[Window:
 @Active:       ?
 @Minimized:    ?
 @Existing:     ?]
[hMenu: ?]
[NUM_ICONS 2]
[hIcon:  ? #NUM_ICONS]
[ScreenWidth:  0100
 ScreenHeight: (NTSC_SCREEN_BOTTOM-NTSC_SCREEN_TOP)]
[DisplayMode: ?]
[DM_NOTHING    0
 DM_WINDOWED   1
 DM_FULLSCREEN 2]
[FULLSCREEN_STYLE  &WS_VISIBLE+&WS_POPUP]
[WINDOW_STYLE      &WS_VISIBLE+&WS_OVERLAPPEDWINDOW]
[WINDOW_STYLE_EX   &WS_EX_ACCEPTFILES]
[WindowRect: 0, 0, 512, ((NTSC_SCREEN_BOTTOM-NTSC_SCREEN_TOP) shl 1)]

enumerate 1,
    IDT_MAIN,
    IDT_ABOUT,
    IDT_PRESSNEWBUTTON,
    IDT_AUTOFIRE

____________________________________________________________________________________________
; Resources
____________________________________________________________________________________________

LoadResource:

    arguments @ID
    call 'Kernel32.FindResourceA' D$hInstance, D@ID, &RT_RCDATA
    call 'Kernel32.LoadResource' D$hInstance, eax
    call 'Kernel32.LockResource' eax
    return

enumerate 1,

    IDR_DATABASE,
    IDR_CONFIG,
    IDR_PALETTE,
    IDR_LICENSE,
    IDR_CHANGELOG,
    IDR_MANUAL

; RC data
[pDataBase:  ?
 pConfig:    ?
 pPalette:   ?
 pLicense:   ?
 pChangelog: ?
 pManual:    ?]
; Database
[pCRC32:     ?
 pPROMCRC32: ?
 pData:      ?
 pNames:     ?
 nROMs:      ?]
____________________________________________________________________________________________
; Command line parser
____________________________________________________________________________________________

ParseCommandLine:

    [@pCommandLine: ?
     @nLength:      ?]

    ; Get command line
  . D@pCommandLine = 'Kernel32.GetCommandLineA'
    mov edi eax, ecx 0-1, al 0
    repne scasb | not ecx | mov D@nLength ecx

    ; Application path
    mov edi D@pCommandLine, al ' ', ecx D@nLength
    if. B$edi = '"'
        mov al '"'
        inc edi
    endif
    repne scasb
    mov D@nLength ecx
    jecxz Q0>

    ; Move to first argument
    mov esi edi
L0: lodsb | dec D@nLength
    on al = 0, Q0>
    on al = ' ', L0<
    on al = '"', L0<

    dec esi | inc D@nLength
    mov edi esi, al B$esi-1, ecx D@nLength
    repne scasb
    inc ecx | sub D@nLength ecx

    ; Copy argument
    call CopyMemory esi, Argument, D@nLength


    ; Get application path
Q0: call 'Kernel32.GetModuleFileNameA' D$hInstance, Filename, &MAX_PATH
    mov edi Filename, ecx 0-1, al 0 | repne scasb
    std
        neg ecx
        mov al '\' | repne scasb
    cld
    add edi 2 | sub edi Filename

    ; Set directories
    call CopyMemory Filename, FilesDirectory, edi
    mov B$FilesDirectory+edi 0
    call AddString FilesDirectory, FilesName
    call AddString NessieDirectory, FilesDirectory
    call AddString NessieDirectory, NessieName
    ret

____________________________________________________________________________________________
