TITLE VsSystem

ResetVsSystem:
;;

  // VS. Dual-System Games are not supported

      case 0xB90497AAUL: // Tennis
  case 0x008A9C16UL: // Wrecking Crew 
  case 0xAD407F52UL: // Balloon Fight
  case 0x18A93B7BUL: // Mahjong (J)
  case 0x13A91937UL: // Baseball 
  case 0xF5DEBF88UL: // Baseball 
  case 0xF64D7252UL: // Baseball 
  case 0x968A6E9DUL: // Baseball
  case 0xF42DAB14UL: // Ice Climber
  case 0x7D6B764FUL: // Ice Climber
;;
    ; Extra bits in $4016/$4017
    copy D$CPUReadTable+(04016 shl 2) D@fn4016
    copy D$CPUReadTable+(04017 shl 2) D@fn4017
    CPURead 04016, 04016, @Read4016
    CPURead 04017, 04017, @Read4017

    ; Coin
    CPUWrite 04020, 04020, @4020
    CPURead  04020, 04020, @Read4020

    ; Select palette
    PPUWrite 03F00, 03FFF, @WritePalette
    mov eax D$Cartridge@PROMCRC32
    mov D@PaletteIndex 0
    on eax = 017AE_56BE, Q0>> ; Freedom Force
    on eax = 0D99A_2087, Q0>> ; Gradius
    on eax = 0F063_2142, Q0>> ; Gradius [b1]
    on eax = 0FF51_35A3, Q0>> ; Hogan's Alley
    on eax = 0EC46_1DB9, Q0>> ; Pinball
    on eax = 0E2C0_A2BE, Q0>> ; Platoon, [b1], [a1]
    inc D@PaletteIndex
    on eax = 0FFBE_F374, Q0>> ; Castlevania
    on eax = 0CC2C_4B5D, Q0>> ; Golf, [b1], [b2]
    on eax = 08616_7220, Q0>> ; Ladies Golf
    on eax =  0B65_A917, Q0>> ; Mach Rider
    on eax = 08A6A_9848, Q0>> ; Mach Rider [b1]
    on eax = 07090_1B25, Q0>> ; Slalom
    inc D@PaletteIndex
    on eax = 07043_3F2C, Q0>> ; Battle City -
    on eax = 08D15_A6E6, Q0>> ; bad .nes    -
    on eax = 0D5D7_EAC4, Q0>> ; Dr. Mario
    on eax = 0CBE8_5490, Q0>> ; Excitebike
    on eax = 01E43_8D52, Q0>> ; Goonies     -
    on eax = 0135A_DF7C, Q0>> ; RBI Baseball -
    on eax = 04691_4E3E, Q0>> ; Soccer
    inc D@PaletteIndex
    on eax =  0713_8C06, Q0>> ; Clu Clu Land
    on eax = 02915_5E0C, Q0>> ; Excitebike [a1]
    on eax = 043A3_57EF, Q0>> ; Ice Climber, [o1]
    on eax = 08192_C804, Q0>> ; VS Super Mario Bros, [b2], [o1]
    on eax = 08B60_CC58, Q0>> ; VS Super Mario Bros [a1]
    on eax = 0737D_D1BF, Q0>> ; VS Super Mario Bros [b1]
    on eax = 04BF3_972D, Q0>> ; VS Super Mario Bros [b3], [b3][o1]
    on eax = 0E528_F651, Q0>> ; Pinball [a1]

    ; Palette not recognized
    PPUWrite 03F00, 03FFF, WritePalette
    outtext 'Unknown palette!'

Q0: ret

[@fn4016:       ?
 @fn4017:       ?
 @PaletteIndex: ?]
____________________________________________________________________________________________

@Read4016:

    call D@fn4016

    ; Add dip switch bits
    nop
    ret

@Read4017:

    call D@fn4017

    ; Add dip switch bits
    nop
    ret
____________________________________________________________________________________________

@4020:     ret
@Read4020: ret
____________________________________________________________________________________________

@WritePalette:

    and eax 03F
    mov ebx D@PaletteIndex | shl ebx 6
    if B$VsPalette+ebx+eax != 0FF, mov al B$VsPalette+ebx+eax
    jmp WritePalette

____________________________________________________________________________________________
; Mapper #099, NROM (VS)

; $4016: xxxxxCxx - swap 8k CROM at $0000
____________________________________________________________________________________________

Mapper099:

    ; Monitor $4016 writes
    copy D$CPUReadTable+(04016 shl 2) D@fn4016
    CPUWrite 04016, 04016, @4016
    ret

[@fn4016: ?]

@4016:

    mov edx eax | shr edx 2
    swap CROM, 8k, 00000, edx
    jmp D@fn4016

____________________________________________________________________________________________
; Mapper #151, CNROM (VS)

; $8000-$8FFF: PPPPPPPP - swap 8k PROM at $8000
; $A000-$AFFF: PPPPPPPP - swap 8k PROM at $8000
; $C000-$CFFF: PPPPPPPP - swap 8k PROM at $8000
; $E000-$EFFF: CCCCCCCC - swap 4k CROM at $0000
; $F000-$FFFF: CCCCCCCC - swap 4k CROM at $1000
____________________________________________________________________________________________

Mapper151:

    ; Memory mapping
    CPUWrite 08000, 08FFF, @8000_8FFF
    CPUWrite 0A000, 0AFFF, @A000_AFFF
    CPUWrite 0C000, 0CFFF, @C000_CFFF
    CPUWrite 0E000, 0EFFF, @E000_EFFF
    CPUWrite 0F000, 0FFFF, @F000_FFFF
    ret

; PPPPPPPP
@8000_8FFF: swap PROM, 8k, 08000, eax | ret
@A000_AFFF: swap PROM, 8k, 0A000, eax | ret
@C000_CFFF: swap PROM, 8k, 0C000, eax | ret
; CCCCCCCC
@E000_EFFF: swap CROM, 4k, 00000, eax | ret
@F000_FFFF: swap CROM, 4k, 01000, eax | ret
____________________________________________________________________________________________
; VS palettes
____________________________________________________________________________________________

[VsPalette: B$

  035, 0FF, 016, 022, 01C, 0FF, 0FF, 015, 0FF,  00, 027,  05,  04, 027,  08, 030,
  021, 0FF, 0FF, 029, 03C, 0FF, 036, 012, 0FF, 02B, 0FF, 0FF, 0FF, 0FF, 0FF,  01,
  0FF, 031, 0FF, 02A, 02C,  0C, 0FF, 0FF, 0FF,  07, 034,  06, 013, 0FF, 026,  0F,
  0FF, 019, 010,  0A, 0FF, 0FF, 0FF, 017, 0FF, 011,  09, 0FF, 0FF, 025, 018, 0FF

  0FF, 027, 018, 0FF, 03A, 025, 0FF, 031, 016, 013, 038, 034, 020, 023, 0FF,  0B,
  0FF, 021,  06, 0FF, 01B, 029, 0FF, 022, 0FF, 024, 0FF, 0FF, 0FF,  08, 0FF,  03,
  0FF, 036, 026, 033, 011, 0FF, 010,  02, 014, 0FF,  00,  09, 012,  0F, 0FF, 030,
  0FF, 0FF, 02A, 017,  0C,  01, 015, 019, 0FF, 02C,  07, 037, 0FF,  05, 0FF, 0FF

  0FF, 0FF, 0FF, 010, 01A, 030, 031,  09,  01,  0F, 036,  08, 015, 0FF, 0FF, 0F0,
  022, 01C, 0FF, 012, 019, 018, 017, 0FF,  00, 0FF, 0FF,  02, 016,  06, 0FF, 035,
  023, 0FF, 08B, 0F7, 0FF, 027, 026, 020, 029, 0FF, 021, 024, 011, 0FF, 0EF, 0FF,
  02C, 0FF, 0FF, 0FF,  07, 0F9, 028, 0FF,  0A, 0FF, 032, 037, 013, 0FF, 0FF,  0C

  018, 0FF, 01C, 089, 0FF, 0FF,  01, 017, 010,  0F, 02A, 0FF, 036, 037, 01A, 0FF,
  025, 0FF, 012, 0FF,  0F, 0FF, 0FF, 026, 0FF, 0FF, 022, 0FF, 0FF,  0F, 03A, 021,
   05,  0A,  07, 0C2, 013, 0FF,  00, 015,  0C, 0FF, 011, 0FF, 0FF, 038, 0FF, 0FF,
  0FF, 0FF,  08, 045, 0FF, 0FF, 030, 03C,  0F, 027, 0FF, 060, 029, 0FF, 030,  09]
____________________________________________________________________________________________
