TITLE Video
____________________________________________________________________________________________
; Init/shutdown
____________________________________________________________________________________________

VideoInit:

    ; IDirectDraw interface
    call 'DDraw.DirectDrawCreate' &NULL, lpdd, &NULL
    dxErrorCheck 'IDirectDraw creation failed.'
    if D$lpdd = &NULL, ret

    ; Set cooperative level
    dxCall lpdd,SetCooperativeLevel D$hMainWindow, &DDSCL_NORMAL
    dxErrorCheck 'Could not set cooperative level.'

    ; Create primary surface
    call ZeroMemory ddsd (SIZE_DDSD shl 2)
    mov D$ddsd@dwSize (SIZE_DDSD shl 2)
    mov D$ddsd@ddsCaps &DDSCAPS_PRIMARYSURFACE
    mov D$ddsd@dwFlags &DDSD_CAPS
    dxCall lpdd,CreateSurface ddsd, lpddsPrimary, &NULL
    dxErrorCheck 'Primary surface creation failed.'
    if D$lpddsPrimary = &NULL, ret

    ; Create second surface
    call ZeroMemory ddsd (SIZE_DDSD shl 2)
    mov D$ddsd@dwSize (SIZE_DDSD shl 2)
    mov D$ddsd@ddsCaps &DDSCAPS_OFFSCREENPLAIN
    mov D$ddsd@dwFlags &DDSD_CAPS+&DDSD_WIDTH+&DDSD_HEIGHT
    mov D$ddsd@dwWidth  WIDTH_VIDEO_BUFFER
    mov D$ddsd@dwHeight HEIGHT_VIDEO_BUFFER
    dxCall lpdd,CreateSurface ddsd, lpddsSecond, &NULL
    dxErrorCheck 'Secondary surface creation failed.'
    if D$lpddsSecond = &NULL, ret

    ; Attach a clipper to D$hMainWindow
    dxCall lpdd,CreateClipper &NULL, lpddclipper, &NULL
    dxErrorCheck 'Could not create clipper.'
    if. D$lpddclipper != &NULL
        dxCall lpddclipper,SetHWnd &NULL, D$hMainWindow
        dxErrorCheck 'Could not set clipping window.'
        dxCall lpddsPrimary,SetClipper D$lpddclipper
        dxErrorCheck 'Could not attach clipper to surface.'
        dxRelease lpddclipper
        dxErrorCheck 'Could not release clipper on initialization.'
    endif

    ; Retrieve color depth
    call ZeroMemory ddsd (SIZE_DDSD shl 2)
    mov D$ddsd@ddpfPixelFormat.dwSize 32
    dxCall lpddsPrimary,GetPixelFormat ddsd@ddpfPixelFormat
    dxErrorCheck 'Could not retrieve pixel format for primary surface.'
    copy D$ddsd@ddpfPixelFormat.dwRGBbitCount D$ColorDepth      ; <-- Very readable name ;-) (34 letters)
    if. D$ColorDepth = 15 | msgError '15-bit color depth not supported' | endif

    ; Arrange 16-bit palette (0.8.8.8 DWORDs  -->  5.6.5 WORDs)
    call TranslatePalette

    ; Clear screen
    call UpdateClientRect
    call ClearVideo
    call FlushVideo
    ret

VideoShutDown:

    ; Release interfaces
    dxRelease lpddsSecond  | dxErrorCheck 'Second surface release failed.'
    dxRelease lpddsPrimary | dxErrorCheck 'Primary surface release failed.'
    dxRelease lpdd         | dxErrorCheck 'IDirectDraw release failed.'
    ret

____________________________________________________________________________________________
; Video output
____________________________________________________________________________________________

VideoOutput: ; Nes palette index in al

    ; Plot pixel
    mov ebx D$VideoCursor | inc D$VideoCursor
    mov B$VideoBuffer+ebx al

    ; Buffer full?
    on D$VideoCursor >= LENGTH_VIDEO_BUFFER, FlushVideo
    ret

FlushVideo:

    mov D$VideoCursor 0
    if D$lpddsSecond = &NULL, ret

    ; Lock secondary surface
    call ZeroMemory ddsd (SIZE_DDSD shl 2) | mov D$ddsd@dwSize SIZE_DDSD+SIZE_DDSD+SIZE_DDSD+SIZE_DDSD
    dxCall lpddsSecond,Lock &NULL, ddsd, &DDLOCK_SURFACEMEMORYPTR+&DDLOCK_WAIT, &NULL
    dxErrorCheck 'Surface lock failed.'

    ; Copy screen data to surface
    mov esi VideoBuffer, edi D$ddsd@lpSurface, edx HEIGHT_VIDEO_BUFFER
L0: mov ecx WIDTH_VIDEO_BUFFER

    push edi

        if. D$ColorDepth = 32 | L1: movzx eax B$esi | inc esi | mov eax D$eax*4+Palette32 | stosd | dec ecx | jnz L1< | else
        if. D$ColorDepth = 24 | L1: movzx eax B$esi | inc esi | mov eax D$eax*4+Palette32 | stosw | shr eax 16 | stosb | dec ecx | jnz L1< | else
        if. D$ColorDepth = 16 | L1: movzx eax B$esi | inc esi | mov  ax W$eax*2+Palette16 | stosw | dec ecx | jnz L1< | else
        if. D$ColorDepth = 15 | L1: movzx eax B$esi | inc esi | mov  ax W$eax*2+Palette15 | stosw | dec ecx | jnz L1< | else
        if. D$ColorDepth = 8  | L1: movzx eax B$esi | inc esi |                           | stosb | dec ecx | jnz L1< | endif

    pop edi

    add edi D$ddsd@lPitch
    dec edx | jnz L0<<

    ; Unlock secondary, blit it to primary
    dxCall lpddsSecond,Unlock &NULL
    call UpdateVideo
    ret

UpdateVideo:

    ; Blit enabled?
    if D$Window@Minimized = &TRUE, ret
    if D$Window@Existing = &FALSE, ret
    if D$lpddsPrimary = &NULL, ret
    if D$lpddsSecond = &NULL, ret

    ; Blit secondary to primary
    dxCall lpddsPrimary,Blt ClientRect, D$lpddsSecond, SourceRect, &DDBLT_ASYNC, &NULL
    dxErrorCheck 'Could not blit NES surface.'
    ret

ClearVideo:

    call ZeroMemory VideoBuffer LENGTH_VIDEO_BUFFER

    push D$VideoCursor

        call FlushVideo

    pop D$VideoCursor
    ret

____________________________________________________________________________________________
; Screenshot
____________________________________________________________________________________________

; Save '.\saves\[ROMName]\snapXXXX.bmp'
[ScreenshotFilename:  B$ 'snap', 0]
[ScreenshotExtension: B$ '.bmp', 0]
SaveScreenShot: call SaveNumberedROMFile ScreenshotFilename, ScreenshotExtension | ret

SaveBMP:

    ; BMP file header
    mov edi SaveData
    call CopyMemory BitmapFileHeader, edi, 14          | add edi 14
    call CopyMemory BitmapInfoHeader, edi, 40          | add edi 40
    call CopyMemory Palette32,        edi, (040 shl 2) | add edi (040 shl 2)

    ; Copy line by line in reversed order
    mov esi VideoBuffer+LENGTH_VIDEO_BUFFER-0900
    mov ecx HEIGHT_VIDEO_BUFFER-17
L0: call CopyMemory esi, edi, WIDTH_VIDEO_BUFFER
    sub esi WIDTH_VIDEO_BUFFER
    add edi WIDTH_VIDEO_BUFFER
    dec ecx | jnz L0<

    ; Set size of saved file
    sub edi SaveData | mov D$SaveSize edi
    ret

____________________________________________________________________________________________
; Fullscreen/windowed mode
____________________________________________________________________________________________

ToggleFullscreen:

    if. B$DisplayMode = DM_WINDOWED
        call SetFullscreen
    else
        call SetWindowed
    endif
    ret

SetFullscreen:

    ; Main window not created yet? (Happens on 'run maximized')
    if D$hMainWindow = &NULL, copy D$hWindow D$hMainWindow

    ; Set fullscreen style
    mov B$DisplayMode DM_FULLSCREEN
    call 'User32.CheckMenuItem' D$hMenu, IDM_FULLSCREEN, &MF_BYCOMMAND+&MF_CHECKED
    call 'User32.SetWindowLongA' D$hMainWindow, &GWL_STYLE, FULLSCREEN_STYLE
    winErrorCheck 'Failed to set fullscreen style.'

    ; Resize window to screen borders, put it on top
    push &NULL
    call 'User32.GetSystemMetrics' &SM_CYSCREEN | push eax
    call 'User32.GetSystemMetrics' &SM_CXSCREEN | push eax
    call 'User32.SetWindowPos' D$hMainWindow, &HWND_TOPMOST, 0, 0 ; width, height, flags

    ; Hide cursor?
    call UpdateCursor
    ret

SetWindowed:

    ; Main window not created yet?
    if D$hMainWindow = &NULL, copy D$hWindow D$hMainWindow

    ; Set windowed style
    mov B$DisplayMode DM_WINDOWED
    call 'User32.CheckMenuItem' D$hMenu, IDM_FULLSCREEN, &MF_BYCOMMAND+&MF_UNCHECKED
    call 'User32.SetWindowLongA' D$hMainWindow, &GWL_STYLE, WINDOW_STYLE
    winErrorCheck 'Failed to set windowed style.'

    ; Resize window to saved size
    mov eax D$WindowRect+8  | sub eax D$WindowRect+0
    mov edx D$WindowRect+12 | sub edx D$WindowRect+4
    call 'User32.SetWindowPos' D$hMainWindow, &HWND_NOTOPMOST, D$WindowRect, D$WindowRect+4, eax, edx, &NULL

    ; Show cursor
    call UpdateCursor
    ret

____________________________________________________________________________________________
; Palette
____________________________________________________________________________________________

; Save '.\saves\[ROMName]\palette.pal'
[PaletteFilename: B$ 'palette.pal',  0]
SavePalette: call SaveROMFile PaletteFilename | ret

SavePAL:

    ; Copy from 32-bit palette
    mov esi Palette32, edi SaveData, ecx 040
L0: lodsd
    mov dx ax
    shr eax 16 | stosb
    mov al dh  | stosb
    mov al dl  | stosb
    dec ecx | jnz L0<

    ; Set size to 192 bytes
    mov D$SaveSize 0C0
    ret

LoadPAL:

    ; Either 256 RGB values (stupid) or 64 (like the NES)
    if D$FileSize != 0300,
        if D$FileSize != 0C0, ret

    ; RRRRRRRR GGGGGGGG BBBBBBBB --> 00000000 RRRRRRRR GGGGGGGG BBBBBBBB
    mov esi D$pFile, edi Palette32, ecx 040
L0: mov eax 0
    lodsb | shl eax 8
    lodsb | shl eax 8
    lodsb | stosd
    dec ecx | jnz L0<

    ; Translate to other color depths
    call TranslatePalette
    ret
____________________________________________________________________________________________

TranslatePalette:

    ; Translate to 16-bit palette
    if. D$ColorDepth = 16
        ; 00000000 RRRRRRRR GGGGGGGG BBBBBBBB --> RRRRRGGG GGGBBBBB
        mov esi Palette32, edi Palette16
    L0: lodsb | movzx edx al
        lodsb | movzx ecx al
        lodsb | movzx ebx al
        lodsb
        shr ebx 3
        shr ecx 2
        shr edx 3
        and bl 01F | shl ebx 11
        and cl 03F | shl ecx 5
        and dl 01F

        mov eax ebx
        or  eax ecx
        or  eax edx

        stosw
        on edi < Palette16+080, L0<<
    endif

    ; Translate to 16-bit palette
    if. D$ColorDepth = 15
        ; 00000000 RRRRRRRR GGGGGGGG BBBBBBBB --> xRRRRRGG GGGBBBBB
        mov esi Palette32, edi Palette15
    L0: lodsb | movzx edx al
        lodsb | movzx ecx al
        lodsb | movzx ebx al
        lodsb
        shr ebx 3
        shr ecx 3
        shr edx 3
        and bl 01F | shl ebx 10
        and cl 01F | shl ecx 5
        and dl 01F

        mov eax ebx
        or  eax ecx
        or  eax edx

        stosw
        on edi < Palette15+080, L0<<
    endif

    ; Translate to 8-bit palette
    if. D$ColorDepth = 8

        ; 00000000 RRRRRRRR GGGGGGGG BBBBBBBB --> ???????????????
        mov esi Palette32, edi Palette8, ecx 040
    L0: movsd ; Some translation process is supposed to take place here... ?
        dec ecx | jnz L0<

        ; Create a new palette and attach it to primary surface
        if D$lpdd = &NULL, break
        dxCall lpdd,CreatePalette &DDPCAPS_8BIT+&DDPCAPS_INITIALIZE+&DDPCAPS_ALLOW256, Palette8, lpddpal, &NULL
        dxErrorCheck 'Could not create palette'
        if D$lpddpal = &NULL, break
        if D$lpddsPrimary = &NULL, break
        dxCall lpddsPrimary,SetPalette D$lpddpal
        dxErrorCheck 'Could not set palette'
        dxRelease lpddpal

    endif
    ret

____________________________________________________________________________________________
; Update client area coordinates
____________________________________________________________________________________________

UpdateClientRect:

    if D$Window@Minimized = &TRUE, ret

    ; Get new coordinates
    call 'User32.GetClientRect'  D$hMainWindow, ClientRect
    call 'User32.ClientToScreen' D$hMainWindow, ClientRect
    call 'User32.ClientToScreen' D$hMainWindow, ClientRect+8

    ; Do not stretch to screen if fullscreen
    if. D$DisplayMode = DM_FULLSCREEN

        ; New width --> eax
        mov eax D$ClientRect+12
        mov ecx D$ScreenWidth  | mul ecx
        mov ecx D$ScreenHeight | div ecx

        ; Adjust x coordinates
        mov edx D$ClientRect+8 | sub edx eax
        shr edx 1 | add eax edx
        mov D$ClientRect+0 edx
        mov D$ClientRect+8 eax

    endif

    ; Adjust top border if menu is present
    call 'User32.GetMenu' D$hMainWindow
    if. eax != &NULL
        call 'User32.GetSystemMetrics' &SM_CYMENU
        sub D$ClientRect+4 eax
    endif
    ret

____________________________________________________________________________________________
; DirectDraw stuff
____________________________________________________________________________________________

; Interface pointers
[lpdd:          ?
 lpddsPrimary:  ?
 lpddsSecond:   ?
 lpddclipper:   ?
 lpddpal:       ?]

; Input buffer
[VideoCursor:      ?
 VideoBuffer:   B$ ? #LENGTH_VIDEO_BUFFER]
[LENGTH_VIDEO_BUFFER <(HEIGHT_VIDEO_BUFFER shl 8)>]
[WIDTH_VIDEO_BUFFER  256
 HEIGHT_VIDEO_BUFFER 241]

; Output buffer
[ClientRect: ? #4
 ColorDepth: ?]
[SourceRect: 0, NTSC_SCREEN_TOP, 0100, NTSC_SCREEN_BOTTOM]

; Surface description
[SIZE_DDSD 27]
[ddsd:
 @dwSize:                               ?
 @dwFlags:                              ?
 @dwHeight:                             ?
 @dwWidth:                              ?
 @lPitch:                               ?
 @dwBackBufferCount:                    ?
 @dwRefreshRate:                        ?
 @dwAlphaBitDepth:                      ?
 @dwReserved:                           ?
 @lpSurface:                            ?
 @ddckCKDestOverlay:                    ? ?
 @ddckCKDestBlt:                        ? ?
 @ddckCKSrcOverlay:                     ? ?
 @ddckCKSrcBlt:                         ? ?
 @ddpfPixelFormat:
 @ddpfPixelFormat.dwSize:               ?
 @ddpfPixelFormat.dwFlags:              ?
 @ddpfPixelFormat.dwFourCC:             ?
 @ddpfPixelFormat.dwRGBBitCount:        ?
 @ddpfPixelFormat.dwRBitMask:           ?
 @ddpfPixelFormat.dwGBitMask:           ?
 @ddpfPixelFormat.dwBBitMask:           ?
 @ddpfPixelFormat.dwRGBAlphaBitMask:    ?
 @ddsCaps:                              ?]

; NES Palette
[Palette32: D$ ? #040   ; 00000000 RRRRRRRR GGGGGGGG BBBBBBBB
 Palette16: W$ ? #040   ;                   RRRRRGGG GGGBBBBB
 Palette15: W$ ? #040   ;                   xRRRRRGG GGGBBBBB
 Palette8:  D$ ? #0100] ; 00000000 RRRRRRRR GGGGGGGG BBBBBBBB

____________________________________________________________________________________________
; Screenshot data
____________________________________________________________________________________________

[BitmapFileHeader:
 @bfType:           W$ 'BM'
 @bfSize:           D$ 14+40+(040 shl 2)+(LENGTH_VIDEO_BUFFER-(17 shl 8))
 @bfReserved1:      W$ 0
 @bfReserved2:      W$ 0
 @bfOffBits:        D$ 14+40+(040 shl 2)

 BitmapInfoHeader:
 @biSize:           D$ 40
 @biWidth:          D$ WIDTH_VIDEO_BUFFER
 @biHeight:         D$ (HEIGHT_VIDEO_BUFFER-17)
 @biPlanes:         W$ 1
 @biBitCount:       W$ 8
 @biCompression:    D$ &BI_RGB
 @biSizeImage:      D$ 0
 @biXPelsPerMeter:  D$ 0
 @biYPelsPerMeter:  D$ 0
 @biClrUsed:        D$ 040
 @biClrImportant:   D$ 040]

____________________________________________________________________________________________
; DirectDraw vtables
____________________________________________________________________________________________

; IUnknown
[QueryInterface          0
 AddRef                  4
 Release                 8

; IDirectDraw
 Compact                12
 CreateClipper          16
 CreatePalette          20
 CreateSurface          24
 DuplicateSurface       28
 EnumDisplayModes       32
 EnumSurfaces           36
 FlipToGDISurface       40
 GetCaps                44
 GetDisplayMode         48
 GetFourCCCodes         52
 GetGDISurface          56
 GetMonitorFrequency    60
 GetScanLine            64
 GetVerticalBlankStatus 68
 Initialize             72
 RestoreDisplayMode     76
 SetCooperativeLevel    80
 SetDisplayMode         84
 WaitForVerticalBlank   88

; IDirectDrawSurface
 AddAttachedSurface     12
 AddOverlayDirtyRect    16
 Blt                    20
 BltBatch               24
 BltFast                28
 DeleteAttachedSurface  32
 EnumAttachedSurfaces   36
 EnumOverlayZOrders     40
 Flip                   44
 GetAttachedSurface     48
 GetBltStatus           52
 sGetCaps               56
 GetClipper             60
 GetColorKey            64
 GetDC                  68
 GetFlipStatus          72
 GetOverlayPosition     76
 GetPalette             80
 GetPixelFormat         84
 GetSurfaceDesc         88
 sInitialize            92
 IsLost                 96
 Lock                  100
 ReleaseDC             104
 Restore               108
 SetClipper            112
 SetColorKey           116
 SetOverlayPosition    120
 SetPalette            124
 Unlock                128
 UpdateOverlay         132
 UpdateOverlayDisplay  136
 UpdateOverlayZOrder   140

; IDirectDrawClipper
 GetClipList           12
 GetHWnd               16
 cInitialize           20
 IsClipListChanged     24
 SetClipList           28
 SetHWnd               32]
____________________________________________________________________________________________
