____________________________________________________________________________________________
;
;                            TechNES source
;                          2009 TechEmporium
;
;   This program is free software: you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, either version 3 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program.  If not, see http://www.gnu.org/licenses.
;
____________________________________________________________________________________________
TITLE Macros
____________________________________________________________________________________________

; asm
[pop  | pop  #1   | #+1]        ; push eax, edx
[push | push #1   | #+1]        ; pop eax, edx
[mov  | mov #1 #2 | #+2]        ; mov eax 0, ebx 3
[call | push #L>2 | call #1]    ; call 'MessageBoxA' &NULL, MessageTitle, Message, &MB_OK
[copy | push #1   | pop #2]     ; copy D$Source D$Dest
[move | lea #1 D$#2]            ; move eax ecx+ebx*2-4
[enumerate | {#2 (#x-1+#F)} | #+1] ; enumerate 1, ONE, TWO, THREE...
[enumerate4 | {#2 (((#x-1) shl 2)+#F)} | #+1] ; enumerate 0, ZERO, FOUR, EIGHT...

; arguments
[arguments | push ebp | mov ebp esp | getArgument #1>L] ; arguments hWindow, Message, wParam, lParam
[getArgument | {#1 ebp+(#x shl 2)+4} | &9=(#x shl 2) | #+1]
[return | pop ebp | ret &9]

; DirectX
[dxCall ; dxCall lpdd,CreateSurface ddsd, lpdds, &NULL
    mov eax D$#1
    mov eax D$eax
    push #L>3
    call D$eax+#2 D$#1]
[dxRelease ; dxRelease lpdd
 mov eax &DD_OK
 pushad
    if D$#1 != &NULL, dxCall #1,Release
 popad
 mov D$#1 &NULL]

; Flow control
[! n  = e  != ne  >= ae  > a  < b  <= be]
[if |        cmp #1 #3 | jn#2 I9> | #4>L | I9:] ; if D$RunRoutine = &TRUE, call Routine
[on |  #=4 | cmp #1 #3 | j#2 #4]                ; on D$Quit = &TRUE, Quit
[if. | #=3 | cmp #1 #3 | jn#2 I8>>]             ; if. D$RunRoutine = &TRUE
                                                ;     mov D$RunRoutine &FALSE
                                                ;     call Routine
[else   | jmp I4>> | I8:]                       ; else
                                                ;     call SomeOtherRoutine
[break  | jmp I4>>]                             ;     if ecx = 0, break
                                                ;     mov D$RunRoutine eax
[endif  | I4: | I8:]                            ; endif
[end I4>>]

[if..        | #=3 | cmp  #1 #3 | jn#2 J8>>]
[ifFlag..    | #=2 | test #1 #2 | jz   J8>>]
[ifNotFlag.. | #=2 | test #1 #2 | jnz  J8>>]
[else..      | jmp J4>> | J8:]
[break..     | jmp J4>>]
[endif..     | J4: | J8:]
[end..         J4>]

[ifFlag     | test #1 #2 | jz  I7> | #3>L | I7:] ; ifFlag D$FlagRegister FLAG, call FlagRoutine
[ifNotFlag  | test #1 #2 | jnz I6> | #3>L | I6:]
[ifFlag.    | test #1 #2 | jz  I8>>]
[ifNotFlag. | test #1 #2 | jnz I8>>]

[ifKeyDown | pushad | call 'User32.GetAsyncKeyState' #1 | and ax 08000 | popad | jz I5> | #2>L | I5:]
[ifKeyUp   | pushad | call 'User32.GetAsyncKeyState' #1 | and ax 08000 | popad | js I4> | #2>L | I4:]

; Message box
[msg | #=3 | pushad | call 'User32.MessageBoxA' D$hMainWindow &0 #1 &MB_APPLMODAL+#3 | popad]
[msgWarning | msg Warning  {#1, 0} &MB_ICONEXCLAMATION]
[msgInfo    | msg Info     {#1, 0} &MB_ICONINFORMATION]
[msgError   | msg Error    {#1, 0} &MB_ICONERROR]
[Warning: B$ 'Warning!',    0
 Info:    B$ 'Information', 0
 Error:   B$ 'Error!',      0]

; Misc
[. | call #3>L | mov #1 eax] ; . D$hMem = 'GlobalAlloc' &GPTR, 01000
[Temp: ?]
____________________________________________________________________________________________
; Useful routines
____________________________________________________________________________________________

ZeroMemory:

    arguments @pDest, @Length
    pushad
        mov edi D@pDest, eax 0, ecx D@Length
        rep stosb
    popad
    return

CopyMemory:

    arguments @pSource, @pDest, @Length
    pushad
        mov esi D@pSource, edi D@pDest, ecx D@Length
        rep movsb
    popad
    return

AddString:

    arguments @pFirst @pSecond

    pushad

        ; Length of second
        mov ecx 0-1, al 0, edi D@pSecond
        repne scasb
        push ecx

            ; End of first
            mov edi D@pFirst
            repne scasb | dec edi

        ; Copy
        pop ecx | not ecx
        mov esi D@pSecond
        repne movsb

    popad
    return

CRC32: ; call CRC32 D$Pointer, D$Length  -->  CRC in eax

    [CRC32_POLY 0EDB8_8320]
    ; Completely unreadable code
    pop eax, esi, ecx | push eax
    mov eax 0FFFF_FFFF
    jecxz L9>
    mov edx 0
L1: xor al, B$esi | inc esi
L2: shr eax, 1 | jnc L3> | xor eax, CRC32_POLY | L3:
    add dl 020 | jnz L2<
    dec ecx | jnz L1<
L9: not eax
    ret
____________________________________________________________________________________________
