TITLE Simple
____________________________________________________________________________________________
; Mapper #000, NROM
____________________________________________________________________________________________

Mapper000: | ret

; ____________________________________________________________________________________________
;
;                            PROM switching mappers
;
; ____________________________________________________________________________________________

____________________________________________________________________________________________
; Mapper #188, Bandai Karaoke Studio

; $8000-$FFFF: xxxSxPPP - swap 16k PROM at $8000
;                       - Use first/second 128k PROM segment (1/0)
____________________________________________________________________________________________

Mapper188:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    CPURead  06000, 07FFF, @ReadWROM

    ; Load last bank of first segment
    swap PROM, 16k, 0C000, 7
    ret

@8000_FFFF:

    ; xxxxxxxx = 0?
    if. eax = 0
        swap PROM, 16k, 08000, 7
        if D$Cartridge@SizePROM > 128, swap PROM, 16k, 08000, 8
        ret
    endif

    ; xxxSxPPP
    ifNotFlag. eax 010
        and eax 07
        or eax  08
    else
        and eax 07
    endif

    ; Swap bank
    swap PROM, 16k, 08000, eax
    ret

@ReadWROM: mov eax 3 | ret

____________________________________________________________________________________________
; Mapper #241, Fon Serm Bon

; $8000: - PPPPPPPP - swap 32k PROM at $8000
____________________________________________________________________________________________

Mapper241:

    ; Memory mapping
    CPUWrite 08000, 08000, @8000
    CPUWrite 05FF0, 05FF0, @5FF0
    ret

; ????????
@5FF0:ret

@8000:

    ; PPPPPPPP
    swap PROM, 32k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #002, UNROM

; $8000-$FFFF: xxxxPPPP - swap 16k PROM at $8000
____________________________________________________________________________________________

Mapper002:

    ; Set ports
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Swap last 16k PROM bank to $C000
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000_FFFF:

    ; xxxxPPPP
    swap PROM, 16k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #093, Sunsoft (Fantasy Zone)

; $6000: PPPPPPPP - swap 16k PROM at $8000
____________________________________________________________________________________________

Mapper093:

    ; Memory mapping
    CPUWrite 06000, 06000, @6000

    ; Swap last PROM bank to $C000
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@6000:

    ; PPPPPPPP
    swap PROM, 16k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #094, Capcom 74HC161/32

; $8000-$FFFF: xxxPPPxx - swap 16k PROM at $8000
____________________________________________________________________________________________

Mapper094:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Swap in last PROM bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000_FFFF:

    ; xxxPPPxx
    shr eax 2
    swap PROM, 16k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #180, Nichibutsu

; $8000-$FFFF: xxxxxPPP - swap 16k PROM at $C000
____________________________________________________________________________________________

Mapper180:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxxxxPPP
    and eax 7
    swap PROM, 16k, 0C000, eax
    ret

____________________________________________________________________________________________
; Mapper #232, Camerica/Codemasters Quattro Games

; $6000-$9FFF: xxxPPxxx - select 64k PROM segment
; $A000-$FFFF: xxxxxxPP - select 16k PROM (in selected segment) at $8000

; - swap selected bank of 64k segment at $8000
; - swap last     bank of 64k segment at $C000
____________________________________________________________________________________________

Mapper232:

    ; Memory mapping
    CPUWrite 08000, 0BFFF, @8000_BFFF
    CPUWrite 0C000, 0FFFF, @C000_FFFF

    ; Select last 64k segment
    mov D$Bank 0C
    call @SetBanks
    ret

; Two MSB of PROM select
@8000_BFFF:

    ; Hack: Swap bits on (Aladdin) games
    on D$Cartridge@PROMCRC32 = 0A045_FE1D, F0> ; Super Sports Challenge (Aladdin) (E)
    on D$Cartridge@PROMCRC32 = 06C04_0686, F0> ; Quattro Adventure (Aladdin) (U)
    on D$Cartridge@PROMCRC32 = 062EF_6C79, F0> ; Quattro Sports (Aladdin) (U)
    jmp S0>
F0: if. eax = 08  | mov eax 010 | else
    if. eax = 010 | mov eax 08  | endif

    ; xxxPPxxx
S0: shr eax 1
    and eax 0C
    and D$Bank 03
    or  D$Bank eax
    jmp @SetBanks

; Two LSB of PROM select
@C000_FFFF:
    ; xxxxxxPP
    and eax 03
    and D$Bank 0C
    or  D$Bank eax
    jmp @SetBanks

@SetBanks:

    ; Selected bank --> $8000
    ; Last     bank --> $C000
    mov eax D$Bank
    swap PROM, 16k, 08000, eax | or eax 3
    swap PROM, 16k, 0C000, eax
    ret

; ____________________________________________________________________________________________
;
;                            CROM switching mappers
;
; ____________________________________________________________________________________________

____________________________________________________________________________________________
; Mapper #101, Jaleco 74HC161/32

; $8000-$FFFF: xxxxxxCC - swap 8k CROM at $0000
____________________________________________________________________________________________

Mapper101:

    ; Memory mapping
    CPUWrite 06000, 0FFFF, @6000_FFFF
    ret

@6000_FFFF:

    ; xxxxxxCC
    swap CROM, 8k,  00000, eax
    ret

____________________________________________________________________________________________
; Mapper #003, CNROM

; $8000-$FFFF: xxxxCCCC - swap 8k CROM at $0000
____________________________________________________________________________________________

Mapper003:

    ; Set ports
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxxxCCCC
    swap CROM, 8k, 00000, eax
    ret

____________________________________________________________________________________________
; Mapper #087, Konami 74HC161/32

; $6000-$FFFF: CCCCCCCx - swap 8k CROM at $0000
____________________________________________________________________________________________

Mapper087:

    ; Memory mapping
    CPUWrite 06000, 0FFFF, @6000_FFFF
    ret

@6000_FFFF:

    ; CCCCCCCx
    shr eax 1
    swap CROM, 8k, 00000, eax
    ret

____________________________________________________________________________________________
; Mapper #184

; $6000-$FFFF: ccccCCCC - swap 4k CROM at $0000
;                       - swap 4k cROM at $1000
____________________________________________________________________________________________

Mapper184:

    ; Memory mapping
    CPUWrite 06000, 0FFFF, @6000_FFFF
    ret

@6000_FFFF:

    ; ccccCCCC
    swap CROM, 4k, 00000, eax | shr eax 4
    swap CROM, 4k, 01000, eax
    ret

; ____________________________________________________________________________________________
;
;                        PROM/mirror switching mappers
;
; ____________________________________________________________________________________________

____________________________________________________________________________________________
; Mapper #235, 150-in-1

; $8000-$FFFF: (address) 1-MpSmPP ---PPPPP - (m = 1) mirror one screen
;                                          - mirror VERTICAL/HORIZONTAL (M = 0/1)
;                                          - (S = 1) swap 16k PROM at $8000 and $C000 (PPPPPPPp)
;                                          - (S = 0) swap 32k PROM at $8000 (PPPPPPP)
____________________________________________________________________________________________

Mapper235:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    CPURead  08000, 0FFFF, @ReadPROM
    ret

@8000_FFFF:

    ; -M---m-- --------
    ifFlag. edx 0400  | mirror ONE_SCREEN_2000 | else
    ifFlag. edx 02000 | mirror HORIZONTAL      | else
                        mirror VERTICAL        | endif

    ; ------PP ---PPPPP
    mov eax edx | and eax 01F
    mov ecx edx | and ecx 0300

    if. D$Cartridge@SizePROM = 2048
        test ecx 0100 | setnz B$Register
        if ecx = 0200, shr ecx 1
    endif
    shr ecx 3 | or eax ecx

    ; ---pS--- --------
    ifFlag. edx 0800
        shl eax 1
        ifFlag edx 01000, or eax 01
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    else
        swap PROM, 32k, 08000, eax
    endif
    ret

@ReadPROM:

    on B$Register = &FALSE, ReadPROM
    jmp ReadVoid
____________________________________________________________________________________________
; Mapper #051, Ball Games 11-in-1

; $6000-$7FFF: xxxBxxAx - mode = BA
;                       - mirror VERTICAL/HORIZONTAL (mode = 0,1,2 / mode = 3)
; $8000-$FFFF: xxxxPpPP - (mode = 1,3) swap 32k PROM at $8000 (PpPP)
;                       - (mode = 1,3) swap 8k  PROM at $6000 (1pPP11)
;                       - (mode = 0,2) swap 16k PROM at $8000 (PpPPB)
;                       - (mode = 0,2) swap 16k PROM at $C000 (Pp111)
;                       - (mode = 0,2) swap 8k  PROM at $6000 (1p1111)
; $C000-$DFFF: xxxBxxxx - mode = BA
;                       - mirror VERTICAL/HORIZONTAL (mode = 0,1,2 / mode = 3)
____________________________________________________________________________________________

Mapper051:

    ; Memory mapping
    CPUWrite 06000, 07FFF, @6000_7FFF
    CPURead  06000, 07FFF, @ReadExPROM
    CPUWrite 08000, 0FFFF, @8000_FFFF
    CPUWrite 0C000, 0DFFF, @C000_DFFF

    ; Force CRAM
    mov D$Cartridge@SizeCROM 0
    mov D$Cartridge@SizeCRAM 8
    swap CRAM 8k, 0000, 0

    ; Registers
    mov B$Mode 01
    call @UpdateBanks
    ret

@ReadExPROM:

    sub eax 06000
    add eax D$Offset
    add eax D$pPROM
    movzx eax B$eax
    ret

@6000_7FFF:

    ; xxxBxxAx
    mov B$Mode 0
    ifFlag eax 02, or B$Mode 01
    ifFlag eax 010, or B$Mode 02
    call @UpdateBanks
    ret

@C000_DFFF:

    ; xxxBxxxx
    and B$Mode 01
    ifFlag eax 010, or D$Mode 02

    ; xxxxPPPP
    and eax 0F
    mov D$Bank eax
    call @UpdateBanks
    ret

@8000_FFFF:

    ; xxxxPPPP
    and eax 0F
    mov D$Bank eax
    call @UpdateBanks
    ret

@UpdateBanks:

    ; Mirroring
    if. D$Mode = 3
        mirror HORIZONTAL
    else
        mirror VERTICAL
    endif

    ifFlag. D$Mode 01

        ; Swap PROM
        swap PROM, 32k, 08000, D$Bank

        ; Find bank at $6000-$7FFF
        mov eax D$Bank
        shl eax 2 | or eax 023

        ; mul 8k
        shl eax 13
        mov D$Offset eax

    else

        ; Swap PROM
        mov eax D$Bank
        shl eax 1
        ifFlag D$Mode 02, or eax 01
        swap PROM, 16k, 08000, eax | or eax 7
        swap PROM, 16k, 0C000, eax

        ; Find bank at $6000-$7FFF
        mov eax D$Bank
        shl eax 2 | or eax 02F

        ; mul 8k
        shl eax 13
        mov D$Offset eax

    endif
    ret

____________________________________________________________________________________________
; Mapper #230, 20-in-1 (Contra)

; $8000-$FFFF: xMSPPPPp - mirror HORIZONTAL/VERTICAL (0/1)
;                       - (S = 0) swap 32k PROM at $8000
;                       - (S = 1) swap 16k PROM at $8000 and $C000
____________________________________________________________________________________________

[Contra Game]

Mapper230:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Toggle ROM switch
    xor B$Contra &TRUE

    ; Load PROM
    if. B$Contra = &TRUE
        swap PROM, 16k, 0C000, 7
    else
        swap PROM, 16k, 08000, 8
        swap PROM, 16k, 0C000, 8+LAST_BANK
    endif
    ret

@8000_FFFF:

    ; Contra?
    if. B$Contra = &TRUE

        ; xxxxxPPp
        and eax 7
        swap PROM, 16k, 08000, eax
        ret

    endif

    ; xMxxxxxx
    ifFlag. eax 040
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxSPPPPp
    ifNotFlag. eax 020
        and eax 01F
        add eax 8 ; Get past first 128k
        shr eax 1
        swap PROM, 32k, 08000, eax
    else
        and eax 01F
        add eax 8 ; Get past first 128k
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    endif
    ret

____________________________________________________________________________________________
; Mapper #227, 1200-in-1

; $8000-$FFFF: (address): xxxxxxAH_OPPPPpMS - mirror VERTICAL/HORIZONTAL (0/1)
;                                           - (S = 0) swap 16k PROM at $8000 and $C000 (HPPPPp)
;                                           - (S = 1) swap 32k PROM at $8000 (HPPPP)
;                                           - (O = 0) swap 16k PROM at $C000 (HPPAAA)
____________________________________________________________________________________________

Mapper227:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Load first bank
    swap PROM, 16k, 0C000, 0
    ret

@8000_FFFF:

    ; xxxxxxxx_xxxxxxxx
    ifNotFlag. edx 02
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxxxxxH_xPPPPpxx
    mov eax edx
    shr eax 2
    and eax 01F
    ifFlag edx 0100, or eax 020

    ; xxxxxxxx_xxxxxxxS
    ifFlag. edx 01
        shr eax 1
        swap PROM, 32k, 08000, eax
    else
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
        shr eax 1
    endif

    ; xxxxxxAx_Oxxxxxxx
    ifNotFlag. edx 080
        and eax 01C
        shl eax 1
        ifFlag edx 0200, or eax 7
        swap PROM, 16k, 0C000, eax
    endif
    ret

____________________________________________________________________________________________
; Mapper #061, 20-in-1

; $8000-$FFFF: (LSB of address): MxABPPPP - mirror VERTICAL/HORIZONTAL (0/1)
;                                         - (A =  B) swap 32k PROM at $8000 (PPPP)
;                                         - (A != B) swap 16k PROM at $8000 and $C000 (PPPPA)
____________________________________________________________________________________________

Mapper061:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Load last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000_FFFF:

    ; Mxxxxxxx
    ifNotFlag. edx 080
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxABxxxx
    mov eax edx
    and edx 030

    ; xxABPPPP
    if edx = 000, swap PROM, 32k, 08000, eax
    if edx = 030, swap PROM, 32k, 08000, eax

    shl eax 1
    if. edx = 010
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    endif

    or eax 2
    if. edx = 020
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    endif

    ret

____________________________________________________________________________________________
; Mapper #226, 76-in-1

; $8000-$FFFF: (LSB of address): xxxxxxxR
;     (R = 0) (data): PMSPPPPP (5xx43210) - mirror HORIZONTAL/VERTICAL (0/1)
;     (R = 1) (data): xxxxxxxP (xxxxxxx6) - (S = 0) Use bits 654321  to swap 32k PROM at $8000
;                                         - (S = 1) Use bits 6543210 to swap 16k PROM at $8000 and $C000
____________________________________________________________________________________________

Mapper226:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxxxxxxR
    and edx 1 | mov B$Register+edx al

    ; xMxxxxxx
    ifNotFlag. B$Register+0 040
        mirror HORIZONTAL
    else
        mirror VERTICAL
    endif

    ; Assemble bits
    mov eax D$Register | mov edx eax
    and eax 01F
    and edx 0180 | shr edx 2
    or eax edx
    ifFlag. B$Register+0 020
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    else
        shr eax 1
        swap PROM, 32k, 08000, eax
    endif
    ret

____________________________________________________________________________________________
; Mapper #233, Super 42-in-1

; $8000-$FFFF: MMSPPPPP: - (S = 1) swap 16k PROM at $8000 and $C000
;                        - (S = 0) Use 4 MSB of PROM select and swap 32k PROM at $8000
;                        - mirror 0-0-0-1/VERTICAL/HORIZONTAL/$2400 (0/1/2/3)
____________________________________________________________________________________________

Mapper233:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; MMxxxxxx
    mov edx eax | shr edx 6 | and edx 3
    if dl = 0, mirror MIRRORING_0001
    if dl = 1, mirror VERTICAL
    if dl = 2, mirror HORIZONTAL
    if dl = 3, mirror ONE_SCREEN_2400

    ; xxSPPPPP
    ifFlag. eax 020
        and eax 01F
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    else
        and eax 01F
        shr eax 1
        swap PROM, 32k, 08000, eax
    endif
    ret

____________________________________________________________________________________________
; Mapper #231, 20-in-1

; $8000-$FFFF:
; (LSB of address) MxSPPPPx - swap 32k PROM at $8000
;                           - (S = 0) mirror $C000-$FFFF from $8000-$BFFF (16k games)
;                           - mirror VERTICAL/HORIZONTAL (0/1)
____________________________________________________________________________________________

Mapper231:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; Mxxxxxxx
    ifNotFlag. edx 080
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxSPPPPx
    and edx 03E
    swap PROM, 16k, 08000, edx
    ifFlag edx 020, inc edx
    swap PROM, 16k, 0C000, edx
    ret

____________________________________________________________________________________________
; Mapper #7, AOROM

; $8000-$FFFF: xxxMPPPP - swap 32k PROM at $8000
;                       - mirror $2000/$2400 (0/1)
____________________________________________________________________________________________

Mapper007:

    ; Set ports
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxxxPPPP
    swap PROM, 32k, 08000, eax

    ; xxxMxxxx
    ifNotFlag. al 010
        mirror ONE_SCREEN_2000
    else
        mirror ONE_SCREEN_2400
    endif

    ; Mirroring hack
    on D$Cartridge@PROMCRC32 = 04C7C_1AF3, F0> ; Caesar's Palace (U) [o1]
    on D$Cartridge@PROMCRC32 = 03C9F_E649, F0> ; WWF Wrestlemania Challenge (U) [hM07]
    ret

    ; Two-screen mirroring
F0: ifNotFlag. al 010
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif
    ret

____________________________________________________________________________________________
; Mapper #071, Camerica

; $9000-$9FFF: xxxMxxxx - mirror $2000/$2400 (0/1)
; $C000-$FFFF: PPPPPPPP - swap 16k PROM at $8000
____________________________________________________________________________________________

Mapper071:

    ; Set ports
    CPUWrite 09000, 09FFF, @9000_9FFF
    CPUWrite 0C000, 0FFFF, @C000_FFFF

    ; Swap last 16k PROM bank at $C000
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@9000_9FFF:

    ; xxxMxxxx
    ifFlag. al 010
        mirror ONE_SCREEN_2400
    else
        mirror ONE_SCREEN_2000
    endif
    ret

@C000_FFFF:

    ; PPPPPPPP
    swap PROM, 16k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #097, Irem 74161

; $8000-$BFFF: MxxxPPPP - swap 16k PROM at $C000
;                       - mirror HORIZONTAL/VERTICAL (0/1)
;;
;;;;
FCE Ultra 0.96 code:
switch(V>>6)
{
    case 0:break;
    case 1:MIRROR_SET2(0);break;
    case 2:MIRROR_SET2(1);break;
    case 3:break;
}
;;
____________________________________________________________________________________________

Mapper097:

    ; Memory mapping
    CPUWrite 08000, 0BFFF, @8000_BFFF

    ; Last bank --> $8000, First bank --> $C000
    swap PROM, 16k, 08000, LAST_BANK
    swap PROM, 16k, 0C000, 0
    ret

@8000_BFFF:

    ; MxxxPPPP
    swap PROM, 16k, 0C000, eax
    ifFlag. al 080
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif
    ret

____________________________________________________________________________________________
; Mapper #242, Wai Xing Zhan Shi

; $8000-$FFFF: xPPPPxMM - swap 32k PROM at $8000
;                       - mirror: VERTICAL/HORIZONTAL/$2000/$2400 (0/1/2/3)
____________________________________________________________________________________________

Mapper242:

    ; Set ports
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; PROM switch
    shr edx 3
    swap PROM, 32k, 08000, edx

    ; Mirror switch
    and al 3
    if al = 0, mirror VERTICAL
    if al = 1, mirror HORIZONTAL
    if al = 2, mirror ONE_SCREEN_2000
    if al = 3, mirror ONE_SCREEN_2400
    ret

; ____________________________________________________________________________________________
;
;                       PROM/CROM switching mappers
;
; ____________________________________________________________________________________________

____________________________________________________________________________________________
; Mapper #160, PC-Aladdin

; $8000: PPPPPPPP - swap 8k PROM at $8000
; $8001: PPPPPPPP - swap 8k PROM at $A000
; $8002: PPPPPPPP - swap 8k PROM at $C000
; $9000: CCCCCCCC - (mode = 1) swap 1k CROM at $0000
; $9001: CCCCCCCC - (mode = 1) swap 1k CROM at $0400
;                 - (mode = 4) swap 4k CROM at $0000 and $1000 (Use CCCCCCCx)
; $9002: CCCCCCCC - (mode = 1) swap 1k CROM at $0800
; $9003: CCCCCCCC - (mode = 1) swap 1k CROM at $0C00
; $9004: CCCCCCCC - (mode = 1) swap 1k CROM at $1000
; $9005: CCCCCCCC - (mode = 1) swap 1k CROM at $1400
; $9006: CCCCCCCC - (mode = 1) swap 1k CROM at $1800
; $9007: CCCCCCCC - (mode = 1) swap 1k CROM at $1C00
; $D000-$FFFF: MMMMMMMM - mode
____________________________________________________________________________________________

;$C00x???
Mapper160:

    ; Memory mapping
    CPUWrite 08000, 08000, @8000
    CPUWrite 08001, 08001, @8001
    CPUWrite 08002, 08002, @8002
    CPUWrite 09000, 09000, @9000
    CPUWrite 09001, 09001, @9001
    CPUWrite 09002, 09002, @9002
    CPUWrite 09003, 09003, @9003
    CPUWrite 09004, 09004, @9004
    CPUWrite 09005, 09005, @9005
    CPUWrite 09006, 09006, @9006
    CPUWrite 09007, 09007, @9007
    CPUWrite 0D000, 0FFFF, @D000_FFFF

    ; Load last bank
    swap PROM, 16k, 0C000, LAST_BANK

    mov D$Mode 0
    ret

; PPPPPPPP
@8000: swap PROM, 8k, 08000, eax | ret
@8001: swap PROM, 8k, 0A000, eax | ret
@8002: swap PROM, 8k, 0C000, eax | ret

; CCCCCCCC
@9000: if D$Mode = 1, swap CROM, 1k,  0000, eax | ret
@9002: if D$Mode = 1, swap CROM, 1k,  0800, eax | ret
@9003: if D$Mode = 1, swap CROM, 1k,  0C00, eax | ret
@9004: if D$Mode = 1, swap CROM, 1k, 01000, eax | ret
@9005: if D$Mode = 1, swap CROM, 1k, 01400, eax | ret
@9006: if D$Mode = 1, swap CROM, 1k, 01800, eax | ret
@9007: if D$Mode = 1, swap CROM, 1k, 01C00, eax | ret

@9001:

    ; CCCCCCCC
    if D$Mode = 1, swap CROM, 1k,  0400, eax

    ; CCCCCCCx
    if. D$Mode = 4
        shr eax 1
        swap CROM, 4k, 00000, eax
        swap CROM, 4k, 01000, eax
    endif
    ret

@D000_FFFF:

    ; Mode
    mov D$Mode eax
    ret

____________________________________________________________________________________________
; Mapper #046, Rumble Station 15-in-1

; $6000-$7FFF: CCCCPPPP (6543xxxx/xxxx4321)
; $8000-$FFFF: xCCCxxxP (x210xxxx/xxxxxxx0)
;                       - swap 8k  CROM at $0000 (6543210)
;                       - swap 32k PROM at $8000 (43210)
____________________________________________________________________________________________

Mapper046:

    ; Set ports
    CPUWrite 06000, 07FFF, @6000_7FFF
    CPUWrite 08000, 0FFFF, @8000_FFFF

    mirror VERTICAL
    ret

@6000_7FFF:

    ; xxxxPPPP
    shr D$PROMBank 1
    mov D$PROMBank eax
    rcl D$PROMBank 1

    ; CCCCxxxx
    and eax 0F0 | shr eax 1
    and D$CROMBank 07
    or  D$CROMBank eax

    ; Swap banks
    swap PROM, 32k, 08000, D$PROMBank
    swap CROM, 8k,  00000, D$CROMBank
    ret

@8000_FFFF:

    ; xxxxxxxP
    ifFlag. eax 01
        or D$PROMBank 01
    else
        and D$PROMBank 01E
    endif

    ; xCCCxxxx
    shr eax 4 | and eax 7
    and D$CROMBank 078
    or D$CROMBank eax

    ; Swap banks
    swap PROM, 32k, 08000, D$PROMBank
    swap CROM, 8k,  00000, D$CROMBank
    ret

____________________________________________________________________________________________
; Mapper #246, Fong Shen Bang - Zhu Lu Zhi Zhan

; $6000: PPPPPPPP - swap 8k PROM at $8000
; $6001: PPPPPPPP - swap 8k PROM at $A000
; $6002: PPPPPPPP - swap 8k PROM at $C000
; $6003: PPPPPPPP - swap 8k PROM at $E000
; $6004: CCCCCCCC - swap 2k CROM at $0000
; $6005: CCCCCCCC - swap 2k CROM at $0800
; $6006: CCCCCCCC - swap 2k CROM at $1000
; $6007: CCCCCCCC - swap 2k CROM at $1800

; $6800-$6FFF: ???????? - (???)
; $8AD9:       ???????? - writes $01 here on startup (???)
____________________________________________________________________________________________

Mapper246:

    ; Set ports
    mov ecx 06000
L0: push ecx
        mov eax WriteVoid
        and ecx 0F007
        if ecx = 06000, mov eax @6000
        if ecx = 06001, mov eax @6001
        if ecx = 06002, mov eax @6002
        if ecx = 06003, mov eax @6003
        if ecx = 06004, mov eax @6004
        if ecx = 06005, mov eax @6005
        if ecx = 06006, mov eax @6006
        if ecx = 06007, mov eax @6007
    pop ecx

    CPUWrite ecx, ecx, eax
    inc cx
    on ecx < 06800, L0<<
    ret

@6000: swap PROM, 8k, 08000, eax | ret
@6001: swap PROM, 8k, 0A000, eax | ret
@6002: swap PROM, 8k, 0C000, eax | ret
@6003: swap PROM, 8k, 0E000, eax | ret
@6004: swap CROM, 2k, 00000, eax | ret
@6005: swap CROM, 2k,  0800, eax | ret
@6006: swap CROM, 2k, 01000, eax | ret
@6007: swap CROM, 2k, 01800, eax | ret

____________________________________________________________________________________________
; Mapper #086, Jaleco early mapper #2

; $6000: xCPPxxCC (x2xxxx10) - swap 32k PROM at $8000
;                            - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper086:

    ; Memory mapping
    CPUWrite 06000, 06000, @6000
    ret

@6000:

    ; xCxxxxCC
    mov edx eax | and edx 3
    ifFlag eax 040, or edx 04
    swap CROM, 8k, 00000, edx

    ; xxPPxxxx
    shr eax 4
    swap PROM, 32k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #066, GNROM

; $6000-$FFFF: PPPPCCCC - swap 32k PROM at $8000
;                       - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper066:

    ; Set ports
    CPUWrite 06000, 0FFFF, @6000_FFFF
    ret

@6000_FFFF:

    ; PPPPCCCC
    swap CROM, 8k,  00000, eax | shr eax 4
    swap PROM, 32k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #011, Color Dreams

; $8000-$FFFF: CCCCPPPP - swap 32k PROM at $8000
;                       - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper011:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; CCCCPPPP
    swap PROM, 32k, 08000, eax | shr eax 4
    swap CROM, 8k,  00000, eax
    ret

____________________________________________________________________________________________
; Mapper #144

; $8001-$FFFF: CCCCPPPP - swap 32k PROM at $8000
;                       - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper144:

    ; Almost exactly like Color Dreams...
    call Mapper011

    ; ...except for $8000
    CPUWrite 08000, 08000, WriteVoid
    ret

____________________________________________________________________________________________
; Mapper #008, FFE F8xxx

; $8000-$FFFF: PPPPPCCC - swap 8k  CROM at $0000
;                       - swap 16k PROM at $8000
____________________________________________________________________________________________

Mapper008:

    ; Set ports
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; PPPPPCCC
    swap CROM, 8k,  00000, eax | shr eax 3
    swap PROM, 16k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #034, Nina-1

; $7FFD:       PPPPPPPP - swap 32k PROM at $8000
; $7FFE:       CCCCCCCC - swap 4k  CROM at $0000
; $7FFF:       CCCCCCCC - swap 4k  CROM at $1000
; $8000-$FFFF: PPPPPPPP - swap 32k PROM at $8000
____________________________________________________________________________________________

Mapper034:

    ; Memory mapping
    CPUWrite 07FFD, 07FFD, @7FFD
    CPUWrite 07FFE, 07FFE, @7FFE
    CPUWrite 07FFF, 07FFF, @7FFF
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Swap last 16k PROM bank to $C000
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@7FFD:
@8000_FFFF:

    ; PPPPPPPP
    swap PROM, 32k, 08000, eax
    ret

@7FFE:

    ; CCCCCCCC
    swap CROM, 4k,  00000, eax
    ret

@7FFF:

    ; CCCCCCCC
    swap CROM, 4k,  01000, eax
    ret

____________________________________________________________________________________________
; Mapper #072, Jaleco type 1 - low bankswitch

; $8000-$FFFF: PCxxBBBB - (P = 1) swap 16k PROM at $8000 from bank BBBB
;                       - (C = 1) swap 8k  CROM at $0000 from bank BBBB
____________________________________________________________________________________________

Mapper072:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Swap last bank at $C000
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000_FFFF:

    ; PCxxBBBB
    ifFlag eax 080, swap PROM, 16k, 08000, eax
    ifFlag eax 040, swap CROM, 8k,  00000, eax
    ret

____________________________________________________________________________________________
; Mapper #092, Jaleco type 1 - high bankswitch

; $8x70-$8x7F: (LSB of address): 0111CCCC - swap 8k  CROM at $0000
; $8xB0-$8xBF: (LSB of address): 1011PPPP - swap 16k PROM at $C000
; $9xD0-$FxDF: (LSB of address): 1101PPPP - swap 16k PROM at $C000
; $9xE0-$FxEF: (LSB of address): 1110CCCC - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper092:

    ; Set ports
    CPUWrite 08000, 08FFF, @8000_8FFF
    CPUWrite 09000, 0FFFF, @9000_FFFF

    ; Swap in last 16k PROM bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000_8FFF:

    ; XXXXxxxx
    mov eax edx | and eax 0F0
    on eax = 00_0111_0000, @SwitchCROM
    on eax = 00_1011_0000, @SwitchPROM
    ret

@9000_FFFF:

    ; XXXXxxxx
    mov eax edx | and eax 0F0
    on eax = 00_1101_0000, @SwitchPROM
    on eax = 00_1110_0000, @SwitchCROM
    ret

@SwitchPROM:

    ; xxxxPPPP
    swap PROM, 16k, 0C000, edx
    ret

@SwitchCROM:

    ; xxxxCCCC
    swap CROM, 8k,  00000, edx
    ret

____________________________________________________________________________________________
; Mapper #240, Jing Ke Xin Zhuan

; $4020-$5FFF: PPPPCCCC - swap 32k PROM at $8000
;                       - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper240:

    ; Set ports
    CPUWrite 04020, 05FFF, @4020_5FFF

    ; Swap last bank into $C000
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@4020_5FFF:

    ; PPPPCCCC
    swap CROM, 8k,  00000, eax | shr eax 4
    swap PROM, 32k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #140, Jaleco

; $6000-$7000: PPPPCCCC - swap 32k PROM at $8000
;                       - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper140:

    ; Memory mapping
    CPUWrite 04080, 04080, @4080
    CPUWrite 06000, 07FFF, @6000_7FFF
    ret

@4080:

    ; ????????
    ret

@6000_7FFF:

    ; PPPPCCCC
    swap CROM, 8k,  00000, eax | shr eax 4
    swap PROM, 32k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #079, Nina-3

; $4020-$5FFF, $8000-$FFFF: xxxxxCCC - swap 8k  CROM at $0000
; $4100:                    xxxxPCCC - swap 32k PROM at $8000
;                                    - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper079:

    ; Memory mapping
    CPUWrite 04020, 05FFF, @4020_5FFF
    CPUWrite 08000, 0FFFF, @8000_FFFF
    CPUWrite 04100, 04100, @4100

    ; Hacks: force one-screen
    if D$Cartridge@PROMCRC32 =  08EB_DE64, mirror ONE_SCREEN_2000 ; Trolls on Treasure Island (U)
    if D$Cartridge@PROMCRC32 = 0627A_D380, mirror ONE_SCREEN_2000 ; Dudes With Attitude (U)
    ret

@4100:

    ; xxxxPCCC
    ifNotFlag. eax 08
        swap PROM, 32k, 08000, 0
    else
        swap PROM, 32k, 08000, 1
    endif
    call @8000_FFFF
    ret

@4020_5FFF:
@8000_FFFF:

    ; xxxxxCCC
    swap CROM, 8k, 00000, eax
    ret
____________________________________________________________________________________________
; Mapper #244, Decathlon

; $8065-$80A4: - swap 32k PROM at $8000 from bank (address - $8065) & 3
; $80A5-$80E4: - swap 8k  CROM at $0000 from bank (address - $80A5) & 7
____________________________________________________________________________________________

Mapper244:

    ; Set ports
    CPUWrite 08065, 080A4, @SwitchPROM
    CPUWrite 080A5, 080E4, @SwitchCROM

    ; NTSC hack
    if D$Cartridge@PROMCRC32 = 089A7_35D8, call MenuNTSC ; Decathlon
    ret

@SwitchPROM:

    sub edx 08065
    swap PROM, 32k, 08000, edx
    ret

@SwitchCROM:

    sub edx 080A5
    swap CROM, 8k,  00000, edx
    ret

____________________________________________________________________________________________
; Mapper #133, Sachen Chen

; $4120: xxxxxPCC - swap 32k PROM at $8000
;                 - swap 8k  CROM at $0000
____________________________________________________________________________________________

; $8000/$8001???
Mapper133:

    ; Set ports
    CPUWrite 04120, 04120, @4120
    ret

@4120:

    ; xxxxxPCC
    swap CROM, 8k,  00000, eax | shr eax 2
    swap PROM, 32k, 08000, eax
    ret
____________________________________________________________________________________________
