TITLE SaveGame

; Save game files and the load/save dialog.

____________________________________________________________________________________________
; Save/load game
____________________________________________________________________________________________

SaveGame:

    [@Filename: B$ 'save', 0]
    [@Extension: '.sst', 0]
    if D$pImage = &NULL, ret
    call SaveNumberedROMFile @Filename, @Extension
    ret

LoadGame:

    arguments @pFilename
    if D$pImage != &NULL, call LoadROMFile D@pFilename
    return

SaveQuick:

    [QuickSaveDescription: B$ 'Quick save', 0]
    mov B$GameDescription 0
    call AddString GameDescription, QuickSaveDescription
    call SaveROMFile QuickSaveFilename
    ret

LoadQuick:

    call LoadROMFile QuickSaveFilename
    ret

SaveSST: call SaveChunks FILE_ID_SST, SSTSaveTable | ret
LoadSST: call LoadChunks FILE_ID_SST, SSTLoadTable | ret
____________________________________________________________________________________________

SaveGameDescription:

    mov esi GameDescription, edi ChunkData
L0: movsb | on B$edi-1 != 0, L0<
    sub edi Chunk | mov D$ChunkSize edi
    ret

SaveGameScreenshot:

    call CopyMemory VideoBuffer+0900, ChunkData, (224 shl 8)
    mov D$ChunkSize (224 shl 8)+4
    ret

LoadGameDescription: mov B$GameDescription 0 | call AddString GameDescription ChunkData | ret
LoadGameScreenshot:  call CopyMemory ChunkData, ScreenshotData, (224 shl 8) | ret
____________________________________________________________________________________________

SaveGameCPU:        call SaveChunk CPU,             LENGTH_CPU | ret
SaveGamePPU:        call SaveChunk PPU,             LENGTH_PPU | ret
SaveGameAPU:        call SaveChunk APU,             LENGTH_APU | ret
SaveGameRendering:  call SaveChunk Rendering,       LENGTH_RENDERING | ret
SaveGameMapper:     call SaveChunk MapperData,      LENGTH_MAPPERDATA | ret
SaveGamePorts:      call SaveChunk Ports,           LENGTH_PORTS | ret

LoadGameCPU:        call LoadChunk CPU,             LENGTH_CPU | ret
LoadGamePPU:        call LoadChunk PPU,             LENGTH_PPU | ret
LoadGameAPU:        call LoadChunk APU,             LENGTH_APU | ret
LoadGameRendering:  call LoadChunk Rendering,       LENGTH_RENDERING | ret
LoadGameMapper:     call LoadChunk MapperData,      LENGTH_MAPPERDATA | ret
LoadGamePorts:      call LoadChunk Ports,           LENGTH_PORTS | ret
____________________________________________________________________________________________
; Battery-backed RAM
____________________________________________________________________________________________
[SAVExtension: '*.sav']
SaveBattery: call SaveROMFile BatteryFilename | ret
LoadBattery: call LoadFirstFile ROMDirectory, SAVExtension | ret
SaveSAV: call CopyMemory WRAM, SaveData, 02000 | mov D$SaveSize 02000 | ret
LoadSAV: call CopyMemory D$pFile, WRAM, 02000 | ret
____________________________________________________________________________________________
; Load/save dialog
____________________________________________________________________________________________

SaveDialogProc:

    arguments @hDialog, @Message, @wParam, @lParam

    pushad

        mov eax &FALSE
        if. D@Message = &WM_INITDIALOG  | call @Init    | else
        if. D@Message = &WM_COMMAND     | call @Command | else
        if. D@Message = &WM_CLOSE       | call @Close   | endif

        mov D$esp+28 eax
    popad
    return

@Init:

    ; Edit box (game description)
    [@SaveName: B$ 'Save ', 0]
    call 'Kernel32.GetLocalTime' SystemTime
    call SystemTimeToString
    mov B$GameDescription 0
    call AddString GameDescription, @SaveName
    call AddString GameDescription, SystemTimeString
    call 'User32.SendDlgItemMessageA' D@hDialog, IDC_EDIT+0, &WM_SETTEXT, 0, GameDescription
    call 'User32.SendDlgItemMessageA' D@hDialog, IDC_EDIT+0, &EM_SETSEL, 0, 10
    mov eax &TRUE
    ret

@Command:

    ; Escape pressed
    on W@wParam = &IDCANCEL, @Close

    ; Buttons
    on W@wParam = IDC_CANCEL, @Close
    if. W@wParam = IDC_BUTTON+0 ; Save
        if D$pImage = &NULL, break
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_EDIT+0, &WM_GETTEXT, &MAX_PATH, GameDescription
        call SaveGame
        jmp @Close
    endif
    mov eax &TRUE
    ret

@Close:

    call 'User32.EndDialog' D@hDialog, 1
    mov eax &TRUE
    ret

____________________________________________________________________________________________
; Load dialog
____________________________________________________________________________________________

LoadDialogProc:

    arguments @hDialog, @Message, @wParam, @lParam

    pushad

        mov eax &FALSE
        if. D@Message = &WM_INITDIALOG  | call @Init    | else
        if. D@Message = &WM_COMMAND     | call @Command | else
        if. D@Message = &WM_CLOSE       | call @Close   | endif

        mov D$esp+28 eax
    popad
    return

@Init:

    ; Create bitmap
    call CopyMemory Palette32, ScreenshotPalette, 0100
  . D$hDC = 'User32.GetDC' D@hDialog
  . D$hBMP = 'GDI32.CreateDIBitmap' D$hDC, BMIHeader, &NULL, VideoBuffer+0900, BMIHeader, &DIB_RGB_COLORS

    ; List box
    call @ListSaveGames
    call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_SETCURSEL, 0, 0
    call @LoadPreview
    mov eax &TRUE
    ret

@Command:

    ; Escape pressed
    on W@wParam = &IDCANCEL, @Close

    ; List box
    if. W@wParam = IDC_LISTBOX+0
        if W@wParam+2 = &LBN_SELCHANGE, call @LoadPreview
        if W@wParam+2 = &LBN_DBLCLK, mov D@wParam IDC_BUTTON+1
    endif

    ; Buttons
    on W@wParam = IDC_CANCEL, @Close
    if. W@wParam = IDC_BUTTON+0 ; Delete

        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETCURSEL, 0, 0
        if eax = &LB_ERR, break
        push eax

            mov B$Filename 0
            call AddString Filename, ROMDirectory
            call AddString Filename, @Filetitle
            call 'Kernel32.DeleteFileA' Filename
            call @ListSaveGames

            call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETCOUNT, 0, 0

        pop edx
        dec eax
        if edx <= eax, mov eax edx
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_SETCURSEL, eax, 0
        call @LoadPreview

    endif
    if. W@wParam = IDC_BUTTON+1 ; Load
        call LoadGame @FileTitle
        jmp @Close
    endif
    mov eax &TRUE
    ret

@Close:

    call 'GDI32.DeleteObject' D$hBMP
    call 'User32.ReleaseDC' D@hDialog, D$hDC
    call 'User32.EndDialog' D@hDialog, 1
    mov eax &TRUE
    ret
____________________________________________________________________________________________

@ListSaveGames:

    mov B$Filename 0
    call AddString Filename, ROMDirectory
    call AddString Filename, SearchSaveGame
    call 'User32.DlgDirListA' D@hDialog, Filename, IDC_LISTBOX+0, &NULL, &DDL_READWRITE
    ret

@LoadPreview:

    ; Get filename
    [@FileTitle: ? #80]
    call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETCURSEL, 0, 0
    call 'User32.SendDlgItemMessageA' D@hDialog, IDC_LISTBOX+0, &LB_GETTEXT, eax, @FileTitle
    mov B$Filename 0
    call AddString Filename, ROMDirectory
    call AddString Filename, @Filetitle

    ; Open file
  . D$hFile = 'Kernel32.CreateFileA' Filename, &GENERIC_READ, &NULL, &NULL, &OPEN_EXISTING, &FILE_ATTRIBUTE_NORMAL, &NULL

    if. eax != &INVALID_HANDLE_VALUE

        ; File time --> string
        call 'Kernel32.GetFileTime' D$hFile, &NULL, &NULL, UTCFileTime
        call 'Kernel32.FileTimeToLocalFileTime' UTCFileTime, FileTime
        call 'Kernel32.FileTimeToSystemTime' FileTime, SystemTime
        call SystemTimeToString

        ; Load file
      . D$Filesize = 'Kernel32.GetFileSize' D$hFile, &NULL
      . D$pFile = 'Kernel32.GlobalAlloc' &GPTR, D$Filesize
        call 'Kernel32.ReadFile' D$hFile, D$pFile, D$Filesize, Temp, &NULL
        call LoadChunks FILE_ID_SST, LoadPreviewTable

        call 'Kernel32.GlobalFree' D$pFile
        call 'Kernel32.CloseHandle' D$hFile

        ; Set static controls
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_STATIC+0, &WM_SETTEXT, 0, GameDescription
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_STATIC+2, &WM_SETTEXT, 0, SystemTimeString
        call 'GDI32.SetDIBits' D$hDC, D$hBMP, 0, 224, ScreenshotData, BMIHeader, &DIB_RGB_COLORS
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_STATIC+1, &STM_SETIMAGE, &IMAGE_BITMAP, D$hBMP
        call 'User32.InvalidateRect' D@hDialog, &NULL, &TRUE

    else

        ; Reset static controls
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_STATIC+0, &WM_SETTEXT, 0, &NULL
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_STATIC+2, &WM_SETTEXT, 0, &NULL
        call 'User32.SendDlgItemMessageA' D@hDialog, IDC_STATIC+1, &STM_SETIMAGE, &IMAGE_BITMAP, &NULL
        call 'User32.InvalidateRect' D@hDialog, &NULL, &TRUE

    endif
    ret

[LoadPreviewTable:
 LoadGameDescription
 LoadGameScreenshot
 &NULL]
[UTCFileTime: ? ?
 FileTime:    ? ?]
[SearchSaveGame:  B$ '*.sst', 0]
[GameDescription: B$ ? #&MAX_PATH]
[FileTimeString:  B$ ? #20]
[ScreenShotData:  B$ ? #LENGTH_VIDEO_BUFFER]
[hDC: ?]
[hBMP: ?]
[BMIHeader:
 @biSize:           D$ 40
 @biWidth:          D$ WIDTH_VIDEO_BUFFER
 @biHeight:         D$ (0-(HEIGHT_VIDEO_BUFFER-17))
 @biPlanes:         W$ 1
 @biBitCount:       W$ 8
 @biCompression:    D$ &BI_RGB
 @biSizeImage:      D$ 0
 @biXPelsPerMeter:  D$ 0
 @biYPelsPerMeter:  D$ 0
 @biClrUsed:        D$ 040
 @biClrImportant:   D$ 040

 ScreenshotPalette: D$ 0 #040]
____________________________________________________________________________________________
; System time to string
____________________________________________________________________________________________

[SystemTime:
 @wYear:         W$ ?
 @wMonth:        W$ ?
 @wDayOfWeek:    W$ ?
 @wDay:          W$ ?
 @wHour:         W$ ?
 @wMinute:       W$ ?
 @wSecond:       W$ ?
 @wMilliseconds: W$ ?]
[SystemTimeString: B$ ? #&MAX_PATH]
SystemTimeToString:

    mov edi SystemTimeString

    ; Year
    movzx eax W$SystemTime@wYear
    mov ebx 100, edx 0 | div ebx
    call BinToDec00
    movzx eax W$SystemTime@wYear
    call BinToDec00
    mov al '-' | stosb

    ; Month
    movzx eax W$SystemTime@wMonth
    call BinToDec00
    mov al '-' | stosb

    ; Day
    movzx eax W$SystemTime@wDay
    call BinToDec00

    ; Hour
    mov al ' ' | stosb
    mov al '(' | stosb
    movzx eax W$SystemTime@wHour
    call BinToDec00
    mov al ':' | stosb

    ; Minute
    movzx eax W$SystemTime@wMinute
    call BinToDec00
    mov al ')' | stosb

    mov B$edi 0
    ret

BinToDec00:

    mov ebx 10
    mov edx 0 | div ebx | push edx
    mov edx 0 | div ebx | push edx

    pop eax | add al '0' | stosb
    pop eax | add al '0' | stosb
    ret
____________________________________________________________________________________________
