TITLE Ports

; Emulates the NES I/O ports.
; As of now, only the two standard controllers are emulated, and the 4-player adapter.
; Through GetButtonStatus, the input engine is translated to the NES.

____________________________________________________________________________________________
; Register reads/writes
____________________________________________________________________________________________

Read4016:

    ; Transparent?
    if B$Strobe = 1, call GetButtonStatus
    mov eax 0

    if. B$Port1 = CONTROLLER_ZAPPER

        ; Zapper
        call CheckZapperHit
        if B$Zapper@Triggered = &TRUE, or al 010

    else

        ; Four-score
        if.. B$nRead4016 < 8  | shr B$JoypadStatus+0 1 | setc al | else.. ; Pad #1
        if.. B$nRead4016 < 16 | shr B$JoypadStatus+2 1 | setc al | else.. ; Pad #3
        if.. B$nRead4016 < 24 | test B$nRead4016 19    | sete al | else.. ; 4-player signature
        mov al 0, B$nRead4016 24 | endif..

    endif

    and B$CPUBus 040
    or al B$CPUBus
    inc B$nRead4016
    ret

Read4017:

    ; Transparent?
    if B$Strobe = 1, call GetButtonStatus
    mov eax 0

    if. B$Port2 = CONTROLLER_ZAPPER

        ; Zapper
        call CheckZapperHit
        if B$Zapper@Triggered = &TRUE, or al 010

    else

        ; Four-score
        if.. B$nRead4017 < 8  | shr B$JoypadStatus+1 1 | setc al | else.. ; Pad #2
        if.. B$nRead4017 < 16 | shr B$JoypadStatus+3 1 | setc al | else.. ; Pad #4
        if.. B$nRead4017 < 24 | test B$nRead4017 18    | sete al | else.. ; 4-player signature
        mov al 0, B$nRead4017 24 | endif..

    endif

    and B$CPUBus 040
    or al B$CPUBus
    inc B$nRead4017
    ret

Write4016:

    ; Register toggled 1->0?  -->  get button status
    and al 1
    xchg al B$Strobe
    if al = 1,
        if B$Strobe = 0,
            call GetButtonStatus
    ret

GetButtonStatus:

    mov B$nRead4016 0
    mov B$nRead4017 0
    mov ebx 0, ecx 0

    ; Pads
L0: mov al 0
    ifFlag  B$InputArray+ebx+PAD1_A      BUTTON_DOWN, or al 01
    ifFlag  B$InputArray+ebx+PAD1_B      BUTTON_DOWN, or al 02
    ifFlag  B$InputArray+ebx+PAD1_SELECT BUTTON_DOWN, or al 04
    ifFlag  B$InputArray+ebx+PAD1_START  BUTTON_DOWN, or al 08
    ifFlag  B$InputArray+ebx+PAD1_UP     BUTTON_DOWN, or al 010
    ifFlag  B$InputArray+ebx+PAD1_LEFT   BUTTON_DOWN, or al 040
    ifFlag. B$InputArray+ebx+PAD1_DOWN   BUTTON_DOWN | or al 020 | and al 0FF-010 | endif
    ifFlag. B$InputArray+ebx+PAD1_RIGHT  BUTTON_DOWN | or al 080 | and al 0FF-040 | endif
    mov B$JoypadStatus+ecx al
    add ebx 10
    inc ecx | on ecx < 4, L0<<
    ret

____________________________________________________________________________________________
; Zapper
____________________________________________________________________________________________

ZapperCoordinates:

    pop eax, W@X, W@Y | push eax

    [@Coordinates:
     @X: ?
     @Y: ?]
    call 'User32.ClientToScreen' D$hMainWindow, @Coordinates

    ; x
    mov eax D@X | sub eax D$ClientRect+00
    mov ecx D$SourceRect+08 | sub ecx D$SourceRect+00 | mul ecx
    mov ecx D$ClientRect+08 | sub ecx D$ClientRect+00 | div ecx
    mov D$Zapper@X eax

    ; y
    mov eax D@Y | sub eax D$ClientRect+04
    mov ecx D$SourceRect+0C | sub ecx D$SourceRect+04 | mul ecx
    mov ecx D$ClientRect+0C | sub ecx D$ClientRect+04 | div ecx
    mov D$Zapper@Y eax
    ret

CheckZapperHit:

    ; Find pixel
    mov ebx D$Zapper@Y
    add ebx D$SourceRect+04
    shl ebx 8
    mov bl B$Zapper@X

    mov al 08

    ; Maybe it's not rendered yet?
    if ebx > D$VideoCursor, ret

    ; Check pixel
    if B$VideoBuffer+ebx = 015, mov al 0 ; Chiller (U)
    if B$VideoBuffer+ebx = 020, mov al 0
    if B$VideoBuffer+ebx = 030, mov al 0
    ret

SetZapper:

    arguments @pPort, @Enabled
    mov ebx D@pPort
    if. B@Enabled = &TRUE
        mov D$ebx CONTROLLER_ZAPPER
    else
        mov D$ebx CONTROLLER_GAMEPAD
    endif

    call UpdateCursor
    return

____________________________________________________________________________________________
; Data
____________________________________________________________________________________________

[LENGTH_PORTS <(SIZE_PORTS shl 2)>]
[SIZE_PORTS 7]
[Ports:
 nRead4016:     ?
 nRead4017:     ?
 JoypadStatus:  ?
 Strobe:        ?

 Zapper:
 @Triggered:    ?
 @X:            ?
 @Y:            ?]
____________________________________________________________________________________________
