TITLE PRom_CRom_Mirror

; ____________________________________________________________________________________________
;
;                      PROM/CROM/mirror switching mappers
;
; ____________________________________________________________________________________________

____________________________________________________________________________________________
; Mapper #058, 68-in-1 + 32-in-1 jammed together (sigh)

; $8000-$FFFF: ------M- - mirror HORIZONTAL/VERTICAL (0/1)
;    (address) -SCCCPPp - (S = 0) swap 32k PROM at $8000 (PP)
;                       - (S = 1) swap 16k PROM at $8000 and $C000 (PPp)
;                       - swap 8k CROM at $0000
____________________________________________________________________________________________

Mapper058:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; Hack for Study and Game 32-in-1
    if. D$Cartridge@PROMCRC32 = 0ABB2_F974 ; Study and Game 32-in-1 [!]
        swap PROM, 32k, 08000, eax
    endif

    ; ------M-
    ifNotFlag. al 02
        mirror HORIZONTAL
    else
        mirror VERTICAL
    endif

    ; -S---PPp
    mov eax edx | and eax 07
    ifNotFlag. edx 040
        shr eax 1
        swap PROM, 32k, 08000, eax
    else
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    endif

    ; --CCC
    shr edx 3
    swap CROM, 8k, 00000, edx
    ret
____________________________________________________________________________________________
; Mapper #068, Sunsoft #4

; $8000-$8FFF: CCCCCCCC - swap 2k CROM at $0000
; $9000-$9FFF: CCCCCCCC - swap 2k CROM at $0800
; $A000-$AFFF: CCCCCCCC - swap 2k CROM at $1000
; $B000-$BFFF: CCCCCCCC - swap 2k CROM at $1800
; $C000-$CFFF: xCCCCCCC - swap 1k CiROM at $2000 (from last 128k segment)
; $D000-$DFFF: xCCCCCCC - swap 1k CiROM at $2400 (from last 128k segment)
; $E000-$EFFF: xxxExxMM - enable CiROM at $2000-$2FFF
;                       - mirror VERTICAL/HORIZONTAL/$2000/$2400 (0/1/2/3)
; $F000-$FFFF: PPPPPPPP - swap 16k PROM at $8000
____________________________________________________________________________________________

Mapper068:

    ; Memory mapping
    CPUWrite 08000, 08FFF, @8000_8FFF
    CPUWrite 09000, 09FFF, @9000_9FFF
    CPUWrite 0A000, 0AFFF, @A000_AFFF
    CPUWrite 0B000, 0BFFF, @B000_BFFF
    CPUWrite 0C000, 0CFFF, @C000_CFFF
    CPUWrite 0D000, 0DFFF, @D000_DFFF
    CPUWrite 0E000, 0EFFF, @E000_EFFF
    CPUWrite 0F000, 0FFFF, @F000_FFFF

    ; CiRAM/CiROM
    PPURead  02000, 02FFF, @ReadCiRAM
    PPUWrite 02000, 02FFF, @WriteCiRAM

    ; Last bank
    swap PROM, 16k, 0C000, LAST_BANK

    call @UpdateMirroring
    ret

; CCCCCCCC
@8000_8FFF: swap CROM, 2k,  0000, eax | ret
@9000_9FFF: swap CROM, 2k,  0800, eax | ret
@A000_AFFF: swap CROM, 2k, 01000, eax | ret
@B000_BFFF: swap CROM, 2k, 01800, eax | ret
; xCCCCCCC
@C000_CFFF: mov D$Bank+00 eax | call @UpdateMirroring | ret
@D000_DFFF: mov D$Bank+04 eax | call @UpdateMirroring | ret

@E000_EFFF:

    ; xxxExxxx
    test eax 010 | setnz B$Register

    ; xxxxxxMM
    and eax 03 | mov D$Register+04 eax
    call @UpdateMirroring
    ret

@UpdateMirroring:

    mov eax D$Register+04


    if.. B$Register = &FALSE

        ; xxxxxxMM
        if al = 0, mirror VERTICAL
        if al = 1, mirror HORIZONTAL
        if al = 2, mirror ONE_SCREEN_2000
        if al = 3, mirror ONE_SCREEN_2400

    else..

        or D$Bank+00 080
        or D$Bank+04 080

        ; xxxxxxMM
        if. al = 0
            swap CiROM, 1k, 02000, D$Bank+00
            swap CiROM, 1k, 02400, D$Bank+04
            swap CiROM, 1k, 02800, D$Bank+00
            swap CiROM, 1k, 02C00, D$Bank+04
        endif
        if. al = 1
            swap CiROM, 1k, 02000, D$Bank+00
            swap CiROM, 1k, 02400, D$Bank+00
            swap CiROM, 1k, 02800, D$Bank+04
            swap CiROM, 1k, 02C00, D$Bank+04
        endif
        if. al = 2
            swap CiROM, 1k, 02000, D$Bank+00
            swap CiROM, 1k, 02400, D$Bank+00
            swap CiROM, 1k, 02800, D$Bank+00
            swap CiROM, 1k, 02C00, D$Bank+00
        endif
        if. al = 3
            swap CiROM, 1k, 02000, D$Bank+04
            swap CiROM, 1k, 02400, D$Bank+04
            swap CiROM, 1k, 02800, D$Bank+04
            swap CiROM, 1k, 02C00, D$Bank+04
        endif

    endif..
    ret

; PPPPPPPP
@F000_FFFF: swap PROM, 16k, 08000, eax | ret

@ReadCiRAM:

    on B$Register = &FALSE, ReadCiRAM
    jmp ReadCiROM

@WriteCiRAM:

    on B$Register = &FALSE, WriteCiRAM
    ret
____________________________________________________________________________________________
; Mapper #082, Taito

; $7EF0: CCCCCCCx - swap 2k CROM at $0000
; $7EF1: CCCCCCCx - swap 2k CROM at $0800
; $7EF2: CCCCCCCC - swap 1k CROM at $1000
; $7EF3: CCCCCCCC - swap 1k CROM at $1400
; $7EF4: CCCCCCCC - swap 1k CROM at $1800
; $7EF5: CCCCCCCC - swap 1k CROM at $1C00
; $7EF6: xxxxxxSM - mirror HORIZONTAL/VERTICAL (0/1)
;                 - (S = 0) xor CROM swap address with $1000
; $7EFA: PPPPPPxx - swap 8k PROM at $8000
; $7EFA: PPPPPPxx - swap 8k PROM at $A000
; $7EFA: PPPPPPxx - swap 8k PROM at $C000
____________________________________________________________________________________________

Mapper082:

    ; Memory mapping
    CPUWrite 07EF0, 07EF0, @7EF0
    CPUWrite 07EF1, 07EF1, @7EF1
    CPUWrite 07EF2, 07EF2, @7EF2
    CPUWrite 07EF3, 07EF3, @7EF3
    CPUWrite 07EF4, 07EF4, @7EF4
    CPUWrite 07EF5, 07EF5, @7EF5
    CPUWrite 07EF6, 07EF6, @7EF6
    CPUWrite 07EFA, 07EFA, @7EFA
    CPUWrite 07EFB, 07EFB, @7EFB
    CPUWrite 07EFC, 07EFC, @7EFC

    mirror VERTICAL
    swap PROM, 16k, 0C000, LAST_BANK
    ret

; CCCCCCCx
@7EF0: mov edx  0000 | xor edx D$Register | shr eax 1 | swap CROM, 2k, edx, eax | ret
@7EF1: mov edx  0800 | xor edx D$Register | shr eax 1 | swap CROM, 2k, edx, eax | ret
; CCCCCCCC
@7EF2: mov edx 01000 | xor edx D$Register | swap CROM, 1k, edx, eax | ret
@7EF3: mov edx 01400 | xor edx D$Register | swap CROM, 1k, edx, eax | ret
@7EF4: mov edx 01800 | xor edx D$Register | swap CROM, 1k, edx, eax | ret
@7EF5: mov edx 01C00 | xor edx D$Register | swap CROM, 1k, edx, eax | ret

@7EF6:

    ; xxxxxxxM
    ifNotFlag. eax 01
        mirror HORIZONTAL
    else
        mirror VERTICAL
    endif

    ; xxxxxxSx
    ifNotFlag. eax 02
        mov D$Register 00000
    else
        mov D$Register 01000
    endif
    ret

@7EFA: shr eax 2 | swap PROM, 8k, 08000, eax | ret
@7EFB: shr eax 2 | swap PROM, 8k, 0A000, eax | ret
@7EFC: shr eax 2 | swap PROM, 8k, 0C000, eax | ret

____________________________________________________________________________________________
; Mapper #080, Taito X-005

; $7EF0: xCCCCCCx - swap 2k CROM at $0000
; $7EF1: xCCCCCCx - swap 2k CROM at $0800
; $7EF2: xCCCCCCC - swap 1k CROM at $1000
; $7EF3: xCCCCCCC - swap 1k CROM at $1400
; $7EF4: xCCCCCCC - swap 1k CROM at $1800
; $7EF5: xCCCCCCC - swap 1k CROM at $1C00
; $7EF6: xxxxxxxM - mirror HORIZONTAL/VERTICAL (0/1)
; $7EFA:
; $7EFB: PPPPPPPP - swap 8k PROM at $8000
; $7EFC:
; $7EFD: PPPPPPPP - swap 8k PROM at $A000
; $7EFE:
; $7EFF: PPPPPPPP - swap 8k PROM at $C000
____________________________________________________________________________________________

Mapper080:

    ; Memory mapping
    CPUWrite 07EF0, 07EF0, @7EF0
    CPUWrite 07EF1, 07EF1, @7EF1
    CPUWrite 07EF2, 07EF2, @7EF2
    CPUWrite 07EF3, 07EF3, @7EF3
    CPUWrite 07EF4, 07EF4, @7EF4
    CPUWrite 07EF5, 07EF5, @7EF5
    CPUWrite 07EF6, 07EF6, @7EF6
    CPUWrite 07EFA, 07EFB, @7EFA_7EFB
    CPUWrite 07EFC, 07EFD, @7EFC_7EFD
    CPUWrite 07EFE, 07EFF, @7EFE_7EFF

    ; Last bank
    swap PROM, 16k, 0C000, LAST_BANK

    ; Mirroring hack
    if. D$Cartridge@PROMCRC32 = 09832_D15A ; Fudou Myouou Den (J)
        mov D$Bank+00 0000
        mov D$Bank+04 0000
        mov D$Bank+08 0400
        mov D$Bank+0C 0400
        CPUWrite 07EF0, 07EF0, @Hack7EF0
        CPUWrite 07EF1, 07EF1, @Hack7EF1
        CPUWrite 07EF6, 07EF6, @Hack7EF6
    endif
    ret

; xCCCCCCx
@7EF0: shr eax 1 | swap CROM, 2k, 0000, eax | ret
@7EF1: shr eax 1 | swap CROM, 2k, 0800, eax | ret
; xCCCCCCC
@7EF2: swap CROM, 1k, 01000, eax | ret
@7EF3: swap CROM, 1k, 01400, eax | ret
@7EF4: swap CROM, 1k, 01800, eax | ret
@7EF5: swap CROM, 1k, 01C00, eax | ret

@7EF6:

    ; xxxxxxxM
    ifNotFlag. eax 01
        mirror HORIZONTAL
    else
        mirror VERTICAL
    endif
    ret

; PPPPPPPP
@7EFA_7EFB: swap PROM, 8k, 08000, eax | ret
@7EFC_7EFD: swap PROM, 8k, 0A000, eax | ret
@7EFE_7EFF: swap PROM, 8k, 0C000, eax | ret
____________________________________________________________________________________________

@Hack7EF0:

    ifNotFlag. eax 080
        mov D$Bank+00 0000
        mov D$Bank+04 0000
    else
        mov D$Bank+00 0400
        mov D$Bank+04 0400
    endif
    mov esi Bank, edi IndexCiRAM, ecx 4 | rep movsd
    jmp @7EF0

@Hack7EF1:

    ifNotFlag. eax 080
        mov D$Bank+08 0000
        mov D$Bank+0C 0000
    else
        mov D$Bank+08 0400
        mov D$Bank+0C 0400
    endif
    mov esi Bank, edi IndexCiRAM, ecx 4 | rep movsd
    jmp @7EF1

@Hack7EF6:

    mov D$Bank+00 0000
    mov D$Bank+0C 0400
    ifNotFlag. eax 01
        mov D$Bank+04 0000
        mov D$Bank+08 0400
    else
        mov D$Bank+04 0400
        mov D$Bank+08 0000
    endif
    jmp @7EF6
____________________________________________________________________________________________
; Mapper #032, Irem G-101

; $8000-$8FFF: PPPPPPPP - swap 8k PROM at $8000/$C000 (S = 0/1)
; $9000-$9FFF: xxxxxxSM - mirror VERTICAL/HORIZONTAL (0/1)
; $A000-$AFFF: PPPPPPPP - swap 8k PROM ar $A000
; $B000:       CCCCCCCC - swap 1k CROM at $0000
; $B001:       CCCCCCCC - swap 1k CROM at $0400
; $B002:       CCCCCCCC - swap 1k CROM at $0800
; $B003:       CCCCCCCC - swap 1k CROM at $0C00
; $B004:       CCCCCCCC - swap 1k CROM at $1000
; $B005:       CCCCCCCC - swap 1k CROM at $1400
; $B006:       CCCCCCCC - swap 1k CROM at $1800
; $B007:       CCCCCCCC - swap 1k CROM at $1C00
____________________________________________________________________________________________

Mapper032:

    ; Memory mapping
    CPUWrite 08000, 08FFF, @8000_8FFF
    CPUWrite 09000, 09FFF, @9000_9FFF
    CPUWrite 0A000, 0AFFF, @A000_AFFF
    mov ecx 0B000
L0: push ecx
        mov eax WriteVoid
        and ecx 0B007
        if ecx = 0B000, mov eax @B000
        if ecx = 0B001, mov eax @B001
        if ecx = 0B002, mov eax @B002
        if ecx = 0B003, mov eax @B003
        if ecx = 0B004, mov eax @B004
        if ecx = 0B005, mov eax @B005
        if ecx = 0B006, mov eax @B006
        if ecx = 0B007, mov eax @B007
    pop ecx
    CPUWrite ecx, ecx, eax
    inc ecx | on ecx < 0C000, L0<<

    ; Last PROM bank
    swap PROM, 16k, 0C000, LAST_BANK

    ; Ai Sensei no Oshiete - Watashi no Hoshi
    if. D$Cartridge@PROMCRC32 = 0FD3F_C292
        swap PROM, 16k, 08000, 0F
        swap PROM, 16k, 0C000, 0F
    endif

    ; Major League
    if D$Cartridge@PROMCRC32 = 0C0FE_D437
    mirror ONE_SCREEN_2000
    ret

@8000_8FFF:

    ; PPPPPPPP
    if. B$Register = 0
        swap PROM, 8k, 08000, eax
    else
        swap PROM, 8k, 0C000, eax
    endif
    ret

@9000_9FFF:

    ; xxxxxxxM
    ifNotFlag. eax 01
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxxxxSx
    test eax 02 | setnz B$Register
    ret

@A000_AFFF: swap PROM, 8k, 0A000, eax | ret
@B000: swap CROM, 1k,  0000, eax | ret
@B001: swap CROM, 1k,  0400, eax | ret
@B002: swap CROM, 1k,  0800, eax | ret
@B003: swap CROM, 1k,  0C00, eax | ret
@B004: swap CROM, 1k, 01000, eax | ret
@B005: swap CROM, 1k, 01400, eax | ret
@B006: swap CROM, 1k, 01800, eax | if D$Cartridge@PROMCRC32 = 0C0FE_D437, ifFlag eax 040, mirror MIRRORING_0001  | ret ; Major League
@B007: swap CROM, 1k, 01C00, eax | if D$Cartridge@PROMCRC32 = 0C0FE_D437, ifFlag eax 040, mirror ONE_SCREEN_2000 | ret ; Major League
____________________________________________________________________________________________
; Mapper #234, Maxi-15

; (Read/write)
; $FF80-$FF9F: MSxxABCD - high bits of bank select
; $FFE8-$FFF7: xEFGxxxH - low  bits of bank select
;                       - (S = 0) swap 32k PROM at $8000 (ABCD)
;                       - (S = 0) swap 8k  CROM at $0000 (ABCDFG)
;                       - (S = 1) swap 32k PROM at $8000 (ABCH)
;                       - (S = 1) swap 8k  CROM at $0000 (ABCEFG)
;                       - mirror VERTICAL/HORIZONTAL (0/1)
____________________________________________________________________________________________

Mapper234:

    ; Memory mapping
    CPUWrite 0FF80, 0FF9F, @FF80_FF9F
    CPUWrite 0FFE8, 0FFF7, @FFE8_FFF7
    CPURead  0FF80, 0FF9F, @ReadFF80_FF9F
    CPURead  0FFE8, 0FFF7, @ReadFFE8_FFF7
    CPURead 06000, 07FFF, ReadVoid

    mirror VERTICAL
    ret

@FF80_FF9F:

    if. D$Bank+00 = 0

        ; Mxxxxxxx
        ifNotFlag.. eax 080
            mirror VERTICAL
        else..
            mirror HORIZONTAL
        endif..

        mov D$Bank+00 eax
        call @UpdateBanks

    endif
    ret

@FFE8_FFF7:

    mov D$Bank+04 eax
    call @UpdateBanks
    ret

@ReadFF80_FF9F:

    call ReadPROM
    jmp @FF80_FF9F

@ReadFFE8_FFF7:

    call ReadPROM
    jmp @FFE8_FFF7
____________________________________________________________________________________________

@UpdateBanks:

    ; PROM
    mov eax D$Bank+00
    mov edx D$Bank+04
    ifFlag. eax 040
        and eax 0E
        and edx 01
        or eax edx
    endif
    and eax 0F
    swap PROM, 32k, 08000, eax

    ; CROM
    mov eax D$Bank+00
    mov edx D$Bank+04 | shr edx 4
    ifFlag. eax 040
        and eax 0E
        and edx 07
    else
        and eax 0F
        and edx 03
    endif
    shl eax 2
    or eax edx
    swap CROM, 8k, 00000, eax
    ret

____________________________________________________________________________________________
; Mapper #096, Bandai 74HC161/32

; $8000-$FFFF: xxxxxSPP - swap 32k PROM at $8000
;                       - Select 16k CRAM segment
; Select 4k CRAM at $0000 from VRAM address
; Keep last 4k CRAM of segment in $1000

____________________________________________________________________________________________

Mapper096:

    ; Set 32k of CRAM
    mov D$Cartridge@SizeCRAM 32

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    PPURead  02000, 023BF, @NameTable
    PPURead  02400, 027BF, @NameTable
    PPURead  02800, 02BBF, @NameTable
    PPURead  02C00, 02FBF, @NameTable

    swap CRAM, 4k, 00000, 0
    swap CRAM, 4k, 01000, 3
    ret

@8000_FFFF:

    ; xxxxxxPP
    swap PROM, 32k, 08000, eax

    ; xxxxxSxx
    and eax 4 | mov D$Register eax
    or eax D$Register+04 | swap CRAM, 4k, 00000, eax
    or eax 3             | swap CRAM, 4k, 01000, eax
    ret

@NameTable:

    push eax

        and ah 03 | movzx eax ah
        if. eax != D$Register+04
            mov D$Register+04 eax
            or eax D$Register
            swap CRAM, 4k, 00000, eax
        endif

    pop eax
    call ReadCiRAM
    ret

____________________________________________________________________________________________
; Mapper #112, ASDER

; $8000: xxxxxNNN - command number
; $A000: BBBBBBBb - (NNN = 0) swap 8k PROM at $8000 (BBBBBBBb)
;                 - (NNN = 1) swap 8k PROM at $A000 (BBBBBBBb)
;                 - (NNN = 2) swap 2k PROM at $0000 (BBBBBBB)
;                 - (NNN = 2) swap 2k PROM at $0800 (BBBBBBB)
;                 - (NNN = 4) swap 1k PROM at $1000 (BBBBBBBb)
;                 - (NNN = 5) swap 1k PROM at $1400 (BBBBBBBb)
;                 - (NNN = 6) swap 1k PROM at $1800 (BBBBBBBb)
;                 - (NNN = 7) swap 1k PROM at $1C00 (BBBBBBBb)
; $E000: xxxxxxxM - mirror VERTICAL/HORIZONTAL (0/1)
____________________________________________________________________________________________

Mapper112:

    ; Memory mapping
    CPUWrite 08000, 08000, @8000
    CPUWrite 0A000, 0A000, @A000
    CPUWrite 0C000, 0C000, @C000
    CPUWrite 0E000, 0E000, @E000

    ; Load last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000: mov D$Command eax | ret

@A000:

    mov edx D$Command | and edx 07
    mov ecx eax | shr ecx 1

    if edx = 0, swap PROM, 8k, 08000, eax
    if edx = 1, swap PROM, 8k, 0A000, eax
    if edx = 2, swap CROM, 2k,  0000, ecx
    if edx = 3, swap CROM, 2k,  0800, ecx
    if edx = 4, swap CROM, 1k, 01000, eax
    if edx = 5, swap CROM, 1k, 01400, eax
    if edx = 6, swap CROM, 1k, 01800, eax
    if edx = 7, swap CROM, 1k, 01C00, eax
    ret

; ????????
@C000: ret

@E000:

    ; xxxxxxxM
    ifNotFlag. eax 01
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif
    ret

____________________________________________________________________________________________
; Mapper #243, Sachen 74LS374N

; $4100: xxxxxNNN - command number
; $4101: xxxxxxBB - (NNN = 000) swap first 32k PROM at $8000, and 4th 8k CROM at $0000
;                 - (NNN = 100) xB = LSB of 8k CROM select
;                 - (NNN = 110) BB = Two MSB of 8k CROM select
;                 - (NNN = 101) xB = swap 32k PROM at $8000
;                 - (NNN = 111) xB = mirror VERTICAL/HORIZONTAL (1/0)
____________________________________________________________________________________________

Mapper243:

    ; Memory mapping
    mov ecx 04100
L0: push ecx
        mov eax WriteVoid
        and ecx 04101
        if ecx = 04100, mov eax @4100
        if ecx = 04101, mov eax @4101
    pop ecx
    CPUWrite ecx, ecx, eax
    inc ecx | on ecx < 08000, L0<

    ; Reset regs
    call @4101
    ret

@4100: mov D$Command eax | ret

@4101:

    mov edx D$Command | and edx 7

    if. edx = 0
        swap PROM, 32k, 08000, 0
        mov D$Register 3
    endif

    if. edx = 4
        and D$Register 06
        and eax 01
        or  D$Register eax
    endif

    if. edx = 5
        and eax 01
        swap PROM, 32k, 08000, eax
    endif

    if. edx = 6
        and D$Register 01
        and eax 03
        shl eax 1
        or D$Register eax
    endif

    if. edx = 7
        mirror HORIZONTAL
        ifFlag eax 01, mirror VERTICAL
    endif

    swap CROM, 8k, 00000, D$Register
    ret

____________________________________________________________________________________________
; Mapper #057, Game star GK-54

; $x000-$x7FF: xIxxxxCC (xxxxxx10) - (I = 1) swap 8k CROM at $0000 (3210)
; $x800-$xFFF: CPpSMCCC (3xxxx210) - (S = 0) swap 16k PROM at $8000 and $C000 (Pp)
;                                  - (S = 1) swap 32k PROM at $8000 (1P)
;                                  - mirror VERTICAL/HORIZONTAL (0/1)
;                                  - swap 8k CROM at $0000 (3210)
____________________________________________________________________________________________

Mapper057:

    ; Memory mapping
    mov ecx 08000
L0: CPUWrite ecx, ecx, @8000
    ifFlag ecx 0800, CPUWrite ecx, ecx, @8800
    inc cx | jnz L0<

    ; Load first bank
    swap PROM, 16k, 0C000, 0
    ret

@8000:

    ; xIxxxxxx
    ifFlag. eax 040

        ; Swap CROM
        and eax 03
        or  eax D$Register
        swap CROM, 8k, 00000, eax

    endif
    ret

@8800:

    ; xxxxMxxx
    ifNotFlag. eax 08
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xPpSxxxx
    mov edx eax
    shr edx 5
    ifFlag. eax 010
        shr edx 1
        swap PROM, 32k, 08000, edx
    else
        swap PROM, 16k, 08000, edx
        swap PROM, 16k, 0C000, edx
    endif

    ; CxxxxCCC
    ifFlag. eax 080
        and eax 07
        or  eax 08
    else
        and eax 07
    endif
    mov D$Register eax
    swap CROM, 8k, 00000, eax
    ret

____________________________________________________________________________________________
; Mapper #255, 110-in-1

; $5800-$5FFF: access the four registers
; $8000-$FFFF: (address) 1HMSPPPP_PpCCCCCC - mirror VERTICAL/HORIZONTAL (0/1)
;                                          - (S = 0) swap 32k PROM at $8000 (PPPPP)
;                                          - (S = 1) swap 16k PROM at $8000 and $C000 (PPPPPp)
;                                          - swap 8k CROM at $0000
;                                          - H = high bit of PROM/CROM bank select
____________________________________________________________________________________________

Mapper255:

    ; Memory mapping
    CPURead  05800, 05FFF, @ReadRegister
    CPUWrite 05800, 05FFF, @WriteRegister
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Reset regs
    mov D$Register 0
    ret

@ReadRegister:
    and edx 03
    movzx eax B$Register+edx
    ret

@WriteRegister:

    and edx 03
    and eax 0F
    mov B$Register+edx al
    ret

@8000_FFFF:

    ; xxMxxxxx_xxxxxxxx
    ifNotFlag. edx 02000
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xHxxxxxx_xxCCCCCC
    mov eax edx | and eax 03F
    ifFlag edx 04000, or eax 040
    swap CROM, 8k, 00000, eax

    ; xHxSPPPP_Ppxxxxxx
    mov eax edx
    shr eax 6 | and eax 03F
    ifFlag edx 04000, or eax 040
    ifNotFlag. edx 01000
        and eax 03E
        swap PROM, 16k, 08000, eax | inc eax
        swap PROM, 16k, 0C000, eax
    else
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    endif
    ret

____________________________________________________________________________________________
; Mapper #225, 72-in-1

; $8000-$FFFF: (address) 1xMSPPPP_PpCCCCCC - mirror VERTICAL/HORIZONTAL (0/1)
;                                          - (S = 0) swap 32k PROM at $8000 (PPPPP)
;                                          - (S = 1) swap 16k PROM at $8000 and $C000 (PPPPPp)
;                                          - swap 8k CROM at $0000
____________________________________________________________________________________________

Mapper225:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxMxxxxx_xxxxxxxx
    ifNotFlag. edx 02000
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxxxxxx_xxCCCCCC
    swap CROM, 8k, 00000, edx

    ; xxxSPPPP_Ppxxxxxx
    ifNotFlag. edx 01000
        shr edx 7
        swap PROM, 32k, 08000, edx
    else
        shr edx 6
        swap PROM, 16k, 08000, edx
        swap PROM, 16k, 0C000, edx
    endif
    ret
____________________________________________________________________________________________
; Mapper #075, Konami VRC1 / Jaleco D65005

; $8000-$8FFF: PPPPPPPP - swap 8k PROM at $8000
; $9000-$9FFF: xxxxxCcM - mirror VERTICAL/HORIZONTAL (0/1)
;                       - c = bit 4 of CROM select at $0000
;                       - C = bit 4 of CROM select at $1000
; $A000-$AFFF: PPPPPPPP - swap 8k PROM at $A000
; $C000-$CFFF: PPPPPPPP - swap 8k PROM at $C000
; $E000-$EFFF: xxxxCCCC - swap 4k CROM at $0000
; $F000-$FFFF: xxxxCCCC - swap 4k CROM at $1000
____________________________________________________________________________________________

[CROMLow  Register+00
 CROMHigh Register+04]

Mapper075:

    ; Memory mapping
    CPUWrite 08000, 08FFF, @8000_8FFF
    CPUWrite 09000, 09FFF, @9000_9FFF
    CPUWrite 0A000, 0AFFF, @A000_AFFF
    CPUWrite 0C000, 0CFFF, @C000_CFFF
    CPUWrite 0E000, 0EFFF, @E000_EFFF
    CPUWrite 0F000, 0FFFF, @F000_FFFF

    ; Load last PROM bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

; PPPPPPPP
@8000_8FFF: swap PROM, 8k, 08000, eax | ret
@A000_AFFF: swap PROM, 8k, 0A000, eax | ret
@C000_CFFF: swap PROM, 8k, 0C000, eax | ret

; xxxxCCCC
@E000_EFFF: and eax 0F | and D$CROMLow  010 | or D$CROMLow  eax | swap CROM, 4k, 00000, D$CROMLow  | ret
@F000_FFFF: and eax 0F | and D$CROMHigh 010 | or D$CROMHigh eax | swap CROM, 4k, 01000, D$CROMHigh | ret

@9000_9FFF:

    ; xxxxxxxM
    ifNotFlag. eax 01
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxxxxcx
    ifFlag. eax 02
        or D$CROMLow 010
    else
        and D$CROMLow 0F
    endif

    ; xxxxxCxx
    ifFlag. eax 04
        or D$CROMHigh 010
    else
        and D$CROMHigh 0F
    endif

    ; Swap new banks
    swap CROM, 4k, 00000, D$CROMLow
    swap CROM, 4k, 01000, D$CROMHigh
    ret

____________________________________________________________________________________________
; Mapper #022, Konami VRC4 1B

; $8000: PPPPPPPP - swap 8k PROM at $8000
; $9000: xxxxxxMM - mirror VERTICAL/HORIZONTAL/$2400/$2000 (0/1/2/3)
; $A000: PPPPPPPP - swap 8k PROM at $A000
; $B000: CCCCCCCx - swap 1k CROM at $0000
; $B001: CCCCCCCx - swap 1k CROM at $0400
; $C000: CCCCCCCx - swap 1k CROM at $0800
; $C001: CCCCCCCx - swap 1k CROM at $0C00
; $D000: CCCCCCCx - swap 1k CROM at $1000
; $D001: CCCCCCCx - swap 1k CROM at $1400
; $E000: CCCCCCCx - swap 1k CROM at $1800
; $E001: CCCCCCCx - swap 1k CROM at $1C00
____________________________________________________________________________________________

Mapper022:

    ; Memory mapping
    CPUWrite 08000, 08000, @8000
    CPUWrite 09000, 09000, @9000
    CPUWrite 0A000, 0A000, @A000
    CPUWrite 0B000, 0B000, @B000
    CPUWrite 0B001, 0B001, @B001
    CPUWrite 0C000, 0C000, @C000
    CPUWrite 0C001, 0C001, @C001
    CPUWrite 0D000, 0D000, @D000
    CPUWrite 0D001, 0D001, @D001
    CPUWrite 0E000, 0E000, @E000
    CPUWrite 0E001, 0E001, @E001

    ; Load first 1k CROM
    swap CROM, 1k,  0000, 0
    swap CROM, 1k,  0400, 0
    swap CROM, 1k,  0800, 0
    swap CROM, 1k,  0C00, 0
    swap CROM, 1k, 01000, 0
    swap CROM, 1k, 01400, 0
    swap CROM, 1k, 01800, 0
    swap CROM, 1k, 01C00, 0

    ; Load last 16k PROM
    swap PROM, 16k, 0C000, LAST_BANK
    ret

; PPPPPPPP
@8000: swap PROM, 8k, 08000, eax | ret
@A000: swap PROM, 8k, 0A000, eax | ret

; CCCCCCCx
@B000: shr eax 1 | swap CROM, 1k,  0000, eax | ret
@B001: shr eax 1 | swap CROM, 1k,  0400, eax | ret
@C000: shr eax 1 | swap CROM, 1k,  0800, eax | ret
@C001: shr eax 1 | swap CROM, 1k,  0C00, eax | ret
@D000: shr eax 1 | swap CROM, 1k, 01000, eax | ret
@D001: shr eax 1 | swap CROM, 1k, 01400, eax | ret
@E000: shr eax 1 | swap CROM, 1k, 01800, eax | ret
@E001: shr eax 1 | swap CROM, 1k, 01C00, eax | ret

@9000:

    ; xxxxxxMM
    and eax 3
    if eax = 0, mirror VERTICAL
    if eax = 1, mirror HORIZONTAL
    if eax = 2, mirror ONE_SCREEN_2000
    if eax = 3, mirror ONE_SCREEN_2400
    ret

____________________________________________________________________________________________
; Mapper #152

; $6000-$FFFF: MPPPCCCC - mirror $2000/$2400 (0/1)
;                       - swap 16k PROM at $8000
;                       - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper152:

    ; Memory mapping
    CPUWrite 06000, 0FFFF, @6000_FFFF

    ; Load last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@6000_FFFF:

    ; Mxxxxxxx
    ifNotFlag. eax 080
        mirror ONE_SCREEN_2000
    else
        mirror ONE_SCREEN_2400
    endif

    ; xxxxCCCC
    swap CROM, 8k,  00000, eax

    ; xPPPxxxx
    shr eax 4
    swap PROM, 16k, 00000, eax
    ret

____________________________________________________________________________________________
; Mapper #113, MB-91

; 4020-$7FFF: $8008-$8009: xHPPPCCC - swap 32k PROM at $8000 (HPPP)
;                                    - swap 8k  CROM at $0000 (HCCC)
; $8E66-$8E67:              xxxxxCCC - swap 8k  CROM at $0000 from bank 0/1 (CCC != 0 / CCC = 0)
; $E00A:                    xxxxxxxx - mirror $2000
____________________________________________________________________________________________

Mapper113:

    ; Memory mapping
    CPUWrite 04020, 07FFF, @4020_7FFF
    CPUWrite 08008, 08009, @8008_8009
    CPUWrite 08E66, 08E67, @8E66_8E67
    CPUWrite 0E00A, 0E00A, @E00A
    ret

@4020_7FFF:

    ; Mirroring hack
    if. D$Cartridge@PROMCRC32 = 0A75A_EDE5 ; HES 6-in-1
        mirror HORIZONTAL
        ifFlag eax 080, mirror VERTICAL
    endif

@8008_8009:

    ; xHxxxCCC
    mov edx eax | and edx 7
    ifFlag eax 040, or edx 08
    swap CROM, 8k, 00000, edx

    ; xHPPPxxx
    shr eax 3
    swap PROM, 32k, 08000, eax
    ret

@8E66_8E67:

    ; xxxxxCCC
    ifFlag. eax 7
        swap CROM, 8k, 00000, 0
    else
        swap CROM, 8k, 00000, 1
    endif
    ret

@E00A:

    mirror ONE_SCREEN_2000
    ret
____________________________________________________________________________________________
; Mapper #228. Action 52

; $8000-$FFFF: (address): 1xMPPPPP_PiSxCCCC - select 64k CROM segment
;                                           - mirror VERTICAL/HORIZONTAL (0/1)

;                 (data):          xxxxxxCC - swap 8k CROM at $0000 from selected segment
____________________________________________________________________________________________

Mapper228:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxMxxxxx_xxxxxxxx
    ifNotFlag. edx 02000
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxxxxxx_xxxxCCCC / xxxxxxCC
    push edx
        shl edx 2 | or eax edx
        swap CROM, 8k, 00000, eax
    pop edx

    ; xxxPPPPP_PiSxxxxx
    mov eax edx | shr edx 7
    and edx 03F
    ifFlag edx 020, and edx 02F ; if bit 5 is set, clear bit 4 (?)
    ; 16k game (S = 1)
    ifFlag. eax 020
        shl edx 2
        ifFlag eax 040, or edx 02
        swap PROM, 16k, 08000, edx
        swap PROM, 16k, 0C000, edx
    ; 32k game (S = 0)
    else
        swap PROM, 32k, 08000, edx
    endif
    ret

____________________________________________________________________________________________
; Mapper #041, Caltron 6-in-1

; $6000-$67FF: (LSB of address): 0xMSSPPP - swap 32k PROM at $8000
;                                         - mirror VERTICAL/HORIZONTAL (0/1)
;                                         - select 32k CROM segment
;                                         - memorize MSB of PROM select
; $8000-$FFFF: xxxxxxCC - (if MSB of PROM select = 1) swap 8k CROM from selected segment at $0000
____________________________________________________________________________________________

Mapper041:

    ; Set ports
    CPUWrite 06000, 067FF, @6000_67FF

    ; Enable CROM switching
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@6000_67FF:

    ; xxMxxxxx
    ifNotFlag. edx 020
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxxxPPP
    swap PROM, 32k, 08000, edx

    ; xxxxx!xx
    ifFlag. edx 4
        CPUWrite 08000, 0FFFF, @8000_FFFF
    else
        CPUWrite 08000, 0FFFF, WriteVoid
    endif

    ; xxxSSxxx
    shr edx 1 | and edx 0C
    mov D$Segment edx
    ret

@8000_FFFF:

    ; xxxxxxCC
    and eax 3
    or eax D$Segment
    swap CROM, 8k,  00000, eax
    ret

____________________________________________________________________________________________
; Mapper #062, 700-in-1

; $8000-$FFFF: (address): 1xPPPPPP_MPSCCCCC  - select 32k CROM segment
;                        (xx543210_x6xxxxxx) - swap 16k PROM at $8000, swap next 16k PROM at $C000
;                                            - (S = 1) 16k game, mirror $C000 from $8000
;                                            - mirror VERTICAL/HORIZONTAL (0/1)

;              (data):              xxxxxxCC - swap 8k bank from selected segment at $0000
____________________________________________________________________________________________

Mapper062:

    ; Set ports
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxxxxxxx_Mxxxxxxx
    ifNotFlag. edx 080
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxxxxxx_xxxCCCCC
    ; xxxxxxCC
    shl al 6 | mov ah dl
    shr ax 6
    swap CROM, 8k,  00000, eax

    ; xxPPPPPP_xPSxxxxx
    mov al dh | and eax 03F
    ifFlag edx 040, or eax 040
    ifNotFlag. edx 020
        shr eax 1
        swap PROM, 32k, 08000, eax
    else
        swap PROM, 16k, 08000, eax
        swap PROM, 16k, 0C000, eax
    endif
    ret

____________________________________________________________________________________________
; Mapper #229, 31-in-1

; $8000-$FFFF: (LSB of address): xxMBBBBB - swap 16k PROM at $8000 and $C000
;                                         - swap 8k  CROM at $0000
;                                         - mirror VERTICAL/HORIZONTAL (0/1)
____________________________________________________________________________________________

Mapper229:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxMxxxxx
    ifNotFlag. edx 020
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxPPPPP
    swap PROM, 16k, 08000, edx
    swap PROM, 16k, 0C000, edx
    ifNotFlag edx 01E, swap PROM, 32k, 08000, 0

    ; xxxCCCCC
    swap CROM, 8k,  00000, edx
    ret

____________________________________________________________________________________________
; Mapper #060, Reset-triggered 4-in-1

; $8000-$FFFF: (LSB of address): SPPpMCCC - (S = 1) swap 16k PROM at $8000 and $C000 from bank PPp
;                                         - (S = 0) swap 32k PROM at $8000 from bank PP
;                                         - swap 8k CROM at $0000
;                                         - mirror VERTICAL/HORIZONTAL (0/1)
____________________________________________________________________________________________

Mapper060:

    ; Increase bank number after each reset. (Stolen from Nestopia 1.08)
    ; Shouldn't this game have its own mapper number?
    if. D$Cartridge@PROMCRC32 = 0F9C484A0 ; Reset-triggered 4-in-1
        swap CROM, 8k,  00000, D$Game
        swap PROM, 16k, 08000, D$Game
        swap PROM, 16k, 0C000, D$Game
        inc D$Game | and D$Game 3
    else
        ; Set ports
        CPUWrite 08000, 0FFFF, @8000_FFFF
    endif
    ret

@8000_FFFF:

    ; xxxxMxxx
    ifNotFlag. edx 8
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    ; xxxxxCCC
    swap CROM, 8k, 00000, edx

    ; SPPpxxxx
    ifFlag. edx 080
        shr edx 4
        swap PROM, 16k, 08000, edx
        swap PROM, 16k, 0C000, edx
    else
        shr edx 5
        swap PROM, 32k, 08000, edx
    endif
    ret

____________________________________________________________________________________________
; Mapper #078, Jaleco (Cosmo Carrier)

; $8000-$FDFF: CCCCMPPP - swap 16k PROM at $8000
;                       - swap 8k  CROM at $0000
;                       - mirror $2000/$2400 (0/1)
;
; $FE00-$FFFF: CCCCxPPP - swap 16k PROM at $8000
;                       - swap 8k  CROM at $0000
____________________________________________________________________________________________

Mapper078:

    ; Memory mapping
    CPUWrite 08000, 0FDFF, @8000_FDFF
    CPUWrite 0FE00, 0FFFF, @FE00_FFFF

    ; Swap in last PROM bank at $C000
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000_FDFF:

    ; xxxxMxxx
    ifFlag. eax 8
        mirror ONE_SCREEN_2400
    else
        mirror ONE_SCREEN_2000
    endif

@FE00_FFFF:

    ; CCCCPPPP
    mov edx eax | and eax 0F | shr edx 4
    swap PROM, 16k, 08000, eax
    swap CROM, 8k,  00000, edx
    ret

____________________________________________________________________________________________
; Mapper #015, 100-in-1

; $8000: RMPPPPPP - swap 16k PROM $8000
;                 - swap 16k PROM (+1) at $C000
;                 - (R = 1) --> swap ($8000 <--> $A000) and ($C000 <--> $E000)
;                 - mirror VERTICAL/HORIZONTAL (0/1)
; $8001: PPPPPPPP - swap 16k PROM at $8000
;                 - swap last 16k PROM bank at $C000
;                 - mirror VERTICAL
; $8002: PxPPPPPP - swap 8k PROM at $8000, $A000, $C000 and $E000 (Rotate value left first)
; $8003: RMPPPPPP - swap 16k PROM $C000
;                 - (R = 1) --> swap ($8000 <--> $C000)
;                 - mirror VERTICAL/HORIZONTAL (0/1)
____________________________________________________________________________________________

Mapper015:

    ; Memory mapping
    CPUWrite 08000, 08000, @8000
    CPUWrite 08001, 08001, @8001
    CPUWrite 08002, 08002, @8002
    CPUWrite 08003, 08003, @8003
    ret

@8000:

    ifNotFlag. al 040
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif
    ; Hack for SMB1...
    if al = 048, mirror VERTICAL

    rol al 1
    swap PROM, 8k, 08000, eax | xor eax 1
    swap PROM, 8k, 0A000, eax | xor eax 1 | add eax 2
    swap PROM, 8k, 0C000, eax | xor eax 1
    swap PROM, 8k, 0E000, eax | xor eax 1
    ret

@8001:

    ifNotFlag. al 040
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    rol al 1
    swap PROM, 8k, 08000, eax | xor eax 1
    swap PROM, 8k, 0A000, eax | xor eax 1 | or eax 0FE
    swap PROM, 8k, 0C000, eax | xor eax 1
    swap PROM, 8k, 0E000, eax | xor eax 1 | or eax 0FE
    ret

@8002:

    ifNotFlag. al 040
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    rol al 1
    swap PROM, 8k, 08000, eax
    swap PROM, 8k, 0A000, eax
    swap PROM, 8k, 0C000, eax
    swap PROM, 8k, 0E000, eax
    ret

@8003:

    ifNotFlag. al 040
        mirror VERTICAL
    else
        mirror HORIZONTAL
    endif

    rol al 1
    swap PROM, 8k, 08000, eax | xor eax 1
    swap PROM, 8k, 0A000, eax | xor eax 1
    swap PROM, 8k, 0C000, eax | xor eax 1
    swap PROM, 8k, 0E000, eax | xor eax 1
    ret
____________________________________________________________________________________________
; Mapper #089, Sunsoft

; $8000-$FFFF: CPPPMCCC - swap 16k PROM at $8000
;                       - swap 8k  CROM at $0000
;                       - mirror $2000/$2400 (0/1)
____________________________________________________________________________________________

Mapper089:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Load last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000_FFFF:

    ; xxxxMxxx
    ifFlag. al 8
        mirror ONE_SCREEN_2400
    else
        mirror ONE_SCREEN_2000
    endif

    ; xPPPxxxx
    mov edx eax | shr edx 4
    swap PROM, 16k, 08000, edx

    ; CxxxxCCC
    ifFlag. eax 080
        and eax 7
        or  eax 8
    else
        and eax 7
    endif
    swap CROM, 8k, 00000, eax
    ret

____________________________________________________________________________________________
; Mapper #070

; $8000-$FFFF: MPPPCCCC - swap 8k  CROM at $0000
;                       - swap 16k PROM at $8000
;                       - mirror $2000/$2400 (0/1)
____________________________________________________________________________________________

Mapper070:

    ; Set ports
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Swap in last bank
    swap PROM, 16k, 0C000, LAST_BANK
    ret

@8000_FFFF:

    ; Mxxxxxxx
    ifNotFlag. eax 080
        mirror ONE_SCREEN_2000
        if D$Cartridge@PROMCRC32 = 0A59C_A2EF, ; Kamen Rider Kurabu (J)
            mirror VERTICAL
        if D$Cartridge@PROMCRC32 = 010BB_8F9A, ; Family Trainer - Manhattan Police (J)
            mirror VERTICAL
    else
        mirror ONE_SCREEN_2400
        if D$Cartridge@PROMCRC32 = 0A59C_A2EF, ; Kamen Rider Kurabu (J)
            mirror HORIZONTAL
        if D$Cartridge@PROMCRC32 = 010BB_8F9A, ; Family Trainer - Manhattan Police (J)
            mirror HORIZONTAL
    endif

    ; xxxxCCCC
    swap CROM, 8k,  00000, eax

    ; xPPPxxxx
    shr eax 4
    swap PROM, 16k, 08000, eax
    ret

; ____________________________________________________________________________________________
;
;                                 Special mappers
;
;____________________________________________________________________________________________

____________________________________________________________________________________________
; Mapper #185, CROM disable protect

; $8000-$FFFF: xxxxxxEE - CROM LengthEnabled/disabled (EE != 0 / EE = 0)
; [Hack for Spy vs Spy] - CROM LengthEnabled/disabled (xxExxxxE = $21 / xxExxxxE != $21
____________________________________________________________________________________________
[CROMDisabled Register]
Mapper185:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    PPURead 00000, 01FFF, @ReadDisabledCROM
    ret

@8000_FFFF:

    if. D$Cartridge@PROMCRC32 = 0B364_57C7 ; Spy vs Spy (J)
        ; xxExxxxE
        cmp eax 021 | setne B$CROMDisabled
    else
        ; xxxxxxEE
        test eax 3 | setz B$CROMDisabled
    endif
    ret

@ReadDisabledCROM:

    on B$CROMDisabled = &FALSE, ReadCROM
    mov eax 0FF
    ret

____________________________________________________________________________________________
; Mapper #013, CPROM

; $8000-$FFFF: xxPPxxCC - swap 4k  CRAM at $1000
;                       - swap 32k PROM at $8000
____________________________________________________________________________________________

Mapper013:

    ; Resize CRAM to 16k
    mov D$Cartridge@SizeCRAM 16

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF
    ret

@8000_FFFF:

    ; xxPPxxCC
    swap CRAM, 4k,  01000, eax | shr eax 4
    swap PROM, 32k, 08000, eax
    ret

____________________________________________________________________________________________
; Mapper #077, Irem

; $8000-$FFFF: CCCCxPPP - swap 32k PROM at $8000
;                       - swap 2k  CROM at $0000
____________________________________________________________________________________________

Mapper077:

    ; Memory mapping
    CPUWrite 08000, 0FFFF, @8000_FFFF

    ; Enable CRAM for $0800-$1FFF
    mov D$Cartridge@SizeCRAM 8
    swap CRAM, 8k, 00000, 0
    PPURead  0800, 01FFF, ReadCRAM
    PPUWrite 0800, 01FFF, WriteCRAM

    ; Enable CROM for $0000-$07FF
    swap CROM, 2k, 00000, 0
    ret

@8000_FFFF:

    ; CCCCxPPP
    swap PROM, 32k, 08000, eax | shr eax 4
    swap CROM, 2k,  00000, eax
    ret

____________________________________________________________________________________________
