TITLE NES

; The NES emulator.
; SetMode [PAL/NTSC] - sets the NES to emulate the PAL or NTSC NES.
; SetPower [POWER_ON/POWER_OFF] - toggles NES power
; RunOneFrame - runs the NES for one frame (NTSC: 1/60 second, PAL: 1/50 second)

____________________________________________________________________________________________
; PAL/NTSC differences
____________________________________________________________________________________________

SetMode:

    pop eax, D$CPUMode | push eax

    ; NTSC
    if. D$CPUMode = NTSC
        mov D$CPUCycles          NTSC_CPU_CYCLES
        mov D$PPUCycles          NTSC_PPU_CYCLES
        mov D$CyclesPerFrame     NTSC_CYCLES_PER_FRAME
        mov D$CyclesPerSample    NTSC_APU_CYCLES_PER_SAMPLE
        mov D$PPUCyclesInVBlank  NTSC_PPU_CYCLES_IN_VBLANK

        mov D$ScreenHeight       NTSC_SCREEN_BOTTOM-NTSC_SCREEN_TOP

        mov D$SourceRect+04      NTSC_SCREEN_TOP
        mov D$SourceRect+0C      NTSC_SCREEN_BOTTOM
    endif

    ; PAL
    if. D$CPUMode = PAL
        mov D$CPUCycles          PAL_CPU_CYCLES
        mov D$PPUCycles          PAL_PPU_CYCLES
        mov D$CyclesPerFrame     PAL_CYCLES_PER_FRAME
        mov D$CyclesPerSample    PAL_APU_CYCLES_PER_SAMPLE
        mov D$PPUCyclesInVBlank  PAL_PPU_CYCLES_IN_VBLANK

        mov D$ScreenHeight       PAL_SCREEN_BOTTOM-PAL_SCREEN_TOP

        mov D$SourceRect+04      PAL_SCREEN_TOP
        mov D$SourceRect+0C      PAL_SCREEN_BOTTOM
    endif
    ret

____________________________________________________________________________________________
; Power ON/OFF
____________________________________________________________________________________________

SetPower:

    ; Get argument
    pop eax, edx | push eax

    ; Power changed?
    ; (prevent battery save when power already is off)
    if edx = D$Power, ret
    mov D$Power edx

    ; Power OFF
    if. D$Power = POWER_OFF

        ; Save files
        if B$Cartridge@Battery = &TRUE, call SaveBattery
        call SaveGameGenie

        ; Zero out all RAM
        call ZeroMemory CPUMemory, (SIZE_CPU_MEMORY shl 2)
        call ZeroMemory PPUMemory, (SIZE_PPU_MEMORY shl 2)
        call ZeroMemory CPU (SIZE_CPU_REGS shl 2)
        call ZeroMemory HardResetData, LENGTH_HARDRESET_DATA

        ; Clear output
        call ClearVideo
        call ClearAudio

        ; Uncheck menu
        call 'User32.CheckMenuItem' D$hMenu, IDM_POWER, &MF_BYCOMMAND+&MF_UNCHECKED

    ; Power ON
    else

        ; Load files
        if B$Cartridge@Battery = &TRUE, call LoadBattery
        call LoadGameGenie

        ; Reset the NES
        mov B$S 0FF
        SetIRQ CPU, IRQ_RESET

        ; Check menu
        call 'User32.CheckMenuItem' D$hMenu, IDM_POWER, &MF_BYCOMMAND+&MF_CHECKED

    endif
    ret
____________________________________________________________________________________________
; Run one frame
____________________________________________________________________________________________

RunOneFrame:

    ; Interrupt?
L0: if D$CheckIRQLine != &FALSE, call HandleInterrupts

    ; Execute next opcode
    getNextByte
    copy D$InstructionTable+eax*4 D$Instruction
    call D$AddressingTable+eax*4

    ; Loop
    call PPUSynchronize
    call CartridgeSynchronize
    mov eax D$CyclesPerFrame
    on D$CPUClock < eax, L0<<

    ; Synchronize
    call PPUSynchronize
    call APUSynchronize
    call CartridgeSynchronize
    sub D$APUClock eax
    sub D$CPUClock eax
    sub D$PPUClock eax
    ;ifNotFlag D$IRQClock 08000_0000,
    sub D$IRQClock eax
    sub D$CartridgeClock eax
    ret
____________________________________________________________________________________________
; Data
____________________________________________________________________________________________

[SIZE_NES 7]
[NES:
 Power:              ?
 CPUMode:            ?
 CPUCycles:          ?
 PPUCycles:          ?
 CyclesPerFrame:     ?
 CyclesPerSample:    ?
 PPUCyclesInVBlank:  ?]

[NTSC 0  PAL 1]

[PAL_SCREEN_TOP             2
 PAL_SCREEN_BOTTOM          1+238
 PAL_CPU_CYCLES             16
 PAL_PPU_CYCLES             5
 PAL_CYCLES_PER_FRAME       531960  ; 312 scanlines * 341 cc * 5 PPU cc per Xtal cc
 PAL_APU_CYCLES_PER_SAMPLE  38      ; 50 frames * 531960 cc per frame / 16 cc per APU cc / 44100
 PAL_CPU_CYCLES_PER_SECOND  1662607
 PAL_PPU_CYCLES_IN_VBLANK   23870   ; 70 scanlines * 341 cc

NTSC_SCREEN_TOP             1+8
NTSC_SCREEN_BOTTOM          1+232
NTSC_CPU_CYCLES             12
NTSC_PPU_CYCLES             4
NTSC_CYCLES_PER_FRAME       357368  ; 262 scanlines * 341 cc * 4 PPU cc per Xtal cc
NTSC_APU_CYCLES_PER_SAMPLE  41      ; 60 frames * 357368 cc per frame / 12 cc per APU cc / 44100
NTSC_CPU_CYCLES_PER_SECOND  1789772
NTSC_PPU_CYCLES_IN_VBLANK   6820]   ; 20 scanlines * 341 cc

[POWER_OFF 0
 POWER_ON  1]
____________________________________________________________________________________________
