TITLE Menu

; Handles the main window menu.
; These functions are called upon WM_COMMAND messages

____________________________________________________________________________________________
; Hide/show menu
____________________________________________________________________________________________

Togglemenu:

    call 'User32.GetMenu' D$hMainWindow
    on eax != &NULL, HideMenu

    ShowMenu:

        call 'User32.SetMenu' D$hMainWindow, D$hMenu
        call UpdateCursor
        ret

    HideMenu:

        call 'User32.SetMenu' D$hMainWindow, &NULL
        call UpdateCursor
        ret
____________________________________________________________________________________________
; MRU list
____________________________________________________________________________________________

[LENGTH_MRULIST <(&MAX_PATH shl 4)>] ; Max 16 items
[nMRUItems: 5]
[MRUList: B$ ? #LENGTH_MRULIST]
[hMRUList: ?]
[IDM_RECENT 2000]

MenuRecentItem:

    [@Filename: ? #&MAX_PATH]
    call 'User32.GetMenuStringA' D$hMRUList, D$wParam, @Filename, &MAX_PATH, &MF_BYCOMMAND
    call DeleteMRUItem @Filename
    call LoadRemoteFile @Filename
    ret

AddMRUItem:

    arguments @pFilename

    call DeleteMRUItem D@pFilename

    ; Find an available slot
    mov edx D$nMRUItems
    mov edi MRUList, ecx 0-1, al 0
L0: if. B$edi != 0
        repne scasb
        dec edx | jnz L0<
    endif

    ; Place new string there
    mov B$edi 0
    call AddString edi, D@pFilename

    ; List full?
    if. edx = 0

        ; Find end
        repne scasb
        ; Source?
        push edi
            mov edi MRUList
            repne scasb
            mov esi edi
        ; Length?
        pop ecx
        sub ecx esi
        ; Dest?
        mov edi MRUList
        rep movsb

        ; End of list? Erase everything else
        mov ecx MRUList+LENGTH_MRULIST | sub ecx edi
        dec edi
        mov al 0 | rep stosb

    endif

    call UpdateMRUList
    call SaveConfiguration
    return

DeleteMRUItem:

    arguments @pFilename

    ; Search for filename in MRU list
    mov edi MRUList, ecx LENGTH_MRULIST, al 0
L0: mov esi D@pFilename
L1: if. B$edi != 0
        cmpsb | je L1<
        repne scasb
        on B$edi != 0, L0<
    else

        ; Filename found!
        inc edi
        move ecx edi-MRUList
        push edi
            sub edi 2
            std
                repne scasb | add edi 2
            cld
        pop esi
        mov ecx MRUList+LENGTH_MRULIST | sub ecx esi
        rep movsb

    endif

    call UpdateMRUList
    call SaveConfiguration
    return

UpdateMRUList:

    ; Renew menu
    if. D$hMRUList != &NULL
        call 'User32.DeleteMenu' D$hMenu, D$hMRUList, &MF_BYCOMMAND
        winErrorCheck 'Could not delete MRU list'
    endif
  . D$hMRUList = 'User32.CreatePopupMenu' | winErrorCheck 'Could not create MRU list'

    ; Fill list
    mov edi MRUList, ecx LENGTH_MRULIST, al 0, edx D$nMRUItems
L0: if. edx > 0

        ; Add item
        pushad
            add edx IDM_RECENT
            if B$edi != 0, call 'User32.InsertMenuA' D$hMRUList, 0, &MF_BYPOSITION, edx, edi
        popad
        dec edx
        repne scasb
        jmp L0<

    endif

    ; Insert menu
    call 'User32.GetSubMenu' D$hMenu, 0
    call 'User32.InsertMenuA' eax, IDM_EXIT-IDM_MENU, &MF_BYPOSITION+&MF_POPUP, D$hMRUList, {'Recent', 0}

    ; Empty? --> gray
    if B$MRUList = 0, call 'User32.EnableMenuItem' D$hMenu, D$hMRUList, &MF_BYCOMMAND+&MF_GRAYED
    if B$MRUList != 0, call 'User32.EnableMenuItem' D$hMenu, D$hMRUList, &MF_BYCOMMAND+&MF_ENABLED
    ret
____________________________________________________________________________________________
; Menu items
____________________________________________________________________________________________

; File
____________________________________________________________________________________________

MenuOpen:

    ; Open file dialog
    copy D$hMainWindow D$OpenFilename@hwndOwner
    copy D$hInstance   D$OpenFilename@hInstance
    call 'Comdlg32.GetOpenFileNameA' OpenFilename

    ; Open file
    if eax != 0, call LoadRemoteFile FullFilename
    endif
    ret

MenuClose:

    ; Unload cartridge
    call UnloadNES
    ret

MenuExit:

    ; Kill window
    call 'User32.DestroyWindow' D$hMainWindow
    ret

; NES
____________________________________________________________________________________________

MenuPower:

    ; Toggle NES power
    mov eax D$Power | xor eax POWER_ON
    call SetPower eax
    ret

MenuReset:

    ; Send a reset IRQ
    SetIRQ CPU, IRQ_RESET
    ret

MenuNTSC:

    ; Check radio button
    call 'User32.CheckMenuRadioItem' D$hMenu, IDM_NTSC, IDM_PAL, IDM_NTSC, &MF_BYCOMMAND

    ; Switch to NTSC
    call SetMode NTSC
    ret

MenuPAL:

    ; Check radio button
    call 'User32.CheckMenuRadioItem' D$hMenu, IDM_NTSC, IDM_PAL, IDM_PAL,  &MF_BYCOMMAND

    ; Switch to PAL
    call SetMode PAL
    ret

; Dialogs
____________________________________________________________________________________________

MenuGameGenie:   call LaunchDialog IDD_GAMEGENIE,   GameGenieDialogProc   | ret
MenuSaveGame:    call LaunchDialog IDD_SAVE,        SaveDialogProc        | ret
MenuLoadGame:    call LaunchDialog IDD_LOAD,        LoadDialogProc        | ret
MenuPreferences: call LaunchDialog IDD_PREFERENCES, PreferencesDialogProc | ret
MenuInput:       call LaunchDialog IDD_INPUT,       InputDialogProc       | ret
MenuAbout:       call LaunchDialog IDD_ABOUT,       AboutDialogProc       | ret

LaunchDialog:

    arguments @ID, @DialogProc
    call 'User32.DialogBoxParamA' D$hInstance, D@ID, D$hMainWindow, D@DialogProc, &NULL
    return

; Texts
____________________________________________________________________________________________

MenuLicense:    call LaunchFile {'license.txt',       0}, D$pLicense,   IDR_LICENSE   | ret
MenuChangelog:  call LaunchFile {'changelog.txt',     0}, D$pChangelog, IDR_CHANGELOG | ret
MenuManual:     call LaunchFile {'manual.chm', 0}, D$pManual,    IDR_MANUAL    | ret


LaunchFile:

    arguments @pFilename, @pRCData, @ResourceID

    ; Create file
    call 'Kernel32.GetTempPathA' &MAX_PATH, Filename
    call AddString Filename, D@pFilename
  . D$hFile = 'Kernel32.CreateFileA' Filename, &GENERIC_WRITE, &NULL, &NULL, &CREATE_ALWAYS, &FILE_ATTRIBUTE_NORMAL, &NULL
    if. D$hFile != &INVALID_HANDLE_VALUE

        ; Write and close
        call 'Kernel32.FindResourceA' D$hInstance, D@ResourceID, &RT_RCDATA
        call 'Kernel32.SizeofResource' D$hInstance, eax
        call 'Kernel32.WriteFile' D$hFile, D@pRCData, eax, Temp, &NULL
        call 'Kernel32.CloseHandle' D$hFile

        ; Open file
        call 'Shell32.ShellExecuteA' &NULL, &NULL, Filename, &NULL, &NULL, &TRUE

    endif
    return

____________________________________________________________________________________________
; Menu data
____________________________________________________________________________________________

enumerate 1000,

    IDM_MENU,
    IDM_OPEN,
    IDM_CLOSE,
    IDM_EXIT,

    IDM_POWER,
    IDM_RESET,
    IDM_NTSC,
    IDM_PAL,
    IDM_GAMEGENIE,
    IDM_SAVE,
    IDM_LOAD,

    IDM_PREFERENCES,
    IDM_INPUT,
    IDM_FULLSCREEN,

    IDM_MANUAL,
    IDM_LICENSE,
    IDM_CHANGELOG,
    IDM_ABOUT

[MenuItemTable:
 MenuOpen
 MenuClose
 MenuExit

 MenuPower
 MenuReset
 MenuNTSC
 MenuPAL
 MenuGameGenie
 MenuSaveGame
 MenuLoadGame

 MenuPreferences
 MenuInput
 ToggleFullscreen

 MenuManual
 MenuLicense
 MenuChangelog
 MenuAbout
 EndOfMenuItemTable: 0]
____________________________________________________________________________________________
