TITLE Mappers

; 0,1,2,3,4,5,6,7,9                             (8 - ???)
; 10,11,13,15,16,18                             (17 - mirroring)
; 21,22,23,24,25,26
; 32,33,34
; 40,41,44,45,46,49
; 50,51,52,57
; 60,61,62,65,66,67,68,69
; 70,71,72,73,75,76,77,78,79                    (74 - No other emu handles it either)
; 80,82,86,87,88,89                             (85 - vrc7 sound)
; 91,92,93,94,95,97                             (96 - CRAM switch, 99 - VS)
; 101
; 112,113,114,117,118,119
;
; 133
; 144
; 152,155                                       (151 - VS)
; 160
;
; 180,182,184,185,188,189
;                                               (198 - no ROMs)
;
;
; 225,226,227,228,229                           (222 - IRQ counter)
; 230,231,232,233,234,235
; 240,241,242,243,244,246,248                   (245 - supposed to be different)
; 250                                           (255)
[MapperTable:
 Mapper000 Mapper001 Mapper002 Mapper003 Mapper004 Mapper005 Mapper006 Mapper007 Mapper008 Mapper009
 Mapper010 Mapper011 &NULL     Mapper013 &NULL     Mapper015 Mapper016 Mapper017 Mapper018 Mapper019
 &NULL     Mapper021 Mapper022 Mapper023 Mapper024 Mapper025 Mapper026 &NULL     &NULL     &NULL
 &NULL     &NULL     Mapper032 Mapper033 Mapper034 &NULL     &NULL     &NULL     &NULL     &NULL
 Mapper040 Mapper041 Mapper042 &NULL     Mapper044 Mapper045 Mapper046 Mapper047 &NULL     Mapper049
 Mapper050 Mapper051 Mapper052 &NULL     &NULL     &NULL     &NULL     Mapper057 Mapper058 &NULL
 Mapper060 Mapper061 Mapper062 &NULL     &NULL     Mapper065 Mapper066 Mapper067 Mapper068 Mapper069
 Mapper070 Mapper071 Mapper072 Mapper073 Mapper074 Mapper075 Mapper076 Mapper077 Mapper078 Mapper079
 Mapper080 &NULL     Mapper082 Mapper083 &NULL     Mapper085 Mapper086 Mapper087 Mapper088 Mapper089
 &NULL     Mapper091 Mapper092 Mapper093 Mapper094 Mapper095 Mapper096 Mapper097 &NULL     Mapper099
 &NULL     Mapper101 &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL
 &NULL     &NULL     Mapper112 Mapper113 Mapper114 mapper115 &NULL     Mapper117 Mapper118 Mapper119
 &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL
 &NULL     &NULL     &NULL     Mapper133 &NULL     &NULL     &NULL     &NULL     &NULL     &NULL
 Mapper140 &NULL     &NULL     &NULL     Mapper144 &NULL     &NULL     &NULL     &NULL     &NULL
 &NULL     Mapper151 Mapper152 &NULL     &NULL     Mapper155 &NULL     &NULL     &NULL     &NULL
 Mapper160 &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL
 &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL
 Mapper180 &NULL     Mapper182 &NULL     Mapper184 Mapper185 &NULL     Mapper187 Mapper188 Mapper189
 &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     Mapper198 &NULL
 &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL
 &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL     &NULL
 &NULL     &NULL     Mapper222 &NULL     &NULL     Mapper225 Mapper226 Mapper227 Mapper228 Mapper229
 Mapper230 Mapper231 Mapper232 Mapper233 Mapper234 Mapper235 &NULL     &NULL     &NULL     &NULL
 Mapper240 Mapper241 Mapper242 Mapper243 Mapper244 Mapper245 Mapper246 &NULL     Mapper248 Mapper249
 Mapper250 &NULL     &NULL     &NULL     &NULL     Mapper255]

____________________________________________________________________________________________
; Mapper registers
____________________________________________________________________________________________
[LENGTH_MAPPER_DATA <(SIZE_MAPPER_DATA shl 2)>]
[LENGTH_HARDRESET_DATA 4]
[SIZE_MAPPER_DATA SIZE_INDEX+SIZE_REGISTERS+SIZE_MMC3+SIZE_IRQCOUNTER+1+SIZE_MMC5+1]
[SIZE_INDEX      020]
[SIZE_REGISTERS  020+020+5]
[SIZE_MMC3       6]
[SIZE_MMC5       23]
[SIZE_IRQCOUNTER 3]

[fnPROMUpdate:  ?]
[fnCROMUpdate:  ?]
[MapperData:

 ; Memory mapping
 IndexPROM:      ? #4
 IndexXRAM:      ? #4
 IndexCROM:      ? #8
 IndexCiROM:     ? #4
 IndexCRAM:      ? #8
 IndexCiRAM:     ? #4

 ; Mapper registers
 Register:      ? #020
 Bank:          ? #020
 Mode:          ?
 Offset:        ?
 Segment:       ?
 Latch:         ? ?

 ; MMC3 data
 WRAMEnabled:   ?
 Command:       ?
 A13:           ?
 Divide42:      ?
 Latched:       ?
 ResetIRQ:      ?

 ; IRQ counters
 IRQCounter:    ?
 IRQLatch:      ?
 IRQEnabled:    ?

 CartridgeClock:?

 ; MMC5
 IRQStop:       ?
 IRQStatus:     ?
 IRQClear:      ?

 PMode:         ?
 CMode:         ?
 GMode:         ?
 XRAMWrite:     ?
 XRAMEnabled:   ?

 FillCharacter: ?
 FillAttribute: ?

 SplitEnabled:  ?
 SplitFromRight:?
 SplitTile:     ?
 SplitScroll:   ?
 SplitOffset:   ?

 Factor1:       ?
 Factor2:       ?

 IndexBgROM:    ? #8

 HardResetData:
 Game:          ?]

[CROMBank Bank+000
 PROMBank Bank+040]
____________________________________________________________________________________________
; Bank switching
____________________________________________________________________________________________

[LAST_BANK 0FFFF]

; swap CROM, 4k, 01000, eax
[swap | #=4 | call Swap#1 LEN_#2, #3, #4]
[LEN_1K  0400
 LEN_2K  0800
 LEN_4K  01000
 LEN_8K  02000
 LEN_16K 04000
 LEN_32K 08000]

SwapCRAM:

    arguments @Length, @Address, @Bank
    call PPUSynchronize
    on D$Cartridge@SizeCRAM = 0, Q0>

    pushad

        ; Adjust bank number
        mov eax D@Bank
        mul D@Length
        mov ebx D$Cartridge@SizeCRAM | shl ebx 10 | mov edx 0 | div ebx | mov eax edx

        ; Update index
        mov ecx D@Length  | shr ecx 10
        mov ebx D@Address | shr ebx 10
    L0: mov D$IndexCRAM+ebx*4 eax | add eax 0400 | inc ebx | dec ecx | jnz L0<

    popad
Q0: return

SwapCiROM:

    arguments @Length, @Address, @Bank
    if D$Cartridge@SizeCROM = 0, return
    call PPUSynchronize

    pushad

        ; Adjust bank number
        mov eax D@Bank
        mul D@Length
        mov ebx D$Cartridge@SizeCROM | shl ebx 10 | mov edx 0 | div ebx | mov eax edx

        ; Update index
        mov ecx D@Length  | shr ecx 10
        mov ebx D@Address | shr ebx 10 | and ebx 03
    L0: mov D$IndexCiROM+ebx*4 eax | add eax 0400 | inc ebx | dec ecx | jnz L0<

    popad
    return

SwapCROM:

    on D$Cartridge@SizeCROM = 0, SwapCRAM

    arguments @Length, @Address, @Bank
    call PPUSynchronize

    pushad

        ; Adjust bank number
        mov eax D@Bank
        mul D@Length
        mov ebx D$Cartridge@SizeCROM | shl ebx 10 | mov edx 0 | div ebx | mov eax edx

        ; Update index
        mov ecx D@Length  | shr ecx 10
        mov ebx D@Address | shr ebx 10
    L0: mov D$IndexCROM+ebx*4 eax | add eax 0400 | inc ebx | dec ecx | jnz L0<

    popad
    return

SwapPROM:

    arguments @Length, @Address, @Bank
    on D$Cartridge@SizePROM = 0, Q0>
    pushad

        ; Adjust bank number
        mov eax D@Bank
        mul D@Length
        mov ebx D$Cartridge@SizePROM | shl ebx 10 | mov edx 0 | div ebx | mov eax edx

        ; Update index
        mov ecx D@Length  | shr ecx 13
        mov ebx D@Address | and ebx 07FFF | shr ebx 13
    L0: mov D$IndexPROM+ebx*4 eax | add eax 02000 | inc ebx | dec ecx | jnz L0<
    popad
Q0: return

____________________________________________________________________________________________
; Memory mapping
____________________________________________________________________________________________

ResetMemoryMapping:

    ; - Reads -

    CPURead  00000, 0FFFF, ReadVoid

    ; RAM
    CPURead  00000,  07FF, ReadRAM
    CPURead   0800, 01FFF, ReadMirrorRAM

    ; PPU registers
    CPURead  02000, 02007, Read200x
    CPURead  02002, 02002, Read2002
    CPURead  02004, 02004, Read2004
    CPURead  02007, 02007, Read2007
    CPURead  02008, 03FFF, ReadMirrorPPU

    ; APU registers
    CPURead  04015, 04015, Read4015
    CPURead  04016, 04016, Read4016
    CPURead  04017, 04017, Read4017

    ; Misc
    CPURead  06000, 07FFF, ReadWRAM
    CPURead  08000, 0FFFF, ReadPROM


    ; - Writes -

    CPUWrite 00000, 0FFFF, WriteVoid

    ; RAM
    CPUWrite 00000,  07FF, WriteRAM
    CPUWrite  0800, 01FFF, WriteMirrorRAM

    ; PPU registers
    CPUWrite 02000, 02000, Write2000
    CPUWrite 02001, 02001, Write2001
    CPUWrite 02002, 02002, Write2002
    CPUWrite 02003, 02003, Write2003
    CPUWrite 02004, 02004, Write2004
    CPUWrite 02005, 02005, Write2005
    CPUWrite 02006, 02006, Write2006
    CPUWrite 02007, 02007, Write2007
    CPUWrite 02008, 03FFF, WriteMirrorPPU

    ; APU registers
    CPUWrite 04000, 04000, Write4000
    CPUWrite 04001, 04001, Write4001
    CPUWrite 04002, 04002, Write4002
    CPUWrite 04003, 04003, Write4003
    CPUWrite 04004, 04004, Write4004
    CPUWrite 04005, 04005, Write4005
    CPUWrite 04006, 04006, Write4006
    CPUWrite 04007, 04007, Write4007
    CPUWrite 04008, 04008, Write4008
CPUWrite 04009, 04009, DoNothing
    CPUWrite 0400A, 0400A, Write400A
    CPUWrite 0400B, 0400B, Write400B
    CPUWrite 0400C, 0400C, Write400C
CPUWrite 0400D, 0400D, DoNothing
    CPUWrite 0400E, 0400E, Write400E
    CPUWrite 0400F, 0400F, Write400F
    CPUWrite 04010, 04010, Write4010
    CPUWrite 04011, 04011, Write4011
    CPUWrite 04012, 04012, Write4012
    CPUWrite 04013, 04013, Write4013

    ; Sprite DMA
    CPUWrite 04014, 04014, Write4014

    ; Channel enable
    CPUWrite 04015, 04015, Write4015

    ; I/O
    CPUWrite 04016, 04016, Write4016

    ; Frame counter
    CPUWrite 04017, 04017, Write4017

    ; Misc
    CPUWrite 06000, 07FFF, WriteWRAM
    ret
____________________________________________________________________________________________
